/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: pathname.c,v 1.8 1994/04/07 23:50:52 janssen Exp $
*/

#include <string.h>
#include <stdlib.h>	/* for getenv() */
#include <unistd.h>

extern void *Malloc(unsigned long size);
extern void Free(void *ptr);
extern void *Realloc (void *ptr, unsigned long size);

static char *gnu_getcwd (void)
     /* from the info pages to glibc */
{
  int size = 100;
  char *buffer = (char *) Malloc (size);
  
  while (1)
    {
      char *value = getcwd (buffer, size);
      if (value != 0)
	return buffer;
           size *= 2;
      Free (buffer);
      buffer = (char *) Malloc (size);
    }
}

char *CanonicalPathname (char *file)
{
  char *pathname;
  char *wd;
  unsigned int wdlen;

  if (*file == '/')
    {
      pathname = (char *) Malloc(strlen(file) + 1);
      strcpy (pathname, file);
    }
  else
    {
      wd = gnu_getcwd();
      wdlen = strlen(wd);

      if (*file == '.' && file[1] == '/')
	{
	  pathname = (char *) Malloc (strlen(file+1) + wdlen + 1);
	  strcpy (pathname, wd);
	  strcpy (pathname+wdlen, file+1);
	}
      else
	{
	  pathname = (char *) Malloc (strlen(file) + wdlen + 2);
	  strcpy (pathname, wd);
	  pathname[wdlen] = '/';
	  strcpy (pathname+wdlen+1, file);
	}
    }

  if (strncmp("/tmp_mnt", pathname, 8) == 0)
    memmove (pathname, pathname + 8, strlen(pathname+7));
  
  return (pathname);
}

char * /* result is NULL or full pathname */
  iluparser_GetProgramName (char *shortName)
{
  char *pathEnv;
  char *cwd;
  char *p, *q, *buf;
  int pathLen, shortNameLen, cwdLen, bufLen;
#   define INIT_BUFLEN 100

  if ((cwd = gnu_getcwd()) != NULL)
    cwdLen = strlen(cwd);
  else
    cwdLen = 0;

  if( shortName[0] == '/' ) {
    pathEnv = "/";
  } else if( strchr(shortName, '/') != NULL ) {
    if( cwdLen == 0 ) {
      return NULL;
    }
    pathEnv = cwd;
  } else {
    if( (pathEnv = (char *)(getenv("PATH"))) == NULL ) {
      return NULL;
    }
  }
  buf = (char *)Malloc(bufLen = INIT_BUFLEN);
  if( buf == NULL ) return NULL;
  shortNameLen = strlen(shortName);
  q = pathEnv;
  for(;;) {
    p = q;
    while( *p == ':' ) p++;
    if( *p == 0 ) return NULL;
    q = p;
    while( (*q != ':') && (*q != 0) ) q++;
    pathLen = (q - p);
    if( p[0] == '/' ) {
      if( pathLen >= bufLen ) {
	bufLen += pathLen;
	if( (buf = (char *)Realloc(buf, bufLen)) == NULL )
	  return NULL;
      }
      memcpy(buf, p, pathLen);
    } else {
      if( cwdLen == 0 ) continue;
      if( p[0] == '.' ) { p++; pathLen--; }
      if( (cwdLen + 1 + pathLen) >= bufLen ) {
	bufLen += (cwdLen + 1 + pathLen);
	if( (buf = (char *)Realloc(buf, bufLen)) == NULL )
	  return NULL;
      }
      memcpy(buf, cwd, cwdLen);
      buf[cwdLen] = '/';
      if( pathLen > 0 ) {
	memcpy(&(buf[cwdLen+1]), p, pathLen);
      }
      pathLen += (cwdLen+1);
    }
    if( (pathLen + 1 + shortNameLen) >= bufLen ) continue;
    buf[pathLen] = '/';
    if (strncmp(shortName, "./", 2) == 0)
      strcpy(buf+pathLen+1, shortName+2);
    else
      strcpy(buf+pathLen+1, shortName);
    if( access(buf, X_OK) != 0 ) continue;
    if (strncmp(buf, "/tmp_mnt/", 9) == 0)
      memmove (buf, buf+8, strlen(buf) - 7);
    return buf;
  }
  /*NOTREACHED*/
}
