/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: support-headers.c,v 1.17 1994/02/09 19:41:24 janssen Exp $
*/

#include "m3.h"

static boolean FirstItem = FALSE;

static void PrintEnumField (EnumField e, Context context)
{
  if (FirstItem)
    FirstItem = FALSE;
  else
    fprintf (context->file, ", ");
  fprintf (context->file, "%u (* %s *)", e->id, e->name);
}

static void GenerateInputOutputSizeDeclaration (Type type, Context context)
{
  enum PrimitiveTypes t = type_basic_type(type);
  boolean oldFirst;

  if ((TypeIsNonObjectStruct(type)
       OR (t == optional_Type)
       OR (t == enumeration_Type)
       OR (TypeIsArray(type)
	   AND ((list_size(type_description(type)->structuredDes.array.dimensions) > 1)
		OR ((type_basic_type(type_description(type)->structuredDes.array.type) != byte_Type)
		    AND (type_basic_type(type_description(type)->structuredDes.array.type) != shortcharacter_Type))))
       OR (t == sequence_Type
	   AND (type_basic_type(type_description(type)->structuredDes.sequence.type) != byte_Type)
	   AND (type_basic_type(type_description(type)->structuredDes.sequence.type) != shortcharacter_Type)))
      AND (t != object_Type)
      AND (type->importInterfaceName == NULL))
    {
      if (IsBulkyData(type))
	fprintf (context->file, "PROCEDURE Unmarshall_%s (call: IluRuntime.Call; VAR val : %s)\n  RAISES {IluBasics.Failed, Thread.Alerted};\n",
		 M3_SHORT_TYPE_NAME(type), M3_TYPE_NAME(type));
      else
	fprintf (context->file, "PROCEDURE Unmarshall_%s (call: IluRuntime.Call) : %s\n  RAISES {IluBasics.Failed, Thread.Alerted};\n",
		 M3_SHORT_TYPE_NAME(type), M3_TYPE_NAME(type));
      if (t != enumeration_Type)
	{
	  fprintf (context->file, "PROCEDURE ComputeMarshalledSize_%s (call: IluRuntime.Call; READONLY val: %s) : IluRuntime.Cardinal\n  RAISES {IluBasics.Failed, Thread.Alerted};\n",
		   M3_SHORT_TYPE_NAME(type), M3_TYPE_NAME(type));
	  if (t != optional_Type)
	    {
	      fprintf (context->file, "PROCEDURE Marshall_%s (call: IluRuntime.Call; READONLY val: %s)\n  RAISES {IluBasics.Failed, Thread.Alerted};\n",
		       M3_SHORT_TYPE_NAME(type), M3_TYPE_NAME(type));
	    }
	}
      else
	{
	  fprintf (context->file, "CONST %s__EnumValues = ARRAY[0..%u] OF IluRuntime.EnumOrd {\n",
		   M3_SHORT_TYPE_NAME(type), list_size(type_description(type)->structuredDes.enumeration) - 1);
	  oldFirst = FirstItem;  FirstItem = TRUE;
	  list_enumerate(type_description(type)->structuredDes.enumeration, (EnumProc) PrintEnumField, context);
	  FirstItem = oldFirst;
	  fprintf (context->file, "};\n");
	}
      fprintf (context->file, "\n");
    }
}

static void generate_support_header_includes (Context context)
{
  fprintf (context->file, "IMPORT Ilu, IluBasics, IluRuntime, Thread, %s;\n",
	   m3_interface_name(context->interface));
  list_enumerate (context->interface->imports, (EnumProc) ImportInterface, context);
  fprintf (context->file, "\n");
}

static void ListException1 (Exception e, Context context)
{
  if (e->importInterfaceName != NULL)
    return;

  if (NOT FirstItem)
    fprintf (context->file, ", ");
  else
    FirstItem = FALSE;
  fprintf (context->file, "%s", M3_SHORT_EXCEPTION_NAME(e));
}

static void ListException2 (Exception e, Context context)
{
  if (NOT FirstItem)
    fprintf (context->file, ", ");
  else
    FirstItem = FALSE;
  fprintf (context->file, "%s", M3_EXCEPTION_NAME(e));
}

static void ListMethod (Procedure m, Context context)
{
  if (NOT FirstItem)
    fprintf (context->file, ", ");
  else
    FirstItem = FALSE;
  fprintf (context->file, "%s", M3_SHORT_METHOD_NAME(m));
}

static void ListClassMethods (Type st, Context context)
{
  Type t;
  Class od;

  if (st == NULL OR (t = ultimateType(st)) == NULL OR t->marked
      OR type_basic_type(t) != object_Type OR (od = class_object(t)) == NULL)
    return;
  t->marked = TRUE;
  list_enumerate(od->superclasses, (EnumProc) ListClassMethods, context);
  list_enumerate(od->methods, (EnumProc) ListMethod, context);
}

static void ListClientAndServerStubs (Procedure m, Context context)
{
  extern void ListArgument (Argument, Context);
  extern void ListExceptionName (Exception, Context);

  fprintf (context->file, "PROCEDURE Client__%s_%s (self : %s",
	   M3_SHORT_TYPE_NAME(m->object), M3_SHORT_METHOD_NAME(m), M3_TYPE_NAME(m->object));
  list_enumerate (m->arguments, (EnumProc) ListArgument, context);
  fprintf (context->file, ")%s%s\n",
	   (type_basic_type(m->returnType) != void_Type) ? ": " : "",
	   (type_basic_type(m->returnType) != void_Type) ? M3_TYPE_NAME(m->returnType) : "");
  fprintf (context->file, "  RAISES {IluBasics.Failed, Thread.Alerted");
  if (list_size(m->exceptions) > 0)
    list_enumerate(m->exceptions, (EnumProc) ListExceptionName, context);
  fprintf (context->file, "};\n");

  fprintf (context->file, "PROCEDURE Server__%s_%s (call : IluRuntime.Call)\n",
	   M3_SHORT_TYPE_NAME(m->object), M3_SHORT_METHOD_NAME(m));
  fprintf (context->file, "  RAISES {IluBasics.Failed, Thread.Alerted};\n");
}

static void ListStubs (Type t, Context context)
{
  Class od;

  if (t == NULL OR type_basic_type(t) != object_Type OR (od = class_object(t)) == NULL)
    return;

  list_enumerate(od->methods, (EnumProc) ListClientAndServerStubs, context);
}

static void GenerateClassOverhead (Type c, Context context)
{
  boolean oldFirst;

  if (c->importInterfaceName == NULL)
    {
      fprintf (context->file, "TYPE Surrogate__%s <: %s;\n", M3_SHORT_TYPE_NAME(c), M3_TYPE_NAME(c));
      fprintf (context->file, "TYPE MethodNames__%s = {", M3_SHORT_TYPE_NAME(c));
      oldFirst = FirstItem;  FirstItem = TRUE;
/*
      UnmarkSupertypes (c);
      ListClassMethods (c, context);
*/
      list_enumerate(class_object(c)->methods, (EnumProc) ListMethod, context);
      FirstItem = oldFirst;
      fprintf (context->file, "};\n");
      fprintf (context->file, "VAR Methods__%s: ARRAY MethodNames__%s OF IluRuntime.Method_Rec;\n",
	       M3_SHORT_TYPE_NAME(c), M3_SHORT_TYPE_NAME(c));
      fprintf (context->file, "VAR ObjectType_%s: IluRuntime.ObjectType;\n", M3_SHORT_TYPE_NAME(c));

      fprintf (context->file, "PROCEDURE Create_Lead__%s (self : IluRuntime.ObjectCreator;\n  server : Ilu.SurrogateServer) : IluRuntime.M3Obj;\n", M3_SHORT_TYPE_NAME(c));
      
      fprintf (context->file, "PROCEDURE Init_Surrogate__%s (self: Surrogate__%s;\n",
	       M3_SHORT_TYPE_NAME(c), M3_SHORT_TYPE_NAME(c));
      fprintf (context->file, "  server: Ilu.SurrogateServer);\n\n");

      ListStubs (c, context);
    }
}

void generate_support_headers (Interface i, FILE *file)
{
  struct context_s context;
  boolean oldFirst;

  context.file = file;
  context.interface = i;
  context.class = NULL;
  context.module = InternalInterface;

  generate_boilerplate(file, i);

  fprintf (file, "INTERFACE %s_x;\n", m3_interface_name(i));

  generate_support_header_includes (&context);

  if (i->exceptions != NULL AND list_size(i->exceptions) > 0)
    {
      fprintf (file, "\n(* Exception vector *)\n");
      fprintf (file, "VAR Exception_Reps: RECORD ");
      oldFirst = FirstItem;  FirstItem = TRUE;
      list_enumerate (i->exceptions, (EnumProc) ListException1, &context);
      FirstItem = oldFirst;
      fprintf (file, ": IluRuntime.Exception END;\n\n");

      fprintf (file, "\n(* Procedure to read and re-signal exception *)\n\n");
      fprintf (file, "PROCEDURE ReSignal_Exception (call: IluRuntime.Call; scode: INTEGER)\n  RAISES {IluBasics.Failed, Thread.Alerted");
      oldFirst = FirstItem;  FirstItem = FALSE;
      list_enumerate (i->exceptions, (EnumProc) ListException2, &context);
      FirstItem = oldFirst;
      fprintf (file, "};\n\n");
    }

  fprintf (file, "(* Support for classes *)\n\n");
  list_enumerate (i->classes, (EnumProc) GenerateClassOverhead, &context);

  fprintf (file, "\n(* Marshalling routines for constructed types *)\n\n");

  list_enumerate (i->types, (EnumProc) GenerateInputOutputSizeDeclaration, &context);

  fprintf (file, "PROCEDURE BeStarted();\n\n");
  fprintf (file, "END %s_x.\n", m3_interface_name(i));
}
