/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#ifndef _AST_DECL_AST_DECL_HH
#define _AST_DECL_AST_DECL_HH

#pragma ident "%@(#)AST_Decl.h	1.38% %92/06/10% Sun Microsystems"

// Rock bottom of AST class hierarchy
//
// This class is inherited by all classes which represent named entities
// in IDL. It implements the line and file recording mechanism and also
// records the type of the node. This may be useful for BEs to be able
// to distinguish the real type of a node given only a superclass.

/*
** DEPENDENCIES: utl_scope.hh, utl_scoped_name.hh, utl_strlist.hh
**
** USE: Included from ast.hh
*/

class	AST_Decl
{
public:
  // Enum defining the different kinds of AST nodes
  enum NodeType {
        NT_module				// Denotes a module
      , NT_interface				// Denotes an interface
      , NT_interface_fwd			// Fwd declared interface
      , NT_const				// Denotes a constant
      , NT_except				// Denotes an exception
      , NT_attr					// Denotes an attribute
      , NT_op					// Denotes an operation
      , NT_argument				// Denotes an op. argument
      , NT_union				// Denotes a union
      , NT_union_branch				// Denotes a union branch
      , NT_struct				// Denotes a structure
      , NT_field				// Denotes a field in structure
      , NT_enum					// Denotes an enumeration
      , NT_enum_val				// Denotes an enum. value
      , NT_string				// Denotes an IDL string
      , NT_array				// Denotes an IDL array
      , NT_sequence				// Denotes an IDL sequence
      , NT_typedef				// Denotes a typedef
      , NT_pre_defined				// Denotes a predefined type
  };

  // Operations

  // Constructor(s)
  AST_Decl();
  AST_Decl(NodeType type, UTL_ScopedName *n, UTL_StrList *pragmas);

  // Data Accessors
  boolean in_main_file();
  void set_in_main_file(boolean is_it);
  UTL_Scope *defined_in();
  void set_defined_in(UTL_Scope *);
  NodeType node_type();
  long line();
  void set_line(long l);
  String *file_name();
  void set_file_name(String *s);
  UTL_ScopedName *name();
  void set_name(UTL_ScopedName *n);
  String *local_name();
  UTL_StrList *pragmas();

  // Narrowing
  DEF_NARROW_METHODS0(AST_Decl);
  DEF_NARROW_FROM_DECL(AST_Decl);

  // AST Dumping
  virtual void			dump(ostream &o);

  // Other operations

  // Return TRUE if "this" has "s" as an ancestor
  boolean			has_ancestor(AST_Decl *s);

private:
  // Data
  boolean			pd_in_main_file; // Defined in main file?
  UTL_Scope			*pd_defined_in;	// Scope
  NodeType			pd_node_type;	// What kind of node
  long				pd_line;	// Line defined in
  String			*pd_file_name;	// What file defined in
  UTL_ScopedName		*pd_name;	// As given
  String			*pd_local_name;	// Name in scope
  UTL_StrList			*pd_pragmas;	// Pragmas

  // Operations

  // Compute the full name of an AST node
  void				compute_full_name(UTL_ScopedName *n);
};

#endif           // _AST_DECL_AST_DECL_HH
