# include <stdio.h>
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) (void)putc(c,yyout)
#if defined(__cplusplus) || defined(__STDC__)
#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
	int yyback(int *, int);
	int yyinput(void);
	int yylook(void);
	void yyoutput(int);
	int yyracc(int);
	int yyreject(void);
	void yyunput(int);
	int yylex(void);
#ifndef yyless
	void yyless(int);
#endif
#ifndef yywrap
	int yywrap(void);
#endif
#ifdef LEXDEBUG
	void allprint(char);
	void sprint(char *);
#endif
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif
#endif
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO (void)fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

# line 6 "idl.ll.i"
/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */



# line 59 "idl.ll.i"
/*
 * idl.ll - Lexical scanner for IDL 1.1
 */


#include <idl.hh>
#include <idl_extern.hh>

#include <fe_private.hh>

#include <y.tab.hh>

static char	idl_escape_reader(char **);
static double	idl_atof(char *);
static unsigned long	idl_atoi(char *, long);
static void	idl_parse_line_and_file(char *);
static void	idl_store_pragma(char *);

// HPUX has yytext typed to unsigned char *. We make sure here that
// we'll always use char *
static char	*__yytext = (char *) yytext;

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

# line 84 "idl.ll.i"
	return MODULE;
break;
case 2:

# line 85 "idl.ll.i"
	return RAISES;
break;
case 3:

# line 86 "idl.ll.i"
return READONLY;
break;
case 4:

# line 87 "idl.ll.i"
return ATTRIBUTE;
break;
case 5:

# line 88 "idl.ll.i"
return EXCEPTION;
break;
case 6:

# line 89 "idl.ll.i"
	return CONTEXT;
break;
case 7:

# line 90 "idl.ll.i"
return INTERFACE;
break;
case 8:

# line 91 "idl.ll.i"
	return CONST;
break;
case 9:

# line 92 "idl.ll.i"
	return TYPEDEF;
break;
case 10:

# line 93 "idl.ll.i"
	return STRUCT;
break;
case 11:

# line 94 "idl.ll.i"
	return ENUM;
break;
case 12:

# line 95 "idl.ll.i"
	return STRING;
break;
case 13:

# line 96 "idl.ll.i"
return SEQUENCE;
break;
case 14:

# line 97 "idl.ll.i"
	return UNION;
break;
case 15:

# line 98 "idl.ll.i"
	return SWITCH;
break;
case 16:

# line 99 "idl.ll.i"
	return CASE;
break;
case 17:

# line 100 "idl.ll.i"
	return DEFAULT;
break;
case 18:

# line 101 "idl.ll.i"
	return FLOAT;
break;
case 19:

# line 102 "idl.ll.i"
	return DOUBLE;
break;
case 20:

# line 103 "idl.ll.i"
	return LONG;
break;
case 21:

# line 104 "idl.ll.i"
	return SHORT;
break;
case 22:

# line 105 "idl.ll.i"
return UNSIGNED;
break;
case 23:

# line 106 "idl.ll.i"
	return CHAR;
break;
case 24:

# line 107 "idl.ll.i"
	return BOOLEAN;
break;
case 25:

# line 108 "idl.ll.i"
	return OCTET;
break;
case 26:

# line 109 "idl.ll.i"
	return VOID;
break;
case 27:

# line 111 "idl.ll.i"
	return TRUETOK;
break;
case 28:

# line 112 "idl.ll.i"
	return FALSETOK;
break;
case 29:

# line 114 "idl.ll.i"
	return INOUT;
break;
case 30:

# line 115 "idl.ll.i"
	return IN;
break;
case 31:

# line 116 "idl.ll.i"
	return OUT;
break;
case 32:

# line 117 "idl.ll.i"
	return ONEWAY;
break;
case 33:

# line 119 "idl.ll.i"
	return LEFT_SHIFT;
break;
case 34:

# line 120 "idl.ll.i"
	return RIGHT_SHIFT;
break;
case 35:

# line 121 "idl.ll.i"
	{
		  yylval.sval = new String("::");
		  return SCOPE_DELIMITOR;
		}
break;
case 36:

# line 126 "idl.ll.i"
{
		  yylval.sval = new String(__yytext);
		  return IDENTIFIER;
		}
break;
case 37:

# line 132 "idl.ll.i"
     {
                  yylval.dval = idl_atof(__yytext);
                  return FLOATING_PT_LITERAL;
                }
break;
case 38:

# line 136 "idl.ll.i"
 {
                  yylval.dval = idl_atof(__yytext);
                  return FLOATING_PT_LITERAL;
                }
break;
case 39:

# line 141 "idl.ll.i"
{
		  yylval.ival = idl_atoi(__yytext, 10);
		  return INTEGER_LITERAL;
	        }
break;
case 40:

# line 145 "idl.ll.i"
{
		  yylval.ival = idl_atoi(__yytext, 16);
		  return INTEGER_LITERAL;
	        }
break;
case 41:

# line 149 "idl.ll.i"
{
		  yylval.ival = idl_atoi(__yytext, 8);
		  return INTEGER_LITERAL;
	      	}
break;
case 42:

# line 154 "idl.ll.i"
{
		  __yytext[strlen(__yytext)-1] = '\0';
		  yylval.sval = new String(__yytext + 1);
		  return STRING_LITERAL;
	      	}
break;
case 43:

# line 159 "idl.ll.i"
{
		  char *src = __yytext + 1;
		  char *dst = __yytext;
		  int ch;

		  while ((ch = *src++) != '"') {
		    if (ch == '\\')
		      ch = idl_escape_reader(&src);
		    *dst++ = ch;
		  }
		  *dst = 0;
		  yylval.sval = new String(__yytext);
		  return STRING_LITERAL;
	      	}
break;
case 44:

# line 173 "idl.ll.i"
	{
		  yylval.cval = __yytext[1];
		  return CHARACTER_LITERAL;
	      	}
break;
case 45:

# line 177 "idl.ll.i"
{
		  char *cursor = __yytext + 2;
		  yylval.cval = idl_escape_reader(&cursor);
		  return CHARACTER_LITERAL;
		}
break;
case 46:

# line 182 "idl.ll.i"
{
		  char *cursor = __yytext + 2;
		  yylval.cval = idl_escape_reader(&cursor);
		  return CHARACTER_LITERAL;
		}
break;
case 47:

# line 187 "idl.ll.i"
{
  		  idl_global->set_lineno(idl_global->lineno() + 1);
		  idl_store_pragma(__yytext);
		}
break;
case 48:

# line 191 "idl.ll.i"
	{
		  idl_parse_line_and_file(__yytext);
		}
break;
case 49:

# line 194 "idl.ll.i"
		{
		  idl_parse_line_and_file(__yytext);
		}
break;
case 50:

# line 197 "idl.ll.i"
{
		  idl_parse_line_and_file(__yytext);
	        }
break;
case 51:

# line 200 "idl.ll.i"
	;
break;
case 52:

# line 201 "idl.ll.i"
	{
  		  idl_global->set_lineno(idl_global->lineno() + 1);
		}
break;
case 53:

# line 204 "idl.ll.i"
	return __yytext[0];
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
	/* subroutines */

/*
 * Strip down a name to the last component, i.e. everything after the last
 * '/' character
 */

static char *
stripped_name(UTL_String *fn)
{
    char	*n = fn->get_string();
    long	l;

    if (n == NULL)
	return NULL;
    l = strlen(n);
    for (n += l; l > 0 && *n != '/'; l--, n--);
    if (*n == '/') n++;
    return n;
}
    
/*
 * Parse a #line statement generated by the C preprocessor
 */

static void
idl_parse_line_and_file(char *buf)
{
  char		*r = buf;
  char 		*h;
  UTL_String	*nm;

  /* Skip initial '#' */
  if (*r != '#') {
    return;
  }

  /* Find line number */
  for (r++; *r == ' ' || *r == '\t'; r++);
  h = r;
  for (; *r != '\0' && *r != ' ' && *r != '\t'; r++);
  *r++ = 0;
  idl_global->set_lineno(idl_atoi(h, 10));
  
  /* Find file name, if present */
  for (; *r != '"'; r++) {
    if (*r == '\n' || *r == '\0')
      return;
  }
  h = ++r;
  for (; *r != '"'; r++);
  *r = 0;
  if (*h == '\0')
    idl_global->set_filename(new String("standard input"));
  else
    idl_global->set_filename(new String(h));

  idl_global->set_in_main_file(
    (idl_global->filename()->compare(idl_global->main_filename())) ?
    TRUE :
    FALSE
  );
  /*
   * If it's an include file store the stripped name for the BE to use
   */

  if (!(idl_global->in_main_file())) {
    nm = new UTL_String(stripped_name(idl_global->filename()));
    idl_global->store_include_file_name(nm);
  }
}
    
/*
 * Store a #pragma line into the list of pragmas
 */

static void
idl_store_pragma(char *buf)
{
  if (idl_global->pragmas() == NULL)
    idl_global->set_pragmas(new UTL_StrList(new String(buf), NULL));
  else
    idl_global->pragmas()->nconc(new UTL_StrList(new String(buf), NULL));
}

/*
 * idl_atoi - Convert a string of digits into an integer according to base b
 */

static unsigned long
idl_atoi(char *s, long b)
{
	unsigned long	r = 0;

	if (b == 8 && *s == '0')
	  s++;
	else if (b == 16 && *s == '0' && (*(s + 1) == 'x' || *(s + 1) == 'X'))
	  s += 2;

	for (; *s; s++)
	  if (*s <= '9' && *s >= '0')
	    r = (r * b) + (*s - '0');
	  else if (b > 10 && *s <= 'f' && *s >= 'a')
	    r = (r * b) + (*s - 'a' + 10);
	  else if (b > 10 && *s <= 'F' && *s >= 'A')
	    r = (r * b) + (*s - 'A' + 10);
	  else
	    break;

	return r;
}

/*
 * Convert a string to a float; atof doesn't seem to work, always.
 */

static double
idl_atof(char *s)
{
	char    *h = s;
	double	d = 0.0;
	double	f = 0.0;
	double	e, k;
	long	neg = 0, negexp = 0;

	if (*s == '-') {
	  neg = 1;
	  s++;
	}
	while (*s >= '0' && *s <= '9') {
		d = (d * 10) + *s - '0';
		s++;
	}
	if (*s == '.') {
		s++;
		e = 10;
		while (*s >= '0' && *s <= '9') {
			d += (*s - '0') / (e * 1.0);
			e *= 10;
			s++;
		}
	}
	if (*s == 'e' || *s == 'E') {
		s++;
		if (*s == '-') {
			negexp = 1;
			s++;
		} else if (*s == '+')
			s++;
		e = 0;
		while (*s >= '0' && *s <= '9') {
			e = (e * 10) + *s - '0';
			s++;
		}
		if (e > 0) {
			for (k = 1; e > 0; k *= 10, e--);
			if (negexp)
				d /= k;
			else
				d *= k;
		}
	}

	if (neg) d *= -1.0;

	return d;
}	

/*
 * Convert (some) escaped characters into their ascii values
 */

static char
idl_escape_reader(
    char **p_cursor
)
{
    int ch = *(*p_cursor)++;

    switch (ch) {
      case 'n':
	return '\n';
      case 't':
	return '\t';
      case 'v':
	return '\v';
      case 'b':
	return '\b';
      case 'r':
	return '\r';
      case 'f':
	return '\f';
      case 'a':
	return '\a';
      case '\\':
	return '\\';
      case '\?':
	return '?';
      case '\'':
	return '\'';
      case '"':
	return '"';
      case 'x':
	{
	    // hex value
	    int out = 0;
	    for (int i = 0; i < 2 && isxdigit(ch = **p_cursor); i++) {
		out = out * 16 + ch -
			(isdigit(ch) ? '0' : ch >= 'a' ? 'a' - 10 : 'A' - 10);
		*p_cursor += 1;
	    }
	    return out;
	}
	break;
      default:
	// check for octal value
	if (ch >= '0' && ch <= '7') {
	    int out = ch - '0';
	    for (int i = 0; i < 2 && (ch = **p_cursor) >= '0' && ch <= '7'; i++)
		out = out * 8 + ch - '0', *p_cursor += 1;
	    return out;
	} else {
	  return ch - 'a';
	}
	break;
    }
}
int yyvstop[] = {
0,

51,
0,

51,
0,

53,
0,

51,
53,
0,

52,
0,

53,
0,

53,
0,

53,
0,

41,
53,
0,

39,
53,
0,

53,
0,

53,
0,

53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

36,
53,
0,

53,
0,

51,
0,

42,
43,
0,

37,
0,

41,
0,

39,
0,

35,
0,

33,
0,

34,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

30,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

44,
0,

44,
0,

37,
0,

38,
0,

40,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

31,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

50,
0,

43,
0,

46,
0,

45,
46,
0,

37,
0,

38,
0,

36,
0,

27,
36,
0,

36,
0,

36,
0,

16,
36,
0,

23,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

11,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

20,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

26,
36,
0,

45,
0,

28,
36,
0,

36,
0,

36,
0,

8,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

18,
36,
0,

29,
36,
0,

36,
0,

36,
0,

25,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

21,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

14,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

19,
36,
0,

36,
0,

36,
0,

1,
36,
0,

32,
36,
0,

2,
36,
0,

36,
0,

36,
0,

12,
36,
0,

10,
36,
0,

15,
36,
0,

36,
0,

36,
0,

49,
0,

36,
0,

24,
36,
0,

6,
36,
0,

17,
36,
0,

36,
0,

36,
0,

36,
0,

36,
0,

9,
36,
0,

36,
0,

48,
0,

36,
0,

36,
0,

36,
0,

3,
36,
0,

13,
36,
0,

22,
36,
0,

47,
0,

4,
36,
0,

5,
36,
0,

7,
36,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
0,0,	4,33,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,6,	
4,33,	0,0,	0,0,	0,0,	
1,7,	0,0,	0,0,	37,80,	
1,3,	0,0,	1,8,	0,0,	
0,0,	1,9,	1,10,	0,0,	
0,0,	32,76,	0,0,	0,0,	
39,40,	1,10,	76,76,	1,11,	
0,0,	1,12,	11,45,	1,13,	
12,46,	2,32,	1,14,	13,47,	
81,123,	2,7,	1,14,	1,15,	
1,14,	15,49,	0,0,	2,8,	
32,77,	1,14,	0,0,	39,42,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,16,	16,50,	0,0,	
2,11,	1,14,	2,12,	0,0,	
2,13,	1,3,	0,0,	90,130,	
1,3,	0,0,	1,17,	1,18,	
1,19,	1,20,	1,21,	1,22,	
27,67,	49,89,	1,23,	0,0,	
27,68,	1,24,	1,25,	39,42,	
1,26,	20,56,	2,16,	1,27,	
1,28,	1,29,	1,30,	1,31,	
17,51,	18,52,	22,60,	20,57,	
23,61,	6,34,	24,62,	2,17,	
2,18,	2,19,	2,20,	2,21,	
2,22,	6,34,	6,34,	2,23,	
19,53,	25,63,	2,24,	2,25,	
29,73,	2,26,	21,58,	19,54,	
2,27,	2,28,	2,29,	2,30,	
2,31,	30,74,	19,55,	31,75,	
21,59,	26,64,	7,37,	50,90,	
32,78,	51,91,	6,35,	52,92,	
53,93,	54,94,	7,37,	7,0,	
26,65,	55,95,	28,69,	6,34,	
56,96,	28,70,	57,97,	26,66,	
6,34,	6,34,	58,98,	59,99,	
60,100,	61,101,	62,103,	63,104,	
6,34,	28,71,	61,102,	64,105,	
28,72,	65,106,	66,107,	7,37,	
67,108,	6,34,	68,109,	69,110,	
70,111,	6,34,	6,34,	6,34,	
7,37,	71,112,	72,113,	73,114,	
6,34,	7,37,	7,37,	74,115,	
75,117,	78,121,	89,129,	91,131,	
87,128,	7,37,	92,132,	93,133,	
6,34,	74,116,	87,128,	94,134,	
6,36,	96,137,	7,37,	6,34,	
95,135,	95,136,	7,37,	7,37,	
7,37,	97,138,	98,139,	99,140,	
100,141,	7,37,	8,39,	8,39,	
8,39,	8,39,	8,39,	8,39,	
8,39,	8,39,	8,39,	8,39,	
87,128,	7,37,	101,142,	102,143,	
103,144,	7,38,	87,128,	9,40,	
7,37,	9,41,	9,41,	9,41,	
9,41,	9,41,	9,41,	9,41,	
9,41,	9,39,	9,39,	41,41,	
41,41,	41,41,	41,41,	41,41,	
41,41,	41,41,	41,41,	41,39,	
41,39,	10,40,	9,42,	10,44,	
10,44,	10,44,	10,44,	10,44,	
10,44,	10,44,	10,44,	10,44,	
10,44,	104,145,	105,146,	106,147,	
83,124,	108,148,	109,149,	110,150,	
111,151,	9,43,	113,154,	112,152,	
10,42,	83,125,	83,125,	83,125,	
83,125,	83,125,	83,125,	83,125,	
83,125,	114,155,	9,42,	112,153,	
115,156,	116,157,	117,158,	121,161,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	119,76,	129,164,	
119,159,	9,43,	131,165,	132,166,	
10,42,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	135,167,	
136,168,	137,169,	138,170,	14,48,	
140,171,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	14,48,	
14,48,	14,48,	14,48,	36,79,	
79,79,	141,172,	142,173,	143,174,	
42,86,	145,175,	42,86,	36,79,	
36,0,	42,87,	42,87,	42,87,	
42,87,	42,87,	42,87,	42,87,	
42,87,	42,87,	42,87,	127,85,	
146,176,	147,177,	148,178,	149,179,	
79,122,	127,85,	150,180,	151,181,	
38,81,	152,182,	153,183,	154,184,	
36,79,	155,185,	156,186,	157,187,	
38,81,	38,0,	160,159,	161,189,	
163,162,	36,79,	165,190,	166,191,	
168,192,	169,193,	36,79,	36,79,	
170,194,	171,195,	174,196,	127,85,	
175,197,	177,198,	36,79,	178,199,	
179,200,	127,85,	180,201,	182,202,	
183,203,	38,81,	184,204,	36,79,	
185,205,	187,206,	38,82,	36,79,	
36,79,	36,79,	38,81,	189,209,	
188,207,	190,210,	36,79,	38,83,	
38,83,	191,211,	192,212,	193,213,	
195,214,	196,215,	79,36,	38,81,	
200,216,	201,217,	36,79,	205,218,	
206,219,	209,221,	36,79,	210,222,	
38,81,	36,79,	188,208,	214,223,	
38,81,	38,81,	38,81,	215,224,	
216,225,	217,226,	219,227,	38,81,	
40,40,	40,40,	40,40,	40,40,	
40,40,	40,40,	40,40,	40,40,	
40,40,	40,40,	222,229,	38,81,	
223,230,	224,231,	0,0,	38,81,	
0,0,	0,0,	38,81,	0,0,	
0,0,	40,84,	40,85,	0,0,	
0,0,	0,0,	0,0,	0,0,	
40,85,	43,88,	43,88,	43,88,	
43,88,	43,88,	43,88,	43,88,	
43,88,	43,88,	43,88,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	43,88,	43,88,	
43,88,	43,88,	43,88,	43,88,	
0,0,	40,84,	40,85,	0,0,	
0,0,	0,0,	0,0,	0,0,	
40,85,	77,76,	77,118,	84,126,	
0,0,	84,126,	0,0,	0,0,	
84,127,	84,127,	84,127,	84,127,	
84,127,	84,127,	84,127,	84,127,	
84,127,	84,127,	43,88,	43,88,	
43,88,	43,88,	43,88,	43,88,	
77,119,	86,87,	86,87,	86,87,	
86,87,	86,87,	86,87,	86,87,	
86,87,	86,87,	86,87,	120,118,	
0,0,	0,0,	0,0,	0,0,	
77,120,	77,120,	77,120,	77,120,	
77,120,	77,120,	77,120,	77,120,	
77,120,	77,120,	125,162,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	120,160,	0,0,	125,163,	
125,163,	125,163,	125,163,	125,163,	
125,163,	125,163,	125,163,	208,220,	
0,0,	0,0,	0,0,	0,0,	
0,0,	120,120,	120,120,	120,120,	
120,120,	120,120,	120,120,	120,120,	
120,120,	120,120,	120,120,	126,127,	
126,127,	126,127,	126,127,	126,127,	
126,127,	126,127,	126,127,	126,127,	
126,127,	159,159,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	159,159,	159,159,	0,0,	
77,78,	208,208,	208,208,	208,208,	
208,208,	208,208,	208,208,	208,208,	
208,208,	208,208,	208,208,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	221,221,	0,0,	
0,0,	0,0,	159,188,	0,0,	
0,0,	0,0,	221,221,	221,228,	
0,0,	0,0,	0,0,	159,159,	
0,0,	0,0,	0,0,	0,0,	
159,159,	159,159,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
159,159,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	221,221,	
0,0,	159,159,	0,0,	0,0,	
0,0,	159,159,	159,159,	159,159,	
221,221,	0,0,	0,0,	0,0,	
159,159,	221,221,	221,221,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	221,221,	0,0,	0,0,	
159,159,	0,0,	0,0,	0,0,	
159,159,	0,0,	221,221,	159,159,	
0,0,	0,0,	221,221,	221,221,	
221,221,	0,0,	0,0,	0,0,	
0,0,	221,221,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	221,221,	0,0,	0,0,	
0,0,	221,221,	0,0,	0,0,	
221,221,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		yyvstop+1,
yycrank+-30,	yysvec+1,	yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+4,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+10,
yycrank+-124,	0,		yyvstop+12,
yycrank+-153,	0,		yyvstop+14,
yycrank+182,	0,		yyvstop+16,
yycrank+201,	0,		yyvstop+18,
yycrank+223,	0,		yyvstop+21,
yycrank+4,	0,		yyvstop+24,
yycrank+4,	0,		yyvstop+26,
yycrank+5,	0,		yyvstop+28,
yycrank+260,	0,		yyvstop+30,
yycrank+8,	yysvec+14,	yyvstop+33,
yycrank+4,	yysvec+14,	yyvstop+36,
yycrank+4,	yysvec+14,	yyvstop+39,
yycrank+10,	yysvec+14,	yyvstop+42,
yycrank+39,	yysvec+14,	yyvstop+45,
yycrank+12,	yysvec+14,	yyvstop+48,
yycrank+32,	yysvec+14,	yyvstop+51,
yycrank+14,	yysvec+14,	yyvstop+54,
yycrank+14,	yysvec+14,	yyvstop+57,
yycrank+15,	yysvec+14,	yyvstop+60,
yycrank+26,	yysvec+14,	yyvstop+63,
yycrank+54,	yysvec+14,	yyvstop+66,
yycrank+7,	yysvec+14,	yyvstop+69,
yycrank+65,	yysvec+14,	yyvstop+72,
yycrank+19,	yysvec+14,	yyvstop+75,
yycrank+39,	yysvec+14,	yyvstop+78,
yycrank+40,	yysvec+14,	yyvstop+81,
yycrank+44,	0,		yyvstop+84,
yycrank+0,	yysvec+4,	yyvstop+86,
yycrank+0,	yysvec+6,	0,	
yycrank+0,	0,		yyvstop+88,
yycrank+-382,	0,		0,	
yycrank+4,	0,		0,	
yycrank+-411,	0,		0,	
yycrank+10,	yysvec+8,	0,	
yycrank+440,	0,		yyvstop+91,
yycrank+211,	yysvec+10,	yyvstop+93,
yycrank+345,	0,		0,	
yycrank+469,	0,		0,	
yycrank+0,	yysvec+10,	yyvstop+95,
yycrank+0,	0,		yyvstop+97,
yycrank+0,	0,		yyvstop+99,
yycrank+0,	0,		yyvstop+101,
yycrank+0,	yysvec+14,	yyvstop+103,
yycrank+29,	yysvec+14,	yyvstop+105,
yycrank+70,	yysvec+14,	yyvstop+107,
yycrank+41,	yysvec+14,	yyvstop+109,
yycrank+48,	yysvec+14,	yyvstop+111,
yycrank+45,	yysvec+14,	yyvstop+113,
yycrank+64,	yysvec+14,	yyvstop+115,
yycrank+55,	yysvec+14,	yyvstop+117,
yycrank+66,	yysvec+14,	yyvstop+119,
yycrank+53,	yysvec+14,	yyvstop+121,
yycrank+57,	yysvec+14,	yyvstop+123,
yycrank+76,	yysvec+14,	yyvstop+125,
yycrank+65,	yysvec+14,	yyvstop+127,
yycrank+66,	yysvec+14,	yyvstop+129,
yycrank+68,	yysvec+14,	yyvstop+132,
yycrank+79,	yysvec+14,	yyvstop+134,
yycrank+67,	yysvec+14,	yyvstop+136,
yycrank+84,	yysvec+14,	yyvstop+138,
yycrank+70,	yysvec+14,	yyvstop+140,
yycrank+83,	yysvec+14,	yyvstop+142,
yycrank+93,	yysvec+14,	yyvstop+144,
yycrank+78,	yysvec+14,	yyvstop+146,
yycrank+81,	yysvec+14,	yyvstop+148,
yycrank+83,	yysvec+14,	yyvstop+150,
yycrank+93,	yysvec+14,	yyvstop+152,
yycrank+87,	yysvec+14,	yyvstop+154,
yycrank+98,	yysvec+14,	yyvstop+156,
yycrank+99,	yysvec+14,	yyvstop+158,
yycrank+26,	yysvec+32,	0,	
yycrank+540,	0,		0,	
yycrank+91,	0,		0,	
yycrank+-374,	yysvec+36,	0,	
yycrank+0,	0,		yyvstop+160,
yycrank+29,	0,		0,	
yycrank+0,	yysvec+81,	yyvstop+162,
yycrank+245,	0,		0,	
yycrank+508,	0,		0,	
yycrank+0,	0,		yyvstop+164,
yycrank+525,	0,		0,	
yycrank+138,	yysvec+86,	yyvstop+166,
yycrank+0,	yysvec+43,	yyvstop+168,
yycrank+123,	yysvec+14,	yyvstop+170,
yycrank+26,	yysvec+14,	yyvstop+172,
yycrank+93,	yysvec+14,	yyvstop+174,
yycrank+102,	yysvec+14,	yyvstop+176,
yycrank+110,	yysvec+14,	yyvstop+178,
yycrank+101,	yysvec+14,	yyvstop+180,
yycrank+105,	yysvec+14,	yyvstop+182,
yycrank+120,	yysvec+14,	yyvstop+184,
yycrank+127,	yysvec+14,	yyvstop+186,
yycrank+117,	yysvec+14,	yyvstop+188,
yycrank+126,	yysvec+14,	yyvstop+190,
yycrank+131,	yysvec+14,	yyvstop+192,
yycrank+125,	yysvec+14,	yyvstop+194,
yycrank+142,	yysvec+14,	yyvstop+196,
yycrank+141,	yysvec+14,	yyvstop+198,
yycrank+164,	yysvec+14,	yyvstop+200,
yycrank+181,	yysvec+14,	yyvstop+202,
yycrank+164,	yysvec+14,	yyvstop+204,
yycrank+0,	yysvec+14,	yyvstop+206,
yycrank+170,	yysvec+14,	yyvstop+209,
yycrank+186,	yysvec+14,	yyvstop+211,
yycrank+170,	yysvec+14,	yyvstop+213,
yycrank+174,	yysvec+14,	yyvstop+215,
yycrank+186,	yysvec+14,	yyvstop+217,
yycrank+174,	yysvec+14,	yyvstop+219,
yycrank+200,	yysvec+14,	yyvstop+221,
yycrank+193,	yysvec+14,	yyvstop+223,
yycrank+200,	yysvec+14,	yyvstop+225,
yycrank+206,	yysvec+14,	yyvstop+227,
yycrank+0,	0,		yyvstop+229,
yycrank+286,	yysvec+32,	0,	
yycrank+573,	0,		0,	
yycrank+210,	0,		0,	
yycrank+0,	0,		yyvstop+231,
yycrank+0,	0,		yyvstop+233,
yycrank+0,	0,		yyvstop+235,
yycrank+559,	0,		0,	
yycrank+583,	0,		0,	
yycrank+333,	yysvec+126,	yyvstop+238,
yycrank+0,	0,		yyvstop+240,
yycrank+250,	yysvec+14,	yyvstop+242,
yycrank+0,	yysvec+14,	yyvstop+244,
yycrank+217,	yysvec+14,	yyvstop+247,
yycrank+222,	yysvec+14,	yyvstop+249,
yycrank+0,	yysvec+14,	yyvstop+251,
yycrank+0,	yysvec+14,	yyvstop+254,
yycrank+235,	yysvec+14,	yyvstop+257,
yycrank+251,	yysvec+14,	yyvstop+259,
yycrank+236,	yysvec+14,	yyvstop+261,
yycrank+246,	yysvec+14,	yyvstop+263,
yycrank+0,	yysvec+14,	yyvstop+265,
yycrank+244,	yysvec+14,	yyvstop+268,
yycrank+269,	yysvec+14,	yyvstop+270,
yycrank+270,	yysvec+14,	yyvstop+272,
yycrank+273,	yysvec+14,	yyvstop+274,
yycrank+0,	yysvec+14,	yyvstop+276,
yycrank+281,	yysvec+14,	yyvstop+279,
yycrank+288,	yysvec+14,	yyvstop+281,
yycrank+308,	yysvec+14,	yyvstop+283,
yycrank+305,	yysvec+14,	yyvstop+285,
yycrank+296,	yysvec+14,	yyvstop+287,
yycrank+309,	yysvec+14,	yyvstop+289,
yycrank+295,	yysvec+14,	yyvstop+291,
yycrank+303,	yysvec+14,	yyvstop+293,
yycrank+315,	yysvec+14,	yyvstop+295,
yycrank+316,	yysvec+14,	yyvstop+297,
yycrank+317,	yysvec+14,	yyvstop+299,
yycrank+308,	yysvec+14,	yyvstop+301,
yycrank+316,	yysvec+14,	yyvstop+303,
yycrank+0,	yysvec+14,	yyvstop+305,
yycrank+-640,	0,		0,	
yycrank+388,	0,		0,	
yycrank+320,	0,		0,	
yycrank+0,	0,		yyvstop+308,
yycrank+385,	0,		0,	
yycrank+0,	yysvec+14,	yyvstop+310,
yycrank+328,	yysvec+14,	yyvstop+313,
yycrank+330,	yysvec+14,	yyvstop+315,
yycrank+0,	yysvec+14,	yyvstop+317,
yycrank+308,	yysvec+14,	yyvstop+320,
yycrank+321,	yysvec+14,	yyvstop+322,
yycrank+331,	yysvec+14,	yyvstop+324,
yycrank+317,	yysvec+14,	yyvstop+326,
yycrank+0,	yysvec+14,	yyvstop+328,
yycrank+0,	yysvec+14,	yyvstop+331,
yycrank+332,	yysvec+14,	yyvstop+334,
yycrank+335,	yysvec+14,	yyvstop+336,
yycrank+0,	yysvec+14,	yyvstop+338,
yycrank+316,	yysvec+14,	yyvstop+341,
yycrank+324,	yysvec+14,	yyvstop+343,
yycrank+330,	yysvec+14,	yyvstop+345,
yycrank+332,	yysvec+14,	yyvstop+347,
yycrank+0,	yysvec+14,	yyvstop+349,
yycrank+340,	yysvec+14,	yyvstop+352,
yycrank+328,	yysvec+14,	yyvstop+354,
yycrank+342,	yysvec+14,	yyvstop+356,
yycrank+347,	yysvec+14,	yyvstop+358,
yycrank+0,	yysvec+14,	yyvstop+360,
yycrank+339,	yysvec+14,	yyvstop+363,
yycrank+446,	0,		0,	
yycrank+346,	0,		0,	
yycrank+340,	yysvec+14,	yyvstop+365,
yycrank+351,	yysvec+14,	yyvstop+367,
yycrank+346,	yysvec+14,	yyvstop+369,
yycrank+347,	yysvec+14,	yyvstop+371,
yycrank+0,	yysvec+14,	yyvstop+373,
yycrank+359,	yysvec+14,	yyvstop+376,
yycrank+368,	yysvec+14,	yyvstop+378,
yycrank+0,	yysvec+14,	yyvstop+380,
yycrank+0,	yysvec+14,	yyvstop+383,
yycrank+0,	yysvec+14,	yyvstop+386,
yycrank+360,	yysvec+14,	yyvstop+389,
yycrank+370,	yysvec+14,	yyvstop+391,
yycrank+0,	yysvec+14,	yyvstop+393,
yycrank+0,	yysvec+14,	yyvstop+396,
yycrank+0,	yysvec+14,	yyvstop+399,
yycrank+369,	yysvec+14,	yyvstop+402,
yycrank+371,	yysvec+14,	yyvstop+404,
yycrank+0,	0,		yyvstop+406,
yycrank+605,	0,		0,	
yycrank+376,	0,		0,	
yycrank+359,	yysvec+14,	yyvstop+408,
yycrank+0,	yysvec+14,	yyvstop+410,
yycrank+0,	yysvec+14,	yyvstop+413,
yycrank+0,	yysvec+14,	yyvstop+416,
yycrank+368,	yysvec+14,	yyvstop+419,
yycrank+384,	yysvec+14,	yyvstop+421,
yycrank+363,	yysvec+14,	yyvstop+423,
yycrank+384,	yysvec+14,	yyvstop+425,
yycrank+0,	yysvec+14,	yyvstop+427,
yycrank+386,	yysvec+14,	yyvstop+430,
yycrank+0,	0,		yyvstop+432,
yycrank+-669,	0,		0,	
yycrank+397,	yysvec+14,	yyvstop+434,
yycrank+390,	yysvec+14,	yyvstop+436,
yycrank+400,	yysvec+14,	yyvstop+438,
yycrank+0,	yysvec+14,	yyvstop+440,
yycrank+0,	yysvec+14,	yyvstop+443,
yycrank+0,	yysvec+14,	yyvstop+446,
yycrank+0,	0,		yyvstop+449,
yycrank+0,	yysvec+14,	yyvstop+451,
yycrank+0,	yysvec+14,	yyvstop+454,
yycrank+0,	yysvec+14,	yyvstop+457,
0,	0,	0};
struct yywork *yytop = yycrank+764;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,'+' ,01  ,'+' ,01  ,01  ,
'0' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,
'8' ,'8' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'E' ,'F' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'L' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'X' ,'G' ,'G' ,01  ,0134,01  ,01  ,'_' ,
01  ,'A' ,'A' ,'A' ,'A' ,'E' ,'F' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'L' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'X' ,'G' ,'G' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	Copyright (c) 1989 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident "@(#)ncform 6.4 92/06/19 SMI"

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
#if defined(__cplusplus) || defined(__STDC__)
int yylook(void)
#else
yylook()
#endif
{
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			if(yylastch > &yytext[YYLMAX]) {
				fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
				exit(1);
			}
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
#if defined(__cplusplus) || defined(__STDC__)
int yyback(int *p, int m)
#else
yyback(p, m)
	int *p;
#endif
{
	if (p==0) return(0);
	while (*p) {
		if (*p++ == m)
			return(1);
	}
	return(0);
}
	/* the following are only used in the lex library */
#if defined(__cplusplus) || defined(__STDC__)
int yyinput(void)
#else
yyinput()
#endif
{
	return(input());
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyoutput(int c)
#else
yyoutput(c)
  int c; 
#endif
{
	output(c);
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyunput(int c)
#else
yyunput(c)
   int c; 
#endif
{
	unput(c);
	}
