/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)ast_root.cc	1.46% %92/06/11% Sun Microsystems"

/*
 * ast_root.cc - Implementation of class AST_Root
 *
 * AST_Root nodes represent the roots of ASTs.
 * AST_Root is a subclass of AST_Module, and is defined to allow BEs
 * to subclass it to associate their own information with an entire
 * AST.
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Constructor(s) and destructor
 */
AST_Root::AST_Root()
{
}

AST_Root::AST_Root(UTL_ScopedName *n, UTL_StrList *p)
	: AST_Decl(AST_Decl::NT_module, n, p),
	  UTL_Scope(AST_Decl::NT_module)
{
}

/*
 * Private operations
 */

/*
 * Public operations
 */

/*
 * Add protocol
 */

/*
 * Add this AST_Sequence to the locally defined types in this scope
 */
AST_Sequence *
AST_Root::add_sequence(AST_Sequence *t)
{
  if (t == NULL)
    return NULL;
  /*
   * Add it to scope
   */
  add_to_local_types(t);

  return t;
}

/*
 * Add this AST_String to the locally defined types in this scope
 */
AST_String *
AST_Root::add_string(AST_String *t)
{
  if (t == NULL)
    return NULL;
  /*
   * Add it to scope
   */
  add_to_local_types(t);

  return t;
}

/*
 * Add this AST_Array to the locally defined types in this scope
 */
AST_Array *
AST_Root::add_array(AST_Array *t)
{
  if (t == NULL)
    return NULL;
  /*
   * Add it to scope
   */
  add_to_local_types(t);

  return t;
}

/*
 * Redefinition of inherited virtual operations
 */

/*
 * Dump this AST_Root node to the ostream o
 */
void
AST_Root::dump(ostream &o)
{
  UTL_Scope::dump(o);
}

/*
 * Narrowing methods
 */
IMPL_NARROW_METHODS1(AST_Root, AST_Module)
IMPL_NARROW_FROM_DECL(AST_Root)
IMPL_NARROW_FROM_SCOPE(AST_Root)
