/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)ast_interface.cc	1.46% %92/06/11% Sun Microsystems"

/*
 * ast_interface.cc - Implementation of class AST_Interface
 *
 * AST_Interfaces denote IDL interface definitions
 * AST_Interfaces are subclasses of AST_Type and UTL_Scope
 * AST_Interfaces have an array of inherited interfaces and
 * a count of the number of inherited interfaces. This count
 * represents the total number of unique (recursively) inherited
 * interfaces.
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Constructor(s) and destructor
 */
AST_Interface::AST_Interface()
	     : pd_n_inherits(0),
	       pd_inherits(NULL)
{
}

AST_Interface::AST_Interface(UTL_ScopedName *n,
			     AST_Interface **ih,
			     long nih,
			     UTL_StrList *p)
	    : AST_Decl(AST_Decl::NT_interface, n, p),
	      UTL_Scope(AST_Decl::NT_interface),
	      pd_n_inherits(nih),
	      pd_inherits(ih)
{
}

/*
 * Private operations
 */

/*
 * Public operations
 */


/*
 * Redefinition of inherited virtual operations
 */

/*
 * Add an AST_Constant node (a constant declaration) to this scope
 */
AST_Constant *AST_Interface::add_constant(AST_Constant *t)
{
  AST_Decl *d;

  /*
   * Can't add to interface which was not yet defined
   */
  if (!is_defined()) {
    idl_global->err()->error2(UTL_Error::EIDL_DECL_NOT_DEFINED, this, t);
    return NULL;
  }
  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Add an AST_Exception node (an exception declaration) to this scope
 */
AST_Exception *AST_Interface::add_exception(AST_Exception *t)
{
  AST_Decl *d;

  /*
   * Can't add to interface which was not yet defined
   */
  if (!is_defined()) {
    idl_global->err()->error2(UTL_Error::EIDL_DECL_NOT_DEFINED, this, t);
    return NULL;
  }
  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Add an AST_Attribute node (an attribute declaration) to this scope
 */
AST_Attribute *AST_Interface::add_attribute(AST_Attribute *t)
{
  AST_Decl *d;

  /*
   * Can't add to interface which was not yet defined
   */
  if (!is_defined()) {
    idl_global->err()->error2(UTL_Error::EIDL_DECL_NOT_DEFINED, this, t);
    return NULL;
  }
  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Add an AST_Operation node (an operation declaration) to this scope
 */
AST_Operation *AST_Interface::add_operation(AST_Operation *t)
{
  AST_Decl *d;

  /*
   * Can't add to interface which was not yet defined
   */
  if (!is_defined()) {
    idl_global->err()->error2(UTL_Error::EIDL_DECL_NOT_DEFINED, this, t);
    return NULL;
  }
  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Add an AST_Structure (a struct declaration) to this scope
 */
AST_Structure *AST_Interface::add_structure(AST_Structure *t)
{
  AST_Decl *d;

  /*
   * Can't add to interface which was not yet defined
   */
  if (!is_defined()) {
    idl_global->err()->error2(UTL_Error::EIDL_DECL_NOT_DEFINED, this, t);
    return NULL;
  }
  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Add an AST_Enum node (an enum declaration) to this scope
 */
AST_Enum *AST_Interface::add_enum(AST_Enum *t)
{
  AST_Decl *d;

  /*
   * Can't add to interface which was not yet defined
   */
  if (!is_defined()) {
    idl_global->err()->error2(UTL_Error::EIDL_DECL_NOT_DEFINED, this, t);
    return NULL;
  }
  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Add an AST_Union (a union declaration) to this scope
 */
AST_Union *AST_Interface::add_union(AST_Union *t)
{
  AST_Decl *d;

  /*
   * Can't add to interface which was not yet defined
   */
  if (!is_defined()) {
    idl_global->err()->error2(UTL_Error::EIDL_DECL_NOT_DEFINED, this, t);
    return NULL;
  }
  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Add an AST_EnumVal node (an enumerator) to this scope.
 * This is done to conform to the C++ scoping rules which declare
 * enumerators in the enclosing scope (in addition to declaring them
 * in the enum itself)
 */
AST_EnumVal *AST_Interface::add_enum_val(AST_EnumVal *t)
{
  AST_Decl *d;

  /*
   * Can't add to interface which was not yet defined
   */
  if (!is_defined()) {
    idl_global->err()->error2(UTL_Error::EIDL_DECL_NOT_DEFINED, this, t);
    return NULL;
  }
  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Add an AST_Typedef (a typedef) to the current scope
 */
AST_Typedef *AST_Interface::add_typedef(AST_Typedef *t)
{
  AST_Decl *d;

  /*
   * Can't add to interface which was not yet defined
   */
  if (!is_defined()) {
    idl_global->err()->error2(UTL_Error::EIDL_DECL_NOT_DEFINED, this, t);
    return NULL;
  }
  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Dump this AST_Interface node to the ostream o
 */
void
AST_Interface::dump(ostream &o)
{
  long	i;

  o << "interface " << local_name()->get_string() << " ";
  if (pd_n_inherits > 0) {
    o << ": ";
    for (i = 0; i < pd_n_inherits; i++) {
      o << pd_inherits[i]->local_name()->get_string();
      if (i < pd_n_inherits - 1)
	o << ", ";
    }
  }
  o << " {\n";
  UTL_Scope::dump(o);
  idl_global->indent()->skip_to(o);
  o << "}";
}

/*
 * Data accessors
 */

AST_Interface	**
AST_Interface::inherits()
{
  return pd_inherits;
}

void
AST_Interface::set_inherits(AST_Interface **i)
{
  pd_inherits = i;
}

long
AST_Interface::n_inherits()
{
  return pd_n_inherits;
}

void
AST_Interface::set_n_inherits(long i)
{
  pd_n_inherits = i;
}

/*
 * Narrowing methods
 */
IMPL_NARROW_METHODS2(AST_Interface, AST_Type, UTL_Scope)
IMPL_NARROW_FROM_DECL(AST_Interface)
IMPL_NARROW_FROM_SCOPE(AST_Interface)
