/*
** Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
 

#include <stdlib.h>
#include <stdarg.h>
#include "cstubber.h"

#define IndentIncrement		4

static char		*b = "                                                 ";
static char		*dent;
static FILE		*f;
static char 		**mList = NULL;
static int		nm = 0;

void addMethodToList (char *m)
{
  int i = nm++;

  if ( mList )
    mList = CRealloc(mList, nm * sizeof(char *), char * );
  else
    mList = CAlloc( nm * sizeof( char * ), char * );
  mList[ i ] = m;
}

void clearMethodList (void)
{
  if ( mList )
    Free( mList );
  mList = NULL;
  nm = 0;
}

boolean methodInList( char *m )
{
  int i;

  if ( nm <= 0 )
    return( False );
  if ( !mList )
    return( False );
  for( i = 0; i < nm; i++ ) {
    if ( strcmp( m, mList[ i ]) == 0 )
      return( True );
  }
  return( False );
}

void dedent( )
{
    dent += IndentIncrement;
}

void emit( char	*fmt, ... )
{
    va_list	args;

    fprintf( f, "%s", dent );
    va_start( args, fmt );
    vfprintf( f, fmt, args );
    va_end( args );
}

void error( char *fmt, ... )
{
    va_list     args;
 
    fprintf( stderr, "Error: " );
    va_start( args, fmt );
    vfprintf( stderr, fmt, args );
    va_end( args );
}
 
 
void fatal( char *fmt, ... )
{
    va_list     args;
 
    fprintf( stderr, "Fatal: " );
    va_start( args, fmt );
    vfprintf( stderr, fmt, args );
    va_end( args );
    exit( 1 );
}

void indent( )
{
    dent -= IndentIncrement;
}

void setFile( FILE	*file )
{
    f = file;
    dent = b + strlen( b );
}

 

