/*
** Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
 

#include "cstubber.h"

extern Class 	class_object();

static boolean 	FirstClass = TRUE;
extern boolean	generateAnsi;
extern cardinal MethodRecordID;


static void declareReturnValue (Type type, Context context)
{
  if (type != NULL AND
      type_basic_type(type) != void_Type)
    {
      fprintf (context->file, "  %s _retvalue;\n", c_return_type(type));
    }
}

static void listArgument (Argument a, Context context)
{
  enum PrimitiveTypes t = type_basic_type (a->type);

  fprintf (context->file, ", %s%s",
	   ((a->direction == In AND
	     (t == union_Type OR t == record_Type OR (t == sequence_Type AND NOT TypeIsString(a->type)))) OR
	    ((a->direction == Out OR a->direction == InOut) AND
	     t != array_Type)) ? "&" : "",
	   c_argument_name(a));
}

void FreeValue (Type type, char *name, Context context, int indent)
{
  enum PrimitiveTypes t = type_basic_type(type);

  if (HasFreeRoutine(type))
    fprintf (context->file, "%*.*s%s__Free (%s%s);\n", indent, indent, "", c_type_name(type),
	     (t == array_Type OR t == optional_Type OR TypeIsString(type)) ? "" : "&", name);
  else if (t == optional_Type)
    {
      char buf[1000];
      sprintf (buf, "*%s", name);
      FreeValue (type_description(type)->structuredDes.optional, buf, context, indent);
    }
}     

static void freeArgument (Argument arg, Context context)
{
  FreeValue (arg->type, c_argument_name(arg), context, 2);
}     

static void freeReturnValue (Type type, Context context)
{
  FreeValue (type, "_retvalue", context, 2);
}

static void sizeArgument (Argument a, Context context)
{
  char b[ 1000 ];
  enum PrimitiveTypes t = type_basic_type( a->type );

  if ( a->direction == In )
    return;
  if (t == union_Type OR
      t == record_Type OR
      t == sequence_Type)
    {
      b[0] = '&';
      strcpy (b+1, c_argument_name(a));
    }
  else
    strcpy(b, c_argument_name(a));
  fprintf (context->file, "\n        +");
  SizeValue (context, a->type, b);
}

static void outputArgument (Argument a, Context context)
{
  char b[ 1000 ];
  enum PrimitiveTypes t = type_basic_type( a->type );

  if ( a->direction == In )
    return;
  if (t == union_Type OR
      t == record_Type OR
      t == sequence_Type)
    {
      b[0] = '&';
      strcpy (b+1, c_argument_name(a));
    }
  else
    strcpy(b, c_argument_name(a));
  MarshallValue (context, a->type, b, 6);
}

static void inputArgument (Argument arg, Context context)
{
  char buf[1000];
  enum PrimitiveTypes t = type_basic_type(arg->type);

  if (arg->direction == Out)
    return;
  sprintf (buf, "%s%s", (t == array_Type OR t == object_Type) ? "" : "&", c_argument_name(arg));
  UnmarshallValue (context, arg->type, arg->def, buf, 2, TRUE, FALSE);
}

static void declareArgument (Argument arg, Context context)
{
  fprintf(context->file, "  %s %s;\n", c_type_name(arg->type), c_argument_name(arg));
}

static void serverMethods(
    Procedure 	m,
    Context 	context )
{
  fprintf(context->file, "    server_%s_%s,\n", c_type_name(context->class), c_simple_name(m->name));
}

static void serverProto(
    Procedure 	m,
    Context 	context )
{
  fprintf(context->file, "extern void server_%s_%s( );\n",
	  c_type_name(context->class), c_simple_name(m->name));
}

static void generateCalleeStub(
    Procedure 	m,
    Context 	context )
{
  enum PrimitiveTypes t = type_basic_type( m->returnType );

  if ( methodInList( c_simple_name( m->name ))) {
    MethodRecordID++;
    return;
  }
  addMethodToList( c_simple_name( m->name ));

  fprintf (context->file, "static void _%s_%s_stub(ilu_Call _call)\n{\n",
	   c_type_name(context->class), c_simple_name(m->name));
  fprintf (context->file, "  %s _h;\n", c_type_name(context->class));
  fprintf (context->file, "  ILU_C_ENVIRONMENT _status;\n");
  list_enumerate (m->arguments, (void (*)(refany, refany)) declareArgument, context);
  declareReturnValue (m->returnType, context);
  fprintf (context->file, "\n");

  if (SINGLETON(context->class))
    fprintf (context->file, "  _h = (%s) _ILU_C_GetServerSingleton (_call->ca_server, _call->ca_intro_type);\n",
	     c_type_name(context->class));
  else
    fprintf (context->file, "  _h = (%s) _ILU_C_InputObject (_call, &_%s__ILUClassRecord, ilu_TRUE);\n",
	     c_type_name( context->class ), c_type_name( context->class )); 
  list_enumerate( m->arguments, (void (*)(refany, refany)) inputArgument, context );
  fprintf (context->file, "\n");
  fprintf (context->file, "  if (_ILU_C_FinishParameters (_call, _h)) {\n");
  fprintf( context->file, "    _status.returnCode = NULL;\n    " );
  if (t != void_Type)
    fprintf (context->file, "_retvalue = " );
  fprintf (context->file, "%s_%s (_h, &_status", c_type_name( context->class ), c_simple_name( m->name ));
  list_enumerate (m->arguments, (void (*)(refany, refany)) listArgument, context);
  fprintf( context->file, ");\n\n" );
  if (m->asynch)
    fprintf (context->file, "  /* asynchronous method -- no reply */\n  }\n  ilu_NoReply(_call);\n");
  else
    {
      char buf[1000];
      sprintf (buf, "%s_retvalue", (t == record_Type OR
				    (t == sequence_Type AND NOT TypeIsString(m->returnType)) OR
				    t == union_Type) ? "&" : "");
      fprintf( context->file, "    if (_status.returnCode == NULL) {  /* check for errors */\n");
      fprintf( context->file, "      ilu_BeginReply( _call, %s, (",
	      ( list_size( m->exceptions ) > 0 ) ? "ilu_TRUE" : "ilu_FALSE" );
      if (t == void_Type)
	fprintf (context->file, "0");
      else
	SizeValue (context, m->returnType, buf);
      list_enumerate (m->arguments, (void (*)(refany, refany)) sizeArgument, context );
      fprintf (context->file, "));\n" );
      if ( type_basic_type( m->returnType ) != void_Type )
	MarshallValue (context, m->returnType, buf, 6);
      list_enumerate( m->arguments, (void (*)(refany, refany)) outputArgument, context );
      fprintf( context->file, "      ilu_FinishReply( _call );\n    }\n" );
      if (list_size(m->exceptions) > 0)
	{
	  fprintf( context->file, "    else\n      _%s_SendException( _call, &_status );\n  }\n",
		  c_interface_name( m->interface ));
	}
      else
	{
	  fprintf (context->file, "    else\n      fprintf(stderr, \"** Error in stub for %s_%s:  non-NULL returnCode returned, but %s doesn't signal any exceptions!\\n\");\n  }\n",
		   c_type_name(context->class), c_simple_name(m->name), c_simple_name(m->name));
	}
    }
  if (t != void_Type)
    freeReturnValue (m->returnType, context);
  list_enumerate(m->arguments, (void (*)(refany, refany)) freeArgument, context);
  fprintf (context->file, "}\n\n");
}

static void classTable (Type class, Context context)
{
  Class od;

  if ( class == NULL || 
      type_basic_type( class ) != object_Type || 
      ( od = class_object( class )) == NULL )
    return;
  if ( list_size( od->methods ) > 0 )
    list_enumerate( od->methods, (void (*)(refany, refany)) serverMethods, context );
}

static void generateProto(
    Type 	class,
    Context 	context )
{
    Class 	od;

    if ( class == NULL || 
		type_basic_type( class ) != object_Type || 
		( od = class_object( class )) == NULL )
        return;
    if ( list_size( od->methods ) > 0 )
        list_enumerate( od->methods, (void (*)(refany, refany)) serverProto, context );
}


static void generateServerMiMethodPtrs (Type class, Context context)
{
  if (class_object(class)->superclasses != NULL)
    list_enumerate (class_object( class )->superclasses,
		    (void (*)(refany, refany)) generateServerMiMethodPtrs, context);
  if (methodInList(c_type_name(class)))
    return;
  addMethodToList(c_type_name(class));
  generateProto(class, context);
  fprintf (context->file, "static struct _%s__MethodBlock_s _%s_%s__TrueMethodBlock = {\n",
	   c_type_name(context->class), c_type_name(class), c_type_name(context->class));
  fprintf (context->file, "  &_%s__ILUClassRecord,\n  {\n", c_type_name(class));
  classTable(class, context);
  fprintf (context->file, "  }\n};\n");
}

static void generateServerClsPtrs(
    Type        t,
    Context     c )
{
  if (class_object(t)->superclasses != NULL)
    list_enumerate (class_object( t )->superclasses, (void (*)(refany, refany)) generateServerClsPtrs, c);
  fprintf (c->file, "  (_ILU_C_MethodBlock *) &_%s_%s__TrueMethodBlock,\n", c_type_name(t), c_type_name(c->class));
}

static void generateServerClassTable(
    Type        t,
    Context     c )
{
  c->class = t;
  clearMethodList( );
  generateServerMiMethodPtrs( t, c );
  fprintf (c->file, "static _ILU_C_MethodBlock *_%s__TrueTypeVector[] = {\n", c_type_name(t));
  fprintf (c->file, "  (_ILU_C_MethodBlock *) &_%s_%s__TrueMethodBlock,\n", c_type_name(t), c_type_name(t));
  if (class_object(t)->superclasses != NULL)
    list_enumerate (class_object(t)->superclasses, (void (*)(refany, refany)) generateServerClsPtrs, c);
  fprintf (c->file, "  NULL\n};\n\n");
}
 
static void classSetupStubs(
    Type 	class,
    Context 	context )
{
    Class 	od;

    if ( class == NULL || 
		type_basic_type( class ) != object_Type || 
		( od = class_object( class )) == NULL )
        return;
    if ( list_size( od->methods ) > 0 )
        list_enumerate( od->methods, (void (*)(refany, refany)) generateCalleeStub, context );
}


static void generateServerCodeForClass(
    Type 	class,
    Context 	context )
{
    context->class = class;
    clearMethodList( );
    classSetupStubs( class, context );
}

static void initializeStubPointer(
    Procedure 	method,
    Context 	context )
{
    fprintf(
	context->file, 
	"  _%s__ILUClassRecord.cl_methods[%ld].me_stubproc = _%s_%s_stub;\n",
        c_type_name( context->class ), 
	MethodRecordID++,
        c_type_name( context->class /*method->object*/ ), 
	c_simple_name( method->name ));
}
 
static void setupServerStubsInMethodTable(
    Type 	type,
    Context 	context )
{
    Class od;
 
    if ( type == NULL || 
		type_basic_type( type ) != object_Type || 
		( od = class_object( type )) == NULL )
        return;
    fprintf (context->file, "\n");
    list_enumerate( od->methods, (void (*)(refany, refany)) initializeStubPointer, context );
}

static void setupServerStubsTable(
    Type 	type,
    Context 	context )
{
    MethodRecordID = 0;
    FirstClass = True;
    context->class = type;
    setupServerStubsInMethodTable( type, context );
}

static void generateHandles(
    Type 	type,
    Context 	context )
{
  fprintf (context->file, "ILU_C_OBJECT %s__CreateTrue ( ilu_string instance_handle, ilu_Server server, void * data )\n{\n",
	   c_type_name(type));
  fprintf (context->file, "  return (_ILU_C_CreateTrueObject (_%s__TrueTypeVector, instance_handle, server, data));\n}\n\n",
	   c_type_name( type ));
}

static void generateServerRegistrationCode(
    Interface interface,
    Context context )
{
    char 	*interface_name = (char *) c_interface_name(interface);
 
    list_enumerate(
	interface->classes, 
	(void (*)(refany, refany)) generateHandles, 
	context );
    fprintf(
        context->file,
        "void %s__InitializeServer(void)\n{\n",
        interface_name );
    fprintf (context->file, "  extern void _%s__GeneralInitialization(void);\n",
	     c_interface_name(interface));
    fprintf(
        context->file,
        "  _%s__GeneralInitialization ();\n",
        interface_name );
    list_enumerate(
	interface->classes, 
	(void (*)(refany, refany)) setupServerStubsTable, 
	context );
    fprintf( context->file, "}\n\n" );
}

void generateServerCode(
    Interface 	parse,
    FILE 	*file )
{
    struct context_s context;

    context.file = file;
    context.interface = parse;
    fprintf (file, "#include \"%s.h\"\n\n", c_interface_name(parse));

    list_enumerate( parse->classes, (void (*)(refany, refany)) generateServerClassTable, &context );

    list_enumerate( parse->classes, (void (*)(refany, refany)) generateServerCodeForClass, &context );

    generateServerRegistrationCode( parse, &context );
}
