/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

#ifdef MACOS
#pragma segment common
#endif

#include "cplusplus.h"
extern Type ultimateType(Type);

void UnmarkSupertypes (Type t)
{
  Type st;

  if (t == NULL OR type_basic_type(t) != object_Type)
    return;
  for (st = t;  st->supertype != NULL;  st = st->supertype)
    st->marked = FALSE;

  list_enumerate (class_object(st)->superclasses, (iluparser_EnumProc) UnmarkSupertypes, NULL);
  st->marked = FALSE;
}

boolean IsSequenceObject (Type type, Interface i)
{
  return ((i == NULL || type->interface == i)
	  && type->importInterfaceName == NULL
	  && type_basic_type(type) == sequence_Type
	  && (type_basic_type(type_description(type)->structuredDes.sequence.type) != shortcharacter_Type)
	  && (type_basic_type(type_description(type)->structuredDes.sequence.type) != byte_Type));
}

boolean IsPipeObject (Type type, Interface i)
{
  return ((i == NULL || type->interface == i)
	  && type->importInterfaceName == NULL
	  && type_basic_type(type) == pipe_Type);
}

boolean PassedByRef (Type type)
{
  enum PrimitiveTypes t;

  if (type == NULL)
    return (FALSE);

  t = type_basic_type(type);
  return (t == record_Type
	  OR t == union_Type
	  OR t == array_Type
	  OR t == object_Type
	  OR t == pipe_Type
	  OR t == sequence_Type
	  OR t == longcardinal_Type
	  OR t == longinteger_Type);
}

boolean TypeIsNonObjectStruct (Type type)
{
  enum PrimitiveTypes t;

  if (type == NULL)
    return (FALSE);

  t = type_basic_type(type);
  return (t == record_Type OR t == union_Type);
}

boolean TypeIsArray (Type type)
{
  if (type == NULL)
    return (FALSE);

  return (type_basic_type(type) == array_Type);
}

boolean TypeIsString (Type type)
{
  return (type_basic_type(type) == sequence_Type
	  AND (type_basic_type(type_description(type)->structuredDes.sequence.type) == shortcharacter_Type));
}

void SizeType (Type type, string name, boolean optional, Context context)
{
  enum PrimitiveTypes t = type_basic_type (type);
  TypeDescription d = type_description(type);

  if (t == integer_Type)
    fprintf (context->file, "+ilu::SizeOfInteger(_call, %s)", name);
  else if (t == enumeration_Type)
    fprintf (context->file, "+ilu::SizeOfEnum(_call, (ilu_ShortCardinal) %s)", name);
  else if (t == cardinal_Type)
    fprintf (context->file, "+ilu::SizeOfCardinal(_call, %s)", name);
  else if (t == shortinteger_Type)
    fprintf (context->file, "+ilu::SizeOfShortInteger(_call, %s)", name);
  else if (t == shortcardinal_Type)
    fprintf (context->file, "+ilu::SizeOfShortCardinal(_call, %s)", name);
  else if (t == longinteger_Type)
    fprintf (context->file, "+ilu::SizeOfLongInteger(_call, %s)", name);
  else if (t == longcardinal_Type)
    fprintf (context->file, "+ilu::SizeOfLongCardinal(_call, %s)", name);
  else if (t == character_Type)
    fprintf (context->file, "+ilu::SizeOfCharacter(_call, %s)", name);
  else if (t == shortcharacter_Type)
    fprintf (context->file, "+ilu::SizeOfByte(_call, %s)", name);
  else if (t == real_Type)
    fprintf (context->file, "+ilu::SizeOfReal(_call, %s)", name);
  else if (t == shortreal_Type)
    fprintf (context->file, "+ilu::SizeOfShortReal(_call, %s)", name);
  else if (t == longreal_Type)
    fprintf (context->file, "+ilu::SizeOfLongReal(_call, %s)", name);
  else if (t == boolean_Type)
    fprintf (context->file, "+ilu::SizeOfBoolean(_call, %s)", name);
  else if (t == byte_Type)
    fprintf (context->file, "+ilu::SizeOfByte(_call, %s)", name);
  else if (t == optional_Type)
    {
      fprintf (context->file, "+ilu::SizeOfOptional(_call, (%s != NULL))", name);
      SizeType (d->structuredDes.optional, name, optional, context);
    }
  else if (t == sequence_Type AND type_basic_type (d->structuredDes.sequence.type) == shortcharacter_Type)
    fprintf (context->file, "+ilu::SizeOfString(_call, ((char *)%s), strlen((char *) %s), %lu)",
	     name, name, d->structuredDes.sequence.limit);
  else if (t == array_Type
      AND type_basic_type (d->structuredDes.array.type) == byte_Type
      AND list_size(d->structuredDes.array.dimensions) == 1)
    fprintf (context->file, "+ilu::SizeOfOpaque(_call, %s, %lu)", name,
	     (cardinal) list_car(d->structuredDes.array.dimensions));
  else if (t == array_Type
      AND type_basic_type (d->structuredDes.array.type) == shortcharacter_Type
      AND list_size(d->structuredDes.array.dimensions) == 1)
    fprintf (context->file, "+ilu::SizeOfStringVec(_call, %s, %lu)", name,
	     (cardinal) list_car(d->structuredDes.array.dimensions));
  else if (t == record_Type OR t == union_Type OR t == sequence_Type OR t == pipe_Type)
    fprintf (context->file, "+%s_G::SizeOf_%s (_call, (%s) %s)", cplusplus_interface_name(type->interface),
	     cplusplus_simple_name(type->name), cplusplus_parameter_type(type), name);
  else if (t == array_Type)
    fprintf (context->file, "+%s_G::SizeOf_%s (_call, %s)", cplusplus_interface_name(type->interface),
	     cplusplus_simple_name(type->name), name);
  else if (t == pipe_Type)
    fprintf (context->file, "+iluPipe_SizeOfObject (%s, _call, %s)", cplusplus_type_name(type), name);
  else if (t == object_Type)
    fprintf (context->file, "+iluObject::SizeOfObject (_call, (%s) %s, %s::ILUClassRecord)",
	     cplusplus_return_type(type), name, cplusplus_type_name(type));
  else if (t == void_Type)
    fprintf (context->file, "+0");
  else
    {
      fprintf (stderr, "Error:  Can't figure size of argument of type %s (line %ld) yet.\n",
	       type_name(type), type->def);
      exit (1);
    }
}

void SizeArgument (Argument arg, Context context)
{
  SizeType (arg->type, cplusplus_argument_name(arg), FALSE, context);
}

void EncodeValue (Type type, string name, boolean optional, Context context)
{
  enum PrimitiveTypes t = type_basic_type(type);
  TypeDescription d = type_description(type);

  if (t == integer_Type)
    fprintf (context->file, "\tilu::OutputInteger (_call, (ilu_Integer) %s);\n", name);
  else if (t == enumeration_Type)
    fprintf (context->file, "\tilu::OutputEnum (_call, (unsigned short int) %s);\n", name);
  else if (t == cardinal_Type)
    fprintf (context->file, "\tilu::OutputCardinal (_call, (ilu_Cardinal) %s);\n", name);
  else if (t == shortinteger_Type)
    fprintf (context->file, "\tilu::OutputShortInteger (_call, (short int) %s);\n", name);
  else if (t == shortcardinal_Type)
    fprintf (context->file, "\tilu::OutputShortCardinal (_call, (unsigned short int) %s);\n", name);
  else if (t == longinteger_Type)
    fprintf (context->file, "\tilu::OutputLongInteger (_call, (ilu_LongInteger) %s);\n", name);
  else if (t == longcardinal_Type)
    fprintf (context->file, "\tilu::OutputLongCardinal (_call, (ilu_LongCardinal) %s);\n", name);
  else if (t == character_Type)
    fprintf (context->file, "\tilu::OutputCharacter (_call, (ilu_Character) %s);\n", name);
  else if (t == shortcharacter_Type)
    fprintf (context->file, "\tilu::OutputByte (_call, (unsigned char) %s);\n", name);
  else if (t == real_Type)
    fprintf (context->file, "\tilu::OutputReal (_call, (double) %s);\n", name);
  else if (t == shortreal_Type)
    fprintf (context->file, "\tilu::OutputShortReal (_call, (float) %s);\n", name);
  else if (t == longreal_Type)
    fprintf (context->file, "\tilu::OutputLongReal (_call, (double) %s);\n", name);
  else if (t == boolean_Type)
    fprintf (context->file, "\tilu::OutputBoolean (_call, (ilu_Boolean) %s);\n", name);
  else if (t == byte_Type)
    fprintf (context->file, "\tilu::OutputByte (_call, (unsigned char) %s);\n", name);
  else if (t == optional_Type)
    {
      fprintf (context->file, "\tilu::OutputOptional (_call, (%s != NULL));\n", name);
      EncodeValue (d->structuredDes.optional, name, optional, context);
    }
  else if (t == sequence_Type AND type_basic_type (d->structuredDes.sequence.type) == shortcharacter_Type)
    {
      fprintf (context->file, "\tilu::OutputString (_call, %s, strlen(%s), %lu);\n",
	       name, name, d->structuredDes.sequence.limit);
    }
  else if (t == array_Type
      AND type_basic_type (d->structuredDes.array.type) == byte_Type
      AND list_size(d->structuredDes.array.dimensions) == 1)
    fprintf (context->file, "\tilu::OutputOpaque(_call, %s, %lu);\n",
	     name, (cardinal) list_car(d->structuredDes.array.dimensions));
  else if (t == array_Type
      AND type_basic_type (d->structuredDes.array.type) == shortcharacter_Type
      AND list_size(d->structuredDes.array.dimensions) == 1)
    fprintf (context->file, "\tilu::OutputStringVec(_call, %s, %lu);\n",
	     name, (cardinal) list_car(d->structuredDes.array.dimensions));
  else if (t == record_Type OR t == union_Type OR t == sequence_Type OR t == pipe_Type)
    fprintf (context->file, "\t%s_G::Output_%s (_call, %s);\n",
	     cplusplus_interface_name(type->interface),
	     cplusplus_simple_name(type->name), name);
  else if (t == array_Type)
    fprintf (context->file, "\t%s_G::Output_%s (_call, %s);\n",
	     cplusplus_interface_name(type->interface),
	     cplusplus_simple_name(type->name), name);
  else if (t == pipe_Type)
    fprintf (context->file, "\tiluPipe_OutputObject (%s, _call, %s);\n", cplusplus_type_name(type),
	     optional ? "ilu_TRUE" : "ilu_FALSE");
  else if (t == object_Type)
    fprintf (context->file, "\tiluObject::OutputObject (_call, (%s) %s, %s::ILUClassRecord);\n",
	     cplusplus_return_type(type), name, cplusplus_type_name(type));
  else if (t == void_Type)
    ;
  else
    {
      fprintf (stderr, "Error:  Can't cope with argument of type %s yet.\n", cplusplus_type_name(type));
      exit (1);
    }
}

void EncodeArgument (Argument arg, Context context)
{
  EncodeValue (arg->type, cplusplus_argument_name(arg), FALSE, context);
}

void UnpackValue (Context context, Type type, LineNumber line, string buffer, boolean ref, boolean optional, boolean allocate)
{
  enum PrimitiveTypes t = type_basic_type(type);
  TypeDescription d = type_description(type);

  if (t == integer_Type)
    fprintf (context->file, "\tilu::InputInteger (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == cardinal_Type)
    fprintf (context->file, "\tilu::InputCardinal (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == shortinteger_Type)
    fprintf (context->file, "\tilu::InputShortInteger (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == shortcardinal_Type)
    fprintf (context->file, "\tilu::InputShortCardinal (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == longinteger_Type)
    fprintf (context->file, "\tilu::InputLongInteger (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == longcardinal_Type)
    fprintf (context->file, "\tilu::InputLongCardinal (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == character_Type)
    fprintf (context->file, "\tilu::InputCharacter (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == shortcharacter_Type)
    fprintf (context->file, "\tilu::InputByte (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == real_Type)
    fprintf (context->file, "\tilu::InputReal (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == shortreal_Type)
    fprintf (context->file, "\tilu::InputShortReal (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == longreal_Type)
    fprintf (context->file, "\tilu::InputLongReal (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == boolean_Type)
    fprintf (context->file, "\tilu::InputBoolean (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == byte_Type)
    fprintf (context->file, "\tilu::InputByte (_call, %s%s);\n", ref ? "" : "&", buffer);
  else if (t == optional_Type)
    {
      fprintf (context->file, "\t{ ilu_Boolean _present; ilu::InputOptional (_call, &_present);\n");
      fprintf (context->file, "\t\tif (_present) ");
      UnpackValue (context, d->structuredDes.optional, line, buffer, FALSE, FALSE, TRUE);
      fprintf (context->file, "\t\telse %s = NULL;\n", buffer);
      fprintf (context->file, "\t}\n");
    }
  else if (t == enumeration_Type)
    fprintf (context->file, "\t{ ilu_ShortCardinal _index; ilu::InputEnum (_call, &_index);  %s = (%s) _index; };\n",
	     buffer, cplusplus_type_name(type));
  else if (t == sequence_Type AND type_basic_type (d->structuredDes.sequence.type) == shortcharacter_Type)
    fprintf (context->file, "\t%s = ilu::InputString(_call, NULL, NULL, %lu);\n",
	     buffer, d->structuredDes.sequence.limit);
  else if (t == array_Type
      AND type_basic_type (d->structuredDes.array.type) == byte_Type
      AND list_size(d->structuredDes.array.dimensions) == 1)
    fprintf (context->file, "\t%s = ilu::InputOpaque(_call, NULL, %lu);\n",
	     buffer, (cardinal) list_car(d->structuredDes.array.dimensions));
  else if (t == array_Type
      AND type_basic_type (d->structuredDes.array.type) == shortcharacter_Type
      AND list_size(d->structuredDes.array.dimensions) == 1)
    fprintf (context->file, "\t%s = ilu::InputStringVec(_call, NULL, %lu);\n",
	     buffer, (cardinal) list_car(d->structuredDes.array.dimensions));
  else if (t == array_Type OR t == sequence_Type OR t == record_Type OR t == union_Type)
    {
      if (optional || allocate || t == sequence_Type)
	fprintf (context->file, "\t%s = %s_G::Input_%s (_call, NULL);\n",
		 buffer, cplusplus_interface_name(type->interface), cplusplus_simple_name(type->name));
      else
	fprintf (context->file, "\t%s_G::Input_%s (_call, %s%s);\n",
		 cplusplus_interface_name(type->interface), cplusplus_simple_name(type->name),
		 ref ? "" : "&", buffer);
    }
  else if (t == pipe_Type)
    fprintf (context->file, "\t%s%s = %s_iluPipe_InputObject(_call, %s);\n",
	     ref ? "*" : "", buffer, cplusplus_type_name(type), optional ? "ilu_TRUE" : "ilu_FALSE");
  else if (t == object_Type)
    fprintf (context->file, "\t%s%s = (%s) iluObject::InputObject (_call, ilu_FALSE, %s::ILUClassRecord);\n",
	     ref ? "*" : "", buffer, cplusplus_return_type(type), cplusplus_type_name(type));
  else if (t == void_Type)
    ;
  else
    {
      fprintf (stderr, "Error:  Can't cope with procedure of type %s (line %ld) yet.\n",
	       cplusplus_type_name(type), line);
      exit (1);
    }
}

boolean BlockingCall (Procedure proc)
{
  return (NOT(proc->asynch)
	  OR type_basic_type(proc->returnType) != void_Type
	  OR list_size(proc->exceptions) > 0);
}

static list InterfacesToInclude = NULL;
static list TypesChecked = NULL;

static boolean matchString (char *s1, char *s2)
{
  return (strcmp(s1,s2) == 0);
}

static boolean matchPointer (char *s1, char *s2)
{
  return (s1 == s2);
}

static void GenerateIncludesForType (Type t, Context context);

static void GenerateIncludeForArgument (Argument a, Context context)
{
  GenerateIncludesForType (a->type, context);
}

static void GenerateIncludesForMethods (Procedure m, Context context)
{
  list_enumerate (m->arguments, (iluparser_EnumProc) GenerateIncludeForArgument, context);
  if (m->returnType != NULL && type_basic_type(m->returnType) != void_Type)
    GenerateIncludesForType (m->returnType,context);
}

extern Class class_object();

static void GenerateIncludesForType (Type t, Context context)
{
  if (t == NULL)
    return;

  if (list_find(TypesChecked, (iluparser_FindProc) matchPointer, t) != NULL)
    return;
  list_insert(TypesChecked, t);
  if (!t->builtIn && t->interface != NULL && name_base_name(t->interface->name) != NULL && (list_find(InterfacesToInclude, (iluparser_FindProc) matchString, name_base_name(t->interface->name)) == NULL))
    list_insert (InterfacesToInclude, name_base_name(t->interface->name));

  if (type_basic_type(t) == object_Type)
    {
      list_enumerate (type_description(t)->structuredDes.object->superclasses, (iluparser_EnumProc) GenerateIncludesForType, context);
      list_enumerate (type_description(t)->structuredDes.object->methods, (iluparser_EnumProc) GenerateIncludesForMethods, context);
    }
  else if (type_basic_type(t) == record_Type)
    {
      list_enumerate (type_description(t)->structuredDes.record, (iluparser_EnumProc) GenerateIncludeForArgument, context);
    }
  else if (type_basic_type(t) == union_Type)
    {
      list_enumerate (type_description(t)->structuredDes.uniond.types, (iluparser_EnumProc) GenerateIncludeForArgument, context);
    }
  else if (type_basic_type(t) == sequence_Type)
    {
      GenerateIncludesForType (type_description(t)->structuredDes.sequence.type, context);
    }
  else if (type_basic_type(t) == array_Type)
    {
      GenerateIncludesForType (type_description(t)->structuredDes.array.type, context);
    }
}

static void PrintInclude (char *interfacename, Context context)
{
  fprintf (context->file, "#ifndef __%s_H_\n#include <%s.H>\n#endif /* ndef __%s_H_ */\n\n",
	   interfacename, interfacename, interfacename);
}

static Interface CurrentInterface = NULL;
extern Interface GetInterface(string, string);

static void ListIncludes (Imported i, list l)
{
  Interface imported;

  if ((imported = GetInterface (i->name, i->filename)) != NULL
      && imported != CurrentInterface
      && (strcmp(i->name, "ilu") != 0)
      && (list_find(l, (iluparser_FindProc) matchString, name_base_name(imported->name)) == NULL))
    list_insert (l, name_base_name(imported->name));    
}

void GenerateNecessaryIncludes (Context context)
{
  if (InterfacesToInclude == NULL)
    InterfacesToInclude = (list) new_list();

  list_clear(InterfacesToInclude, FALSE);

  CurrentInterface = context->interface;
  list_enumerate (context->interface->imports, (iluparser_EnumProc) ListIncludes, InterfacesToInclude);

  list_enumerate (InterfacesToInclude, (iluparser_EnumProc) PrintInclude, context);
}

cardinal MethodRecordID;

static void DeclareMethodDefine (Procedure m, Context context)
{
  fprintf (context->file, "#define MethodRecord_%s_%s ((%s::ILUClassRecord)->cl_methods + %lu)\n",
	   cplusplus_type_name(context->class), class_procedure_name(m),
	   cplusplus_type_name(context->class), MethodRecordID);
  MethodRecordID += 1;
}

void DefineMethods2 (Type t, Context context)
{
  Class od;
  Type class;

  if (t == NULL || (class = ultimateType(t)) == NULL || class->marked
      || type_basic_type(class) != object_Type || (od = class_object(class)) == NULL)
    return;

  class->marked = TRUE;

  list_enumerate(od->superclasses, (iluparser_EnumProc) DefineMethods2, context);

  list_enumerate (od->methods, (iluparser_EnumProc) DeclareMethodDefine, context);
}

void DefineMethods (Type t, Context c)
{
  c->class = t;
  MethodRecordID = 0;
  UnmarkSupertypes (t);
  DefineMethods2 (t, c);
  fprintf (c->file, "\n");
}
