(* MutexExtra.m3 *)
(* Last tweaked by Mike Spreitzer November 16, 1993 3:25 pm PST *)

UNSAFE MODULE MutexExtra;
IMPORT Thread;

TYPE
  Mutex = BRANDED "Revealed Mutex" OBJECT
            holder      : Thread.T := NIL;
            waitingForMe: Thread.T := NIL;
          END;
  (* Copied from Thread.m3 *)

PROCEDURE Holds (t: Thread.T; m: MUTEX): BOOLEAN =
  VAR mm := LOOPHOLE(m, Mutex);
  BEGIN
    RETURN mm.holder = t;
  END Holds;

BEGIN
END MutexExtra.
