(* IluGc.m3 *)
(* Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights
   Reserved.

   Unlimited use, reproduction, and distribution of this software is
   permitted.  Any copy of this software must include both the above
   copyright notice of Xerox Corporation and this paragraph.  Any
   distribution of this software must comply with all applicable United
   States export control laws.  This software is made available AS IS,
   and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND
   NOTWITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN, ANY LIABILITY
   FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS EXPRESSLY
   DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING NEGLIGENCE)
   OR STRICT LIABILITY, EVEN IF XEROX CORPORATION IS ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGES. *)
(* Edited by Mike Spreitzer March 17, 1994 9:36 pm PST *)

MODULE IluGc EXPORTS IluF;
IMPORT Ilu, IluBasics, IluF, IluKernel, IluRuntime, Thread;
FROM IluBasics IMPORT Failed, Failure;

EXCEPTION
  CantHappen;
  <*FATAL CantHappen*>

TYPE
  Pinger = Ilu.Object OBJECT
           OVERRIDES
             ILU_Get_Server := GetServer;
             ILU_Get_Type   := GetType;
             ILU_Qua_Type   := QuaType
           END;

VAR s: Ilu.TrueServer;
VAR cc: Ilu.ObjectType;
VAR p: Pinger;
VAR kp: IluKernel.Object;

PROCEDURE GetServer (<*UNUSED*> self: Pinger): Ilu.Server =
  BEGIN
    RETURN s
  END GetServer;

PROCEDURE GetType (<*UNUSED*> self: Pinger): Ilu.ObjectType =
  BEGIN
    RETURN cc
  END GetType;

PROCEDURE QuaType (self: Pinger; ot: Ilu.ObjectType): Ilu.Object =
  BEGIN
    IF ot = cc THEN RETURN self ELSE RETURN NIL END;
  END QuaType;

PROCEDURE PingStub (call: IluRuntime.Call) RAISES {} =
  VAR leader: IluRuntime.M3Obj;
  BEGIN
    TRY
      TRY
        leader := IluRuntime.InputM3Object(call, TRUE, cc);
      FINALLY
        IluRuntime.RequestRead(call);
      END (*try-finally read*);
    EXCEPT
    | IluBasics.Failed (f) =>
        IluRuntime.HandleStubFailure1(call, f);
        RETURN
    | Thread.Alerted => IluRuntime.HandleStubAlert1(call); RETURN
    END (*try-except unmarshalling failures*);
    TRY
      TRY
        IluRuntime.BeginReply(call, TRUE, 0);
      FINALLY
        IluRuntime.FinishReply(call);
      END (*try-finally*);
    EXCEPT
    | IluBasics.Failed (f) => IluRuntime.HandleStubFailure2(call, f)
    | Thread.Alerted => IluRuntime.HandleStubAlert2(call);
    END (*try-except marshalling failures*);
  END PingStub;

VAR fDump: Failure;

PROCEDURE StartGcClientSide () =
  BEGIN
    s := NEW(Ilu.TrueServer);
    p := NEW(Pinger, ilu_is_surrogate := FALSE);
    TRY
      EVAL Ilu.InitTrueServer(s);
      Ilu.Export_Server(s, NEW(Ilu.SunRpc2), NEW(Ilu.TCP));
      cc := IluKernel.ilu_GetGcCallbackClass();
      IluRuntime.SetMethodStub(cc, 0, 1, PingStub);
      kp := IluF.KOfO(p);
      IluKernel.ilu_ExitServer(s.ks, cc);
    EXCEPT
      Failed (f) => fDump := f; RAISE CantHappen
    END;
    IF kp # NIL THEN
      IluKernel.ilu_SetGcClient(kp);
    ELSE
      RAISE CantHappen
    END (*if*);
  END StartGcClientSide;

BEGIN
END IluGc.
