#|
Copyright (c) 1991, 1992, 1993, 1994 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: ilu-server-macros.lisp,v 1.11 1994/04/30 07:48:45 janssen Exp $
|#

(cl:in-package :ilu)

;;;; DEFINE-SERVER-CLASS:  expands into server

(defmacro define-server-class (class superclass)
  `(progn
     (eval-when (compile eval load) (export '(,class)))
     (defclass ,class (ilu-true-object ,superclass) ())
     (defmethod initialize-instance :after ((self ,class)
					    &key (server nil)
					         (id nil)
					    &allow-other-keys)
       (setup-object-links
	self
	(find-or-create-true-kernel-object
	 (or id (create-default-id))
	 (or server (ensure-server))
	 (find-ilu-class-record self) self)))))

;;;; DEFINE-METHOD-SERVER-STUB: expands into a defun which calls a method

(defmacro define-method-server-stub
    (name id singleton-p functional-p asynchronous-p args exceptions return-type)
  (declare (ignore singleton-p functional-p))
  (destructuring-bind ((self self-type) &rest other-args) args
    (declare (ignore self))
    (let ((other-arg-types (mapcar #'second other-args))
	  (other-arg-dirs (mapcar #'third other-args))
	  (has-return-values (and (not asynchronous-p)
				  (remove-nils (cons return-type
						     (mapcar #'(lambda (dir)
								 (or (eq dir :out) (eq dir :inout)))
							     (mapcar #'third other-args)))))))
      `(defmethod call-server-stub-for-method-name
	   (call (method-id (eql ,(intern id :keyword))) (self ,self-type))
	 ,(let ((foo `(let ((return-value
			     (,(if (< 1 (length has-return-values)) 'cl:multiple-value-list 'cl:list)
				 (apply #',name self
					(let ((args (list
						     ,@(mapcar #'(lambda (type)
								   (make-read-form `call type))
							       other-arg-types))))
					  (ilu_request-read call)
					  args)))))
			,@(remove-nils
			   (list
			    (unless has-return-values `(declare (ignore return-value)))
			    (if asynchronous-p
				`(ilu_no-reply call)
			      `(progn
				 (begin-reply
				  call ,(if exceptions 't 'nil)
				  (+ 0
				     ,@(remove-nils
					(let ((index -1))
					  (cons
					   (if return-type
					       (make-size-form `call return-type `(nth ,(incf index) return-value)))
					   (mapcar #'(lambda (dir type)
						       (unless (eq dir :in)
							 (make-size-form `call type `(nth ,(incf index) return-value))))
						   other-arg-dirs other-arg-types))))))
				 ,@(remove-nils
				    (let ((index -1))
				      (cons
				       (if return-type
					   (make-write-form `call return-type `(nth ,(incf index) return-value)))
				       (mapcar #'(lambda (dir type)
						   (unless (eq dir :in)
						     (make-write-form `call type `(nth ,(incf index) return-value))))
					       other-arg-dirs other-arg-types))))
				 (finish-reply call))))))))
	    (if exceptions
		`(handler-bind
		     ,@(remove-nils 
			(list
			 (mapcar
			  #'(lambda (exception)
			      `(,exception
				#'(lambda (e)
				    (signal-exception
				     call ,(1+ (position exception exceptions)) e)
				    (return-from call-server-stub-for-method-name))))
			  exceptions)))
		     ,foo)
	      foo)
	    )
	 ))))



