/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: auth.c,v 1.2 1994/02/05 23:10:42 janssen Exp $ */

#define _POSIX_SOURCE

#include <stdio.h>

#define TRUE  1
#define FALSE 0
typedef int Boolean;

#define AND  &&
#define OR   ||
#define NOT  !

static char xerox_copyright[] = "\
\
 Copyright 1989 Xerox Corporation\
 All Rights Reserved";

#include <ilu.h>

/* authentication code for the ILU system.

Basic scheme is that a user calls into this module with authentication
parameters, such as name and password, and if they check out, an
authentication block is added to the table of authentications.
Different RPC protocols can then call for the authentication block
that they want.

*/

#include <auth.h>

static ilu_refany AuthenticationTable = NULL;



ilu_Authentication ilu_GetAuthentication (authtype)
     ilu_string authtype;
     ilu_refany authptr;
{
  if (AuthenticationTable == NULL)
    {
      AuthenticationTable = (ilu_refany) _ilu_hash_MakeNewTable (AUTH_HASHTABLESIZE,
								 _ilu_hash_HashString,
								 _ilu_hash_StringCompare);
    }

  return ((ilu_Authentication) _ilu_hash_FindInTable (AuthenticationTable, authtype));
}

