#include <ilu.h>
#include <X11/Intrinsics.h>

#define MAXFDS	256

static XtInputId ids[MAXFDS];

struct xtrock {
  void (*proc) (int fd, void *rock);
  void *rock;
  int fd;
};

static void (*loop)() = NULL;
static void *looparg = NULL;

static void ml_run(void)
{
  printf ("main loop called\n");
  if (loop != NULL)
    (*loop)(looparg);
  else if (looparg != NULL)
    XtAppMainLoop(looparg);
  else
    XtMainLoop ();
}

static void ml_input_callback (void *rock, int *fd)
{
  (((struct xtrock *)rock)->proc) (*fd, ((struct xtrock*)rock)->rock);
}

static ilu_boolean ml_register_input (int fd, void (*proc)(int, void*), void *rock)
{
  struct xtrock *r = (struct xtrock *) malloc(sizeof(struct xtrock));

  r->proc = proc;
  r->rock = rock;
  r->fd = fd;

  if (loop == NULL AND looparg != NULL)
    ids[fd] = XtAppAddInput (looparg, fd, XtInputReadMask | XtInputExceptMask, ml_input_callback, r);
  else
    ids[fd] = XtAddInput (fd, XtInputReadMask | XtInputExceptMask, ml_input_callback, r);
}

static ilu_boolean ml_unregister_input (int fd)
{
  if (ids[fd] != NULL)
    {
      XtRemoveInput (ids[fd]);
      ids[fd] = NULL;
    }
}

static MainLoop ml = { ml_run, ml_register_input, ml_unregister_input };

ilu_XtInitialize (void *loopargp, void (*loopproc)())
{
  ilu_cardinal i;

  for (i = 0;  i < MAXFDS;  i++)
    ids[MAXFDS] = NULL;

  if (loopproc != NULL)
    loop = loopproc;
  looparg = loopargp;

  ilu_SetMainLoop (&ml);
}
