/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: xview.cc,v 1.1 1993/09/23 22:33:27 janssen Exp $
*/

#include <xview/notify.h>
#include "ilu.H"
#include "iluServer.H"

class xviewMainLoop : public iluMainLoop {
public:
  virtual void Run();
  virtual ilu_Boolean RegisterInputHandler (int fd,
					    void (*proc) (int,void *),
					    void *rock);
  virtual ilu_Boolean UnregisterInputHandler (int fd);

  Xv_Window base_frame;
};

void xviewMainLoop::Run()
{
  xv_main_loop(base_frame);
}

struct xviewRock {
  ilu_private rock;
  void (*proc)(int, ilu_private);
};

static Notify_value xviewFunc (Notify_client client, int fd)
{
  struct xviewRock *p = (struct xviewRock *) client;
  (p->proc)(fd, p->rock);
  return NOTIFY_DONE;
}

ilu_Boolean xviewMainLoop::RegisterInputHandler(int fd,
						void (*proc)(int, void *),
						ilu_private rock)
{
  struct xviewRock *p = new xviewRock;
  p->rock = rock;
  p->proc = proc;
  notify_set_input_func ((Notify_client)p, xviewFunc, fd);
  return ilu_TRUE;
}

ilu_Boolean xviewMainLoop::UnregisterInputHandler (int fd)
{
  notify_set_input_func (NULL, NULL, fd);
  return ilu_TRUE;
}

void ilu_InitializeXViewMainLoop (Xv_Window base_frame)
{
  static class xviewMainLoop ml;

  ml.base_frame = base_frame;
  iluServer::iluSetMainLoop(&ml);
}
