/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* Last tweaked by Mike Spreitzer September 9, 1993 3:06 pm PDT */

#ifndef __ilu_H_
#define __ilu_H_ 1

#include <stdlib.h>
#include <string.h>

  typedef unsigned char ilu_Boolean;

  typedef enum { ilu_kernelTRUE = 1, ilu_kernelFALSE = 0 } ilu_kernelBoolean;

  typedef long int ilu_Integer;
  typedef short int ilu_ShortInteger;
  typedef struct _ilu_LongInteger_s ilu_LongInteger;

  typedef unsigned long int ilu_Cardinal;
  typedef unsigned short int ilu_ShortCardinal;
  typedef struct _ilu_LongCardinal_s ilu_LongCardinal;

  typedef double ilu_Real;
  typedef float ilu_ShortReal;
  typedef double ilu_LongReal;

  typedef unsigned short ilu_Character;
  typedef unsigned char ilu_ShortCharacter;

  typedef char * ilu_CString;
  typedef char * ilu_T_CString;
  typedef ilu_Character *ilu_WString;
  typedef unsigned char ilu_Byte;

  typedef char *ilu_Exception;		/* address of exception description */
  typedef void *ilu_KernelObject;

struct _ilu_LongInteger_s {
  ilu_Integer high;
  unsigned long int low;
};

struct _ilu_LongCardinal_s {
  ilu_Cardinal high;
  ilu_Cardinal low;
};

#ifndef __ILU_IMPLEMENTATION_

#define ilu_TRUE	((ilu_Boolean) 1)
#define ilu_FALSE	((ilu_Boolean) 0)

  typedef enum {
    ilu_conn_closed,	/* done with this connection */
    ilu_no_request,  /* there wasn't really any input waiting */
    ilu_read_failed,	/* err sys may give more info */
    ilu_not_request,	/* wrong type message received */
    ilu_interp_failed,/* protocol's interp proc failed */
    ilu_builtin_meth,	/* built-in; already handled */
    ilu_good_request	/* decent message received */
    } ilu_ReceiveRequestStatus;

  typedef enum _ilu_ProtocolExceptions {
    ilu_ProtocolException_Success = 0,
    ilu_ProtocolException_NoSuchClassAtServer = 1,
    ilu_ProtocolException_ClassVersionMismatch = 2,
    ilu_ProtocolException_NoSuchMethodOnClass = 3,
    ilu_ProtocolException_GarbageArguments = 4,
    ilu_ProtocolException_Unknown = 5,
    ilu_ProtocolException_LostConnection = 6,
    ilu_ProtocolException_RequestRejected = 7,
    ilu_ProtocolException_RequestTimeout = 8
  } ilu_ProtocolException;

  typedef enum _ilu_PacketTypes {
    ilu_PacketType_Request = 0,
    ilu_PacketType_Reply = 1
    } ilu_PacketType;

  typedef void *ilu_Server;
  typedef void *ilu_Port;
  typedef void *ilu_Connection;

  typedef struct _ilu_Method_s * ilu_Method;/* method description for server */
  typedef struct _ilu_Call_s * ilu_Call;	/* call description */
  typedef struct _ilu_Class_s * ilu_Class;	/* class description for server */

  typedef void	(*ilu_stub_procedure)(ilu_Call);

  typedef void * ilu_Alarm;
  typedef struct { ilu_Integer s; ilu_Cardinal t; } ilu_FineTime;

struct _ilu_Method_s {	/* read-only; no locks needed */
  ilu_CString me_name;
  ilu_Cardinal me_id;
  ilu_kernelBoolean me_cacheable;	/* functional? */
  ilu_kernelBoolean me_asynchronous;	/* need to wait after calling? */
  ilu_Exception *me_exceptionVector;	/* list of possible exceptions */
  ilu_Cardinal me_exceptionCount;	/* number of exceptions in list */
  ilu_stub_procedure me_stubproc;
};

struct _ilu_Call_s {
  ilu_Cardinal		ca_SN;		/* serial number of request */
  ilu_Server		ca_server;		/* server of call */
  ilu_Class		ca_intro_type;
  ilu_Method		ca_method;		/* ID number of method */
  ilu_Connection	ca_connection;		/* connection which points to (server or client) */
  void *		ca_private;		/* slot for lang-specific implementation's use */
};

struct _ilu_Class_s {		/* read-only: no locks needed */
  
  ilu_CString cl_name;		/* ILU name of class */
  ilu_CString cl_brand;		/* brand on class */
  ilu_CString cl_unique_id;	/* unique id for type graph of class */
  ilu_kernelBoolean cl_singleton;	/* TRUE (1) if class is a singleton */
  ilu_kernelBoolean cl_collectible;
  ilu_CString cl_authentication;	/* non-NULL with name of authentication type, if any */
  ilu_Method  cl_methods;
  ilu_Cardinal cl_method_count;
  ilu_Cardinal cl_scls_count;
  ilu_CString *cl_scls_ids;	/* name of superclass */
  ilu_Class *cl_sclses;		/* chain of links to root */
  ilu_kernelBoolean cl_shown;
};

#endif /* ndef __ILU_IMPLEMENTATION_ */
  
class ilu {

 public:

  static ilu_Exception	ProtocolError;

  static ilu_Call	BeginCall		(ilu_KernelObject obj);
  static ilu_Boolean 	BeginException		(ilu_Call call, ilu_Cardinal eIndex, ilu_Cardinal argSize);
  static ilu_Boolean	BeginRequest		(ilu_Call call, ilu_Class pclass, ilu_Method method, ilu_Cardinal argSize);
  static ilu_Boolean	BeginReply		(ilu_Call call, ilu_Boolean exceptions, ilu_Cardinal argSize);
  static ilu_Boolean	FinishCall		(ilu_Call call);
  static ilu_Boolean	FinishException 	(ilu_Call call);
  static ilu_Boolean	FinishRequest		(ilu_Call call);
  static ilu_Boolean	FinishReply		(ilu_Call call);
  static ilu_Boolean	FinishParameters	(ilu_Call call, void *obj);
  
  static ilu_Exception	ExceptionOfMethod	(ilu_Method method, ilu_Cardinal index);
  static void		EnterServer		(ilu_Server ks, ilu_Class c);
  static void		ExitServer		(ilu_Server ks, ilu_Class c);
  static void *		SBHToObject		(ilu_CString sbh, ilu_CString optional_typeid, ilu_Class putative_class);
  static ilu_CString	SBHOfObject		(ilu_KernelObject obj);
  static ilu_Boolean	ParseSBH		(ilu_CString sbh, ilu_CString *oid, ilu_CString *contact_info);
  static ilu_Boolean	ParseOID		(ilu_CString oid, ilu_CString *iid, ilu_CString *sid);
  static ilu_Class	GetObjectClass		(ilu_KernelObject obj);
  static ilu_Server	GetObjectServer		(ilu_KernelObject obj);
  static ilu_KernelObject	CreateTrueKernelObject	(char *oid, ilu_Server server, ilu_Class c, void * lspo);
  static class iluObject *	GetLanguageSpecificObject	(ilu_KernelObject obj);
  static void		SetLanguageSpecificObject	(ilu_KernelObject obj, class iluObject * lspo);
  static void		RegisterClass		(ilu_Class c);
  static ilu_Class	FindClassFromID		(char *id);
  
  static void		EndSequence		(ilu_Call call);
  static void		EndUnion		(ilu_Call call);
  static void		EndArray		(ilu_Call call);
  static void		EndRecord		(ilu_Call call);
  
  static unsigned char	InputByte		(ilu_Call call, ilu_Byte *b);
  static ilu_Boolean	InputBoolean		(ilu_Call call, ilu_Boolean *b);
  static ilu_Boolean	InputOptional		(ilu_Call call, ilu_Boolean *b);
  static ilu_Cardinal	InputCardinal		(ilu_Call call, ilu_Cardinal *b);
  static ilu_Character	InputCharacter		(ilu_Call call, ilu_Character *c);
  static ilu_ShortCardinal	InputEnum	(ilu_Call call, ilu_ShortCardinal *c);
  static ilu_Integer	InputInteger		(ilu_Call call, ilu_Integer *c);
  static ilu_Real		InputReal	(ilu_Call call, ilu_Real *);
  static ilu_ShortCardinal	InputShortCardinal	(ilu_Call call, ilu_ShortCardinal *);
  static ilu_ShortInteger	InputShortInteger	(ilu_Call call, ilu_ShortInteger *);
  static ilu_ShortReal	InputShortReal	(ilu_Call call, ilu_ShortReal *);
  static ilu_LongCardinal	InputLongCardinal	(ilu_Call call, ilu_LongCardinal *);
  static ilu_LongInteger	InputLongInteger	(ilu_Call call, ilu_LongInteger *);
  static ilu_LongReal	InputLongReal	(ilu_Call call, ilu_LongReal *);
  static ilu_CString	InputString	(ilu_Call call, ilu_CString buf, ilu_Cardinal *len, ilu_Cardinal limit);
  static ilu_CString	InputStringVec	(ilu_Call call, ilu_CString buf, ilu_Cardinal len);
  static ilu_WString	InputWString	(ilu_Call call, ilu_WString buf, ilu_Cardinal *len, ilu_Cardinal limit);
  static ilu_WString	InputWStringVec	(ilu_Call call, ilu_WString buf, ilu_Cardinal len);
  static unsigned char*	InputBytes	(ilu_Call call, unsigned char *buf, ilu_Cardinal *len, ilu_Cardinal limit);
  static unsigned char*	InputOpaque	(ilu_Call call, unsigned char *buf, ilu_Cardinal len);
  
  static ilu_KernelObject	InputObjectID	(ilu_Call call, ilu_Boolean discriminator_p, ilu_Class putative_class);
  
  static ilu_Cardinal	InputSequence	(ilu_Call call, ilu_Cardinal *count, ilu_Cardinal limit);
  static ilu_ShortCardinal	InputUnion	(ilu_Call call, ilu_ShortCardinal *discriminator);
  static ilu_Boolean	InputArray	(ilu_Call call);
  static ilu_Boolean	InputRecord	(ilu_Call call);
  
  static ilu_Boolean	OutputByte	(ilu_Call call, unsigned char byte);
  static ilu_Boolean	OutputBoolean	(ilu_Call call, ilu_Boolean b);
  static ilu_Boolean	OutputOptional	(ilu_Call call, ilu_Boolean present);
  static ilu_Boolean	OutputCardinal	(ilu_Call call, ilu_Cardinal val);
  static ilu_Boolean	OutputCharacter	(ilu_Call call, ilu_Character val);
  static ilu_Boolean	OutputEnum	(ilu_Call call, ilu_ShortCardinal val);
  static ilu_Boolean	OutputInteger	(ilu_Call call, ilu_Integer val);
  static ilu_Boolean	OutputReal	(ilu_Call call, double val);
  static ilu_Boolean	OutputShortCardinal	(ilu_Call call, ilu_ShortCardinal val);
  static ilu_Boolean	OutputShortInteger	(ilu_Call call, ilu_ShortInteger val);
  static ilu_Boolean	OutputShortReal	(ilu_Call call, float val);
  static ilu_Boolean	OutputLongCardinal	(ilu_Call call, ilu_LongCardinal val);
  static ilu_Boolean	OutputLongInteger	(ilu_Call call, ilu_LongInteger val);
  static ilu_Boolean	OutputLongReal	(ilu_Call call, ilu_LongReal val);
  static ilu_Boolean	OutputString	(ilu_Call call, ilu_CString buf, ilu_Cardinal len, ilu_Cardinal limit);
  static ilu_Boolean	OutputStringVec	(ilu_Call call, ilu_CString buf, ilu_Cardinal len);
  static ilu_Boolean	OutputWString	(ilu_Call call, ilu_WString buf, ilu_Cardinal len, ilu_Cardinal limit, ilu_CString *buf2, ilu_Cardinal *buf2len);
  static ilu_Boolean	OutputWStringVec(ilu_Call call, ilu_WString buf, ilu_Cardinal len, ilu_CString *buf2, ilu_Cardinal *buf2len);
  static ilu_Boolean	OutputBytes	(ilu_Call call, unsigned char * bytes, ilu_Cardinal len, ilu_Cardinal limit);
  static ilu_Boolean	OutputOpaque	(ilu_Call call, unsigned char * buf, ilu_Cardinal len);
  
  static ilu_Boolean	OutputObjectID	(ilu_Call call, ilu_KernelObject obj, ilu_Boolean discriminator_p, ilu_Class c);
  
  static ilu_Boolean	OutputSequence	(ilu_Call call, ilu_Cardinal length, ilu_Cardinal limit);
  static ilu_Boolean	OutputUnion	(ilu_Call call, ilu_ShortCardinal discriminator);
  static ilu_Boolean	OutputArray	(ilu_Call call);
  static ilu_Boolean	OutputRecord	(ilu_Call call);
  
  static ilu_Cardinal	SizeOfByte	(ilu_Call call, unsigned char byte);
  static ilu_Cardinal	SizeOfBoolean	(ilu_Call call, ilu_Boolean b);
  static ilu_Cardinal	SizeOfOptional	(ilu_Call call, ilu_Boolean present);
  static ilu_Cardinal	SizeOfCardinal	(ilu_Call call, ilu_Cardinal val);
  static ilu_Cardinal	SizeOfCharacter	(ilu_Call call, ilu_Character val);
  static ilu_Cardinal	SizeOfEnum	(ilu_Call call, ilu_ShortCardinal val);
  static ilu_Cardinal	SizeOfInteger	(ilu_Call call, ilu_Integer val);
  static ilu_Cardinal	SizeOfReal	(ilu_Call call, double val);
  static ilu_Cardinal	SizeOfShortCardinal	(ilu_Call call, ilu_ShortCardinal val);
  static ilu_Cardinal	SizeOfShortInteger	(ilu_Call call, ilu_ShortInteger val);
  static ilu_Cardinal	SizeOfShortReal	(ilu_Call call, float val);
  static ilu_Cardinal	SizeOfLongCardinal	(ilu_Call call, ilu_LongCardinal val);
  static ilu_Cardinal	SizeOfLongInteger	(ilu_Call call, ilu_LongInteger val);
  static ilu_Cardinal	SizeOfLongReal	(ilu_Call call, ilu_LongReal val);
  static ilu_Cardinal	SizeOfString	(ilu_Call call, ilu_CString buf, ilu_Cardinal len, ilu_Cardinal limit);
  static ilu_Cardinal	SizeOfStringVec	(ilu_Call call, ilu_CString buf, ilu_Cardinal len);
  static ilu_Cardinal	SizeOfWString	(ilu_Call call, ilu_WString buf, ilu_Cardinal len, ilu_Cardinal limit, ilu_CString *buf2, ilu_Cardinal *buf2len);
  static ilu_Cardinal	SizeOfWStringVec(ilu_Call call, ilu_WString buf, ilu_Cardinal len, ilu_CString *buf2, ilu_Cardinal *buf2len);
  static ilu_Cardinal	SizeOfBytes	(ilu_Call call, unsigned char * bytes, ilu_Cardinal len, ilu_Cardinal limit);
  static ilu_Cardinal	SizeOfOpaque	(ilu_Call call, unsigned char * buf, ilu_Cardinal len);
  
  static ilu_Cardinal	SizeOfObjectID	(ilu_Call call, ilu_KernelObject obj, ilu_Boolean discriminator_p, ilu_Class c);
  
  static ilu_Cardinal	SizeOfSequence	(ilu_Call call, ilu_Cardinal length, ilu_Cardinal limit);
  static ilu_Cardinal	SizeOfUnion	(ilu_Call call, ilu_ShortCardinal discriminator);
  static ilu_Cardinal	SizeOfArray	(ilu_Call call);
  static ilu_Cardinal	SizeOfRecord	(ilu_Call call);
  
  static void		SetDefaultServer (class iluServer * server);
  static class iluServer * GetDefaultServer ();
  
  static ilu_Port	CreatePort	(ilu_Server server,
					 char *protocolType,
					 char *transportType);
  static void	SetServerDefaultPort	(ilu_Server s, ilu_Port p);

  static ilu_ProtocolException	WaitForReply	(ilu_Call call, ilu_Cardinal *successCode);
  static ilu_ReceiveRequestStatus ReceiveRequest (ilu_Connection conn, ilu_Call *pcall, ilu_Class *pclass, ilu_Method *method, ilu_Cardinal *serial_number);
  
  static ilu_Connection	HandleNewConnection	(ilu_Port port);
  static int		FileDescriptorOfConnection	(ilu_Connection conn);
  static int		FileDescriptorOfMooringOfPort	(ilu_Port port);
  static void		CloseConnection		(ilu_Connection conn);

  static void 		RunMainLoop		(int *stop);
  static void		ExitMainLoop		(int *stop);
  static ilu_Boolean 	RegisterInputHandler	(int fd, void (*handlerProc)(int fd, void *rock), void *rock);
  static ilu_Boolean	UnregisterInputHandler	(int fd);
  static ilu_Boolean 	RegisterOutputHandler	(int fd,void (*handlerProc)(int fd, void *rock),void *rock);
  static ilu_Boolean	UnregisterOutputHandler	(int fd);

  static ilu_Exception	Success;
};

class iluObject {

public:

  static  void *	CreateFromRegistry	(ilu_Class c, ilu_KernelObject);
  static  void		RegisterClass		(ilu_Class c,
						 void *(*proc)(ilu_KernelObject));
  static  void *	InputObject		(ilu_Call call, ilu_Boolean discriminator_p, ilu_Class putative_class);
  static  ilu_Boolean	OutputObject		(ilu_Call call, iluObject *obj, ilu_Class putative_class);
  static  ilu_Cardinal	SizeOfObject		(ilu_Call call, iluObject *obj, ilu_Class putative_class);

			iluObject();
  virtual 		~iluObject();

  virtual char *	ILUGetNMSHandle		();
  virtual void		ILUSetNMSHandle		(char *handle);
  virtual ilu_CString	ILUStringBindingHandle	();
  virtual ilu_KernelObject ILUGetRPCObject	();
  virtual void		ILUSetRPCObject		(ilu_KernelObject obj);
  
  virtual class iluServer * ILUGetServer	();
	/* An implementer of true objects is responsible for either
	   overriding this method or calling SetDefaultServer. */

  virtual void *	ILUCastDown		(ilu_Class cast_to);
  ilu_KernelObject	ILUEnsureKernelObject	();
  void *		ILUMostSpecificObject	() { return (this->ILUMostSpecificObj); };
  void			ILUSetMostSpecificObject (void *o) { this->ILUMostSpecificObj = o; };

  ilu_Class		ILUInstanceClassRecord;

private:

  ilu_KernelObject	ILURPCObject;
  ilu_Server		ILURPCServer;
  char *		ILUNMSHandle;
  void *		ILUMostSpecificObj;

};

#endif				/* ifndef __ilu_H_ */
