#include <math.h>

#include "ilu.h"
#include "ilu-c.h"
 
#include "Test1.h"
#include "Test3.h"

int main (int ac, char **av)
{
  extern void Test1__InitializeServer(void);
  ilu_Server s;
  Test1_O1  uc;

  Test1__InitializeServer();
  Test3__InitializeServer();

  s = ILU_C_InitializeServer ("Test1-Server", NULL, "sunrpc_", "tcp_localhost_0", ilu_TRUE);
  uc = Test1_O1__CreateTrue ( "Test1_Initial_Object", s, NULL );
  ILU_C_PublishObject (uc);

  if (uc != NULL)
    {
      printf ("exported %s\n", ILU_C_SBHOfObject(uc));
      ILU_C_Run( );
    }
  else
    {
      printf ("couldn't create object\n");
      exit(1);
    }
  return 1;
}

Test1_U server_Test1_O1_U_CSS_to_U( Test1_O1 h, ILU_C_ENVIRONMENT *s, Test1_U * u, Test1_CSS *css )
{
  printf ("Test1.O1.U-CSS-to-U\n");
  return( *u );
}

Test1_RO server_Test1_O1_f_CSS_to_RO( Test1_O1 h, ILU_C_ENVIRONMENT *s, Test1_CSS *css )
{
  Test1_RO	x = (Test1_RO) malloc( sizeof( Test1_R ));

  x->i = 9;
  Test1_CSS_Init( &x->css , 0, NULL );
  x->a[0]="hi";
  x->a[1]="hi";
  x->a[2]="hi";
  printf ("Test1.O1.f-CSS-to-R0\n");
  return( x );
}

float server_Test1_O1_R_ScS_to_F( Test1_O1 h, ILU_C_ENVIRONMENT *s, Test1_R *r, Test1_ScS str )
{
  float	f = 39.7;

  printf("Test1.O1.R-ScS-to-F\n");
  return( f );
}

void server_Test1_O1_a_RO( Test1_O1 h, ILU_C_ENVIRONMENT *s, Test1_RO ro )
{
  printf("Test1.O1.a-RO\n");
}

Test1_O2 server_Test1_O1_get_O2 ( Test1_O1 h, ILU_C_ENVIRONMENT *s )
{
  Test1_O2 uc;

  printf ("Test1.O1.get-O2\n");
  uc = Test1_O2__CreateTrue( NULL, NULL, NULL );
  if (uc == NULL)
    {
      s->_major = ILU_C_USER_EXCEPTION;
      s->returnCode = ex_Test1_CantCreate;
      return (NULL);
    }
  else
    return (uc);
}

Test1_O3 server_Test1_O1_get_O3 ( Test1_O1 h, ILU_C_ENVIRONMENT *s, ilu_boolean b )
{
  Test1_O3 uc;

  printf ("Test1.O1.get-O3\n");
  if (b)
    uc = Test3_O__CreateTrue( NULL, NULL, NULL );
  else
    uc = Test1_O3__CreateTrue( NULL, NULL, NULL );
  if (uc == NULL)
    {
      s->_major = ILU_C_USER_EXCEPTION;
      s->returnCode = ex_Test1_CantCreate;
      return (NULL);
    }
  else
    return (uc);
}

Test1_CSS server_Test1_O2_OO_A0_to_CSS (Test1_O2 self, ILU_C_ENVIRONMENT *s, Test1_OO o, Test1_A0 a)
{
  printf ("Test1.o2.OO-A0-to-CSS\n");
  if (o == NULL)
    {
      s->_major = ILU_C_USER_EXCEPTION;
      s->returnCode = ex_Test1_E2;
      s->ptr = (void *) malloc(sizeof(ilu_integer));
      *((ilu_integer *) s->ptr) = 7;
      return (*Test1_CSS_Create(0,NULL));
    }
  else
    {
      Test1_CSS *css = Test1_CSS_Create (0, NULL);
      return (*css);
    }
}

Test1_A0 * server_Test1_O2_R_I_A1_to_I_A0 (Test1_O2 self, ILU_C_ENVIRONMENT *s, Test1_R *r, Test1_I *i, Test1_A1 a)
{
  Test1_A0 * a2;

  printf ("Test1.O2.R-I-A1-to-I-A0\n");
  a2 = (Test1_A0 *) malloc(8);
  return (a2);
}

static char *strdup(char *s)
{
  char *copy = NULL;
  if (s != NULL)
    {
      copy = malloc(strlen(s) + 1);
      strcpy (copy, s);
    }
  return (copy);
}

Test1_IS server_Test1_O3_RS_R_to_R_IS (Test1_O3 self, ILU_C_ENVIRONMENT *s, Test1_RS *r, Test1_R *r2)
{
  Test1_IS is;

  printf ("Test1.O3.RS-R-to-R-IS\n");
  r2->i = 3;
  r2->css._maximum = 0;
  r2->css._length = 0;
  r2->css._buffer = NULL;
  r2->a[0] = strdup("just");
  r2->a[1] = strdup("a");
  r2->a[2] = strdup("string");
  is._maximum = 0;
  is._length = 0;
  is._buffer = NULL;
  return (is);
}

Test1_IS server_Test1_P_RS_R_to_R_IS (Test1_P self, ILU_C_ENVIRONMENT *s, Test1_RS *r, Test1_R *r2)
{
  Test1_IS is;

  printf ("Test1.P.RS-R-to-R-IS\n");
  r2->i = 25719;
  r2->css._maximum = 0;
  r2->css._length = 0;
  r2->css._buffer = NULL;
  r2->a[0] = strdup("from");
  r2->a[1] = strdup("P");
  r2->a[2] = strdup("string");
  is._maximum = 0;
  is._length = 0;
  is._buffer = NULL;
  return (is);
}

Test1_I server_Test1_P_BS_to_I (Test1_P self, ILU_C_ENVIRONMENT *s, Test1_BS *b)
{
  return (b->_length);
}

Test1_I server_Test1_O3_BS_to_I (Test1_P self, ILU_C_ENVIRONMENT *s, Test1_BS *b)
{
  return (b->_length * b->_length);
}

Test1_I server_Test3_O_BS_to_I (Test3_O self, ILU_C_ENVIRONMENT *s, Test1_BS *b)
{
  return (b->_length * b->_length);
}

Test1_IS server_Test1_P_m2 (Test1_P self, ILU_C_ENVIRONMENT *s, long int j)
{
  Test1_IS foo;

  foo._maximum = 2;
  foo._length = 2;
  foo._buffer = (long int *) malloc(foo._maximum * sizeof(long int));
  foo._buffer[0] = j;
  foo._buffer[1] = j * j;
  return (foo);
}

void server_Test1_O3_O1_U_to_U (Test1_O3 self, ILU_C_ENVIRONMENT *s, Test1_O1 o, Test1_U *u)
{
  printf ("Test1.O3.O1-U-to-U\n");
  u->_d = Test1_U_O1;
  u->_u.O1 = o;
  return;
}

void server_Test1_P_O1_U_to_U (Test1_P self, ILU_C_ENVIRONMENT *s, Test1_O1 o, Test1_U *u)
{
  printf ("Test1.P.O1-U-to-U\n");
  u->_d = Test1_U_O1;
  u->_u.O1 = o;
  return;
}

Test1_IS server_Test3_O_RS_R_to_R_IS (Test3_O self, ILU_C_ENVIRONMENT *s, Test1_RS *r, Test1_R *r2)
{
  Test1_IS is;

  printf ("Test3.O.RS-R-to-R-IS\n");
  r2->i = 3;
  r2->css._maximum = 0;
  r2->css._length = 0;
  r2->css._buffer = NULL;
  r2->a[0] = strdup("just");
  r2->a[1] = strdup("a");
  r2->a[2] = strdup("string");
  is._maximum = 0;
  is._length = 0;
  is._buffer = NULL;
  return (is);
}

void server_Test3_O_O1_U_to_U (Test1_O3 self, ILU_C_ENVIRONMENT *s, Test1_O1 o, Test1_U *u)
{
  printf ("Test3.O.O1-U-to-U(0x%lx, {%d})\n", (unsigned long) o, u->_d);
  u->_d = Test1_U_O1;
  u->_u.O1 = o;
  return;
}

ilu_integer server_Test3_O_SR_to_I (Test3_O self, ILU_C_ENVIRONMENT *s, ilu_shortreal i)
{
  ilu_integer j = i;

  printf ("Test3.O.SR-to-I(%f)\n", i);
  return (j);
}

Test1_U server_Test3_O_I_to_Test1U (Test3_O self, ILU_C_ENVIRONMENT *s, Test1_I i)
{
  Test1_U u;

  printf ("Test3.O.I-to-Test1U(%ld)\n", i);
  u._d = Test1_U_boolean;
  u._u.boolean = ilu_TRUE;
  return (u);
}
