;;;-*- Package: IMPL-FS; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-
#|
 Copyright (c) 1991, 1992, 1993, 1994 Xerox Corporation.  All Rights Reserved.  
 
 Unlimited use, reproduction, and distribution of this software is
 permitted.  Any copy of this software must include both the above
 copyright notice of Xerox Corporation and this paragraph.  Any
 distribution of this software must comply with all applicable United
 States export control laws.  This software is made available AS IS,
 and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

 $Id: impl-fs.lisp,v 1.11 1994/05/02 18:43:25 janssen Exp $
|#

(cl:defpackage :impl-fs
  (:use :common-lisp :ilu :fs)
  (:shadow cl:directory)
  (:export #:server-impl #:start-server))

(cl:in-package :impl-fs)

(defclass server-impl (server.impl) ())

(defclass file-impl (file.impl)
  ((pathname :initarg :pathname)))

(defclass directory-impl (file-impl directory.impl) ())

(defparameter *found-files* nil)

(defmethod find-file ((server server-impl) name)
  (let ((pathname (probe-file name)))
    (or (if pathname
	    (or (cdr (assoc pathname *found-files* :test #'equal))
		(let* ((directory-p (and (null (pathname-name pathname))
					 (null (pathname-type pathname))))
		       (entry (if directory-p
				  (make-instance 'directory-impl
				    :pathname pathname)
				(make-instance 'file-impl :pathname pathname))))
		  (setf *found-files* (acons pathname entry *found-files*))
		  entry)))
	(signal 'not-found :exception-value name))))

(defmethod info ((file file-impl))
  (with-slots (pathname) file
    (make-file-info
     :name (namestring pathname)
     :owner (file-author pathname)
     :write-date (- (file-write-date pathname)
		    (encode-universal-time 0 0 0 1 1 1970))
     :length (with-open-file (stream pathname) 
	       (file-length stream)))))

(defmethod touch ((file file-impl))
  (with-slots (pathname) file
   ))

(defmethod touch-a ((file file-impl))
  (with-slots (pathname) file
   ))

(defmethod contents ((file file-impl) start length)
  (with-slots (pathname) file
    (with-open-file (stream pathname) 
      (unless (<= 0 start (+ start length) (file-length stream))
	(signal 'out-of-bounds)))
    (let ((byte-vector (make-array length :element-type '(unsigned-byte 8))))
      (with-open-file (stream pathname :element-type '(unsigned-byte 8))
	(file-position stream start)
	(dotimes (i length)
	  (setf (aref byte-vector i) (read-byte stream))))
      byte-vector)))

(defmethod files ((directory directory-impl) pattern)
  (unless pattern (setq pattern (make-pathname :name :wild :type :wild)))
  (with-slots (pathname) directory
    (mapcar #'namestring (cl:directory (merge-pathnames pattern pathname)))))

;;==================================================
;; start a server
;;==================================================

(defun start-server ()
  (make-instance 'server-impl))
