(* this file was automatically generated at Fri May 7 12:50:06 1993 by
   spreitze running "m3-stubber" on "Baz.isl". *)

UNSAFE MODULE Baz_c EXPORTS Baz, Baz_x;
IMPORT Ilu, IluBasics, IluRuntime, Thread;
IMPORT Foo, Foo_x;
IMPORT Bar_x;

REVEAL
  Surrogate_O = O BRANDED OBJECT
                  server: Ilu.SurrogateServer := NIL;
                OVERRIDES
                  U_CSS_to_U := Foo_x.Client_O_U_CSS_to_U;
                  (**  f_CSS_to_RO    := Foo_x.Client_O_f_CSS_to_RO;
                       R_ScS_to_F     := Foo_x.Client_O_R_ScS_to_F;
                       a_RO           := Foo_x.Client_O_a_RO; **)
                  M1             := Client_O_M1;
                  ILU_Get_Server := Get_Surrogate_Server_From_O;
                END;

TYPE
  Lead_O = Surrogate_O BRANDED OBJECT
             ilu_following_P: Following_O_P;
           OVERRIDES
             ILU_Qua_Type := Qua_From_Lead_O
           END;

TYPE
  Following_O_P = Bar_x.Surrogate_P OBJECT
                    ilu_the_leader: Lead_O
                  OVERRIDES
                    ILU_Get_Type := ILU_Get_Type_O;
                    ILU_Qua_Type := Qua_From_Following_O_P
                  END;

PROCEDURE Create_Lead_O (<*UNUSED*> self  : IluRuntime.ObjectCreator;
                                    server: Ilu.SurrogateServer ):
  Ilu.Object RAISES {} =
  VAR x := NEW(Lead_O, ilu_following_P := NEW(Following_O_P));
  BEGIN
    x.ilu_following_P.ilu_the_leader := x;
    Bar_x.Init_Surrogate_P(x.ilu_following_P, server);
    Init_Surrogate_O(x, server);
    RETURN x;
  END Create_Lead_O;

PROCEDURE Init_Surrogate_O (self  : Surrogate_O;
                            server: Ilu.SurrogateServer )
  RAISES {} =
  BEGIN
    self.ilu_is_surrogate := TRUE;
    self.server := server;
  END Init_Surrogate_O;

PROCEDURE Qua_From_Lead_O (self: Lead_O; ot: Ilu.ObjectType):
  Ilu.Object =
  BEGIN
    IF ot = ObjectType_O THEN
      RETURN self
    ELSIF ot = Foo_x.ObjectType_O THEN
      RETURN self
    ELSIF ot = Bar_x.ObjectType_P THEN
      RETURN self.ilu_following_P
    ELSE
      RETURN NIL
    END;
  END Qua_From_Lead_O;

PROCEDURE Qua_From_Following_O_P (self: Following_O_P;
                                  ot  : Ilu.ObjectType ): Ilu.Object =
  BEGIN
    RETURN Qua_From_Lead_O(self.ilu_the_leader, ot)
  END Qua_From_Following_O_P;

PROCEDURE ILU_SBH_To_O (sbh, mstid: TEXT): O
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR x := IluRuntime.M3ObjectFromSbh(sbh, ObjectType_O, mstid);
  BEGIN
    TYPECASE x OF
    | O (xx) => RETURN xx;
    ELSE
      RAISE
        IluBasics.Failed(
          NEW(
            IluBasics.Failure,
            info := "sbh " & sbh & " leads to non-Baz.O object"))
    END (*typecase*);
  END ILU_SBH_To_O;

PROCEDURE Get_Surrogate_Server_From_O (self: Surrogate_O): Ilu.Server =
  BEGIN
    RETURN self.server;
  END Get_Surrogate_Server_From_O;

PROCEDURE Client_O_M1 (self: O; i: INTEGER): Foo.U
  RAISES {IluBasics.Failed, Thread.Alerted, E1, Foo.E1} =
  VAR call: IluRuntime.Call;
  VAR scode: INTEGER;
  VAR result: Foo.U;
  BEGIN
    call := IluRuntime.BeginCall(self);
    IF call = NIL THEN
      RAISE
        IluBasics.Failed(
          NEW(IluBasics.Failure, info := "lost connection"))
    END;
    TRY
      TRY
        IluRuntime.BeginRequest(
          call, ObjectType_O, ADR(O_Methods[O_MethodNames.M1]),
          0 + IluRuntime.SizeM3Object(call, self, TRUE, ObjectType_O)
            + IluRuntime.SizeInteger(call, i));
        IluRuntime.OutputM3Object(call, self, TRUE, ObjectType_O);
        IluRuntime.OutputInteger(call, i);
        IluRuntime.FinishRequest(call);
      EXCEPT
        IluBasics.Failed (e) =>
          RAISE
            IluBasics.Failed(
              NEW(
                IluBasics.Failure, info := "problem marshalling call",
                subArg := e))
      END (*try*);
      TRY
        scode := IluRuntime.GetReply(call);
        IF scode = 0 THEN
          Foo_x.Get_U(call, result);
          RETURN result;
        ELSE
          Get_Exception(call, scode);
            <*ASSERT FALSE*>
        END (*if*);
      EXCEPT
        IluBasics.Failed (e) =>
          RAISE
            IluBasics.Failed(
              NEW(
                IluBasics.Failure, info := "reply problem", subArg := e))
      END (*try*);
    FINALLY
      IluRuntime.FinishCall(call);
    END (*try-finally*);
  END Client_O_M1;

BEGIN
  BeStarted();
END Baz_c.
