(* this file was automatically generated at Fri May 7 12:50:06 1993 by
   spreitze running "m3-stubber" on "Bar.isl". *)
(* Last tweaked by Mike Spreitzer November 22, 1993 1:06 pm PST *)

UNSAFE MODULE Bar_c EXPORTS Bar, Bar_x;
IMPORT Ilu, IluBasics, IluRuntime, Thread;

REVEAL
  Surrogate_P = P BRANDED OBJECT
                  server: Ilu.SurrogateServer := NIL;
                OVERRIDES
                  P1             := Client_P_P1;
                  ILU_Get_Server := Get_Surrogate_Server_From_P;
                END;

TYPE
  Lead_P = Surrogate_P BRANDED OBJECT
           OVERRIDES
             ILU_Qua_Type := Qua_From_Lead_P
           END;

PROCEDURE Create_Lead_P (<*UNUSED*> self  : IluRuntime.ObjectCreator;
                                    server: Ilu.SurrogateServer ):
  Ilu.Object RAISES {} =
  VAR x := NEW(Lead_P);
  BEGIN
    Init_Surrogate_P(x, server);
    RETURN x;
  END Create_Lead_P;

PROCEDURE Init_Surrogate_P (self  : Surrogate_P;
                            server: Ilu.SurrogateServer )
  RAISES {} =
  BEGIN
    self.ilu_is_surrogate := TRUE;
    self.server := server;
  END Init_Surrogate_P;

PROCEDURE Qua_From_Lead_P (self: Surrogate_P; ot: Ilu.ObjectType):
  Ilu.Object =
  BEGIN
    IF ot = ObjectType_P THEN RETURN self ELSE RETURN NIL END;
  END Qua_From_Lead_P;

PROCEDURE ILU_SBH_To_P (sbh, mstid: TEXT): P
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR x := IluRuntime.M3ObjectFromSbh(sbh, ObjectType_P, mstid);
  BEGIN
    TYPECASE x OF
    | P (xx) => RETURN xx;
    ELSE
      RAISE
        IluBasics.Failed(
          NEW(
            IluBasics.Failure,
            info := "sbh " & sbh & " leads to non-Bar.P object"))
    END (*typecase*);
  END ILU_SBH_To_P;

PROCEDURE Get_Surrogate_Server_From_P (self: Surrogate_P): Ilu.Server =
  BEGIN
    RETURN self.server;
  END Get_Surrogate_Server_From_P;

PROCEDURE Client_P_P1 (self: P; i: INTEGER): INTEGER
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR call: IluRuntime.Call;
  VAR scode: INTEGER;
  BEGIN
    call := IluRuntime.BeginCall(self);
    IF call = NIL THEN
      RAISE
        IluBasics.Failed(
          NEW(IluBasics.Failure, info := "lost connection"))
    END;
    TRY
      TRY
        IluRuntime.BeginRequest(
          call, ObjectType_P, ADR(P_Methods[P_MethodNames.P1]),
          0 + IluRuntime.SizeM3Object(call, self, TRUE, ObjectType_P)
            + IluRuntime.SizeInteger(call, i));
        IluRuntime.OutputM3Object(call, self, TRUE, ObjectType_P);
        IluRuntime.OutputInteger(call, i);
        IluRuntime.FinishRequest(call);
      EXCEPT
        IluBasics.Failed (e) =>
          RAISE
            IluBasics.Failed(
              NEW(
                IluBasics.Failure, info := "problem marshalling call",
                subArg := e))
      END (*try*);
      TRY
        scode := IluRuntime.GetReply(call);
        IF scode = 0 THEN
          RETURN IluRuntime.InputInteger(call);
        ELSE
          Get_Exception(call, scode);
            <*ASSERT FALSE*>
        END (*if*);
      EXCEPT
        IluBasics.Failed (e) =>
          RAISE
            IluBasics.Failed(
              NEW(
                IluBasics.Failure, info := "reply problem", subArg := e))
      END (*try*);
    FINALLY
      IluRuntime.FinishCall(call);
    END (*try-finally*);
  END Client_P_P1;

BEGIN
  BeStarted();
END Bar_c.
