(* BarM3Server.m3 *)
(* Last tweaked by Mike Spreitzer April 21, 1994 4:51 pm PDT *)

(* A server program that implements a Bar.P object. *)

MODULE BarM3Server EXPORTS Main;
IMPORT Bar, Ilu, IluBasics, Stdio, Thread, Time, Wr;

<*FATAL Thread.Alerted, Wr.Failure*>

TYPE
  TrueP = Bar.P OBJECT
            id: INTEGER;
          OVERRIDES
            ILU_Get_Server := ILU_Get_Server;
            P1             := P1;
            ILU_Qua_Type   := Qua_From_True_P;
          END;

VAR ts: Ilu.TrueServer;
VAR pType := Bar.ILU_Get_Type_P(NIL);
VAR pId := Ilu.IdOfObjectType(pType);

PROCEDURE Qua_From_True_P (self: TrueP; ot: Ilu.ObjectType):
  Ilu.Object =
  BEGIN
    IF ot = pType THEN RETURN self ELSE RETURN NIL END;
  END Qua_From_True_P;

PROCEDURE ILU_Get_Server (<*UNUSED*> self: TrueP): Ilu.Server =
  BEGIN
    RETURN ts;
  END ILU_Get_Server;

PROCEDURE P1 (self: TrueP; i: INTEGER): INTEGER RAISES {} =
  BEGIN
    RETURN i + self.id;
  END P1;

VAR bps1 := NEW(TrueP, id := 47);
VAR sbh1: TEXT;

BEGIN
  TRY
    ts := Ilu.InitTrueServer(NEW(Ilu.TrueServer));
    Ilu.Export_Server(ts, NEW(Ilu.SunRpc2), NEW(Ilu.TCP));

    sbh1 := Ilu.SbhFromObject(bps1);
    Wr.PutText(
      Stdio.stdout, "SBH1&mstid is '" & sbh1 & "' '" & pId & "'\n");
    Wr.Flush(Stdio.stdout);

    LOOP
      (* Linebreak, if you PLEASE! *)
      Time.LongPause(10);
    END (*loop*);
  EXCEPT
    IluBasics.Failed (e) =>
      Wr.PutText(
        Stdio.stderr,
        "IluBasics.Failed(" & IluBasics.FullInfo(e) & ")\n");
      Wr.PutText(
        Stdio.stderr,
        "(This might be caused by not registering Bar.isl)\n");
  END (*try*);
END BarM3Server.
