(in-package 'xtile)

(defun actual (options curint mind world)
  (if curint
      (let* ( (maxpr (findmaxactual 'options options mind world))
	      (maxopt (cadr maxpr))
	      (restopts (allbut options maxopt))
	      (maxoptval (if maxopt (car maxpr) 0))
	      (curintval (find-solution-length 'current-int curint mind world)))
	(if (>= curintval maxoptval)
	    (make-opts-later-ints options mind)
	    (and (make-current-int maxopt mind)
		 (make-opts-later-ints restopts mind)
		 (demote-to-later-int curint)
		 (kill-all-subplans mind))))
    (let* ( (maxpr (findmaxactual 'options options mind world))
	    (maxopt (cadr maxpr))
	    (restopts (allbut options maxopt))
	    (maxoptval (if maxopt (car maxpr) 0))
	    (maxintpr 
             (findmaxactual 'intentions (agent-intentions mind) mind world))
	    (maxint (cadr maxintpr))
	    (maxintval (if maxint (car maxintpr) 0)))
      (if (> maxoptval maxintval)
	  (and (make-current-int maxopt mind)
	       (make-opts-later-ints restopts mind))
	  (and (when (and maxint (> maxintval 0))
		     (promote-to-current-int maxint))
	       (make-opts-later-ints options mind))))))

(defun findmaxactual (object acts mind world)
  (let ( (bestval -1) (restacts acts) thisval new best)
    (do () ((null restacts))
	(setf new (first restacts))
	(setf thisval (find-solution-length object new mind world))
	(when (> thisval bestval) 
	      (setf best new)
	      (setf bestval thisval))
	(setf restacts (rest restacts)))
    (list bestval best)))


(defun find-solution-length (object act mind world)
;(format nil "~% action: ~s" act)
  (let* ( actualval action-list solution-length
          action
         (temp-world (tw-copy-world world))
         (temp-mind (copy-agent mind))
         (score (binding 'score (act-parms act)))
         (holeid (binding 'hole (act-parms act)))
         (hole (findhole holeid (tw-hole-list world)))
         (size (length (obj-cells hole)))
         (time (obj-timeout hole))
         (temp-act (act-copy act)))
    (cond ((eq object 'options)
           (setf dummy (make-current-int temp-act temp-mind))
           (setf action (current-int (agent-intentions temp-mind))))
          (t (setf action temp-act)))
    (do ((i 1 (1+ i)))((> i size)) 
                    ;(eq (act-type (first (last (act-subacts action)))) 'rest)
      (expand-fill action temp-world (agent-path-planner mind)))
    (setf action-list 
          (mapcar #'(lambda (x) (mapcar #'act-type (act-subacts x))) 
                  (act-subacts action)))
 (format nil  "~%action list ~s " action-list)
    (setf solution-length (apply #'+ (mapcar #'length action-list)))
 (format nil  "~%solution length: ~s " solution-length)
 (if (or (= solution-length 0)
         (null (car (last action-list)))) ;not enough tiles
     (setf actualval 0)
     (setf actualval (* 1.0 (/ score solution-length))))
 (format nil "~%ACTUAL: ~s " (list size time solution-length score actualval))
 (keephist "ACTUAL:  " 'write-actual 
           (list size time solution-length score actualval))
  actualval))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;evaluate all permutaions of hole filing sequences

;test current-int
;better figure a way to cache old plans especially for current-int
(defun optimal (options current-int mind world)
  (let ((option-sets 
         (generate-option-sets options (agent-intentions mind)))
        (best-score 0)
        (best-time 999999999)
        (best-option-set nil)
        best-hole
        impossible-subset
        )
     (do ((option-set (car option-sets)))((null option-sets) nil)
       (let (score-of-set
             time-for-set
             plan
             (new-world (tw-copy-world world)))
         (multiple-value-setq (score-of-set time-for-set plan impossible-subset)
                              (generate-plan option-set mind new-world))
         (format nil  "~%Plan ~s score: ~s time: ~s impossible: ~s ~%"
                (mapcar #'(lambda (x)(binding 'score (act-parms x))) option-set)
                score-of-set time-for-set (set-score impossible-subset)) 
         (keephist "SEU:  " 'write-optimal 
                (list (set-score option-set) score-of-set time-for-set plan))
         (cond ((or (> score-of-set best-score)
                    (and (= score-of-set best-score)
                         (< time-for-set best-time)))
                (setf best-score score-of-set 
                      best-time time-for-set
                      best-option-set option-set))
               (impossible-subset
                (setf option-sets 
                      (kill-similar-sets best-score 
                                         impossible-subset option-sets)))
               (t nil)))
       (setf option-sets (rest option-sets))
       (setf option-set (first option-sets)))
     (setf best-hole (car best-option-set))
     (format nil "~%Act selected ~s moves: ~s" (set-score (list best-hole))
        (mapcar #'(lambda (x)(mapcar #'act-type (act-subacts x))) 
                (act-subacts best-hole)))
     (if current-int
         (cond ((same-act current-int best-hole) ;need to test
                (kill-all-subplans mind);new hole may clobber 
                (make-opts-later-ints options mind))
               ((position best-hole (agent-intentions mind) 
                          :test #'same-act)
                (promote-to-current-int best-hole)
                (make-opts-later-ints options mind)
                (demote-to-later-int current-int)
                (kill-all-subplans mind))
               (t (make-current-int best-hole mind)
                  (make-opts-later-ints (remove best-hole options) mind)
                  (demote-to-later-int current-int)
                  (kill-all-subplans mind)))
         (cond ((position best-hole (agent-intentions mind) 
                          :test #'same-act)
                (promote-to-current-int best-hole)
                (make-opts-later-ints options mind))
               (t (make-current-int best-hole mind)
                  (make-opts-later-ints (remove best-hole options) 
                                        mind))))))

(defun generate-plan (original-option-sequence mind world)
  (let* ((temp-world (tw-copy-world world))
         (option-sequence (copy-and-clear-sequence original-option-sequence))
         (result-world (tw-copy-world world))
         (plan nil)
         (total-time-taken 0)
         (total-score 0))
    (dolist (option option-sequence)
      (let* ((score (binding 'score (act-parms option)))
             (holeid (binding 'hole (act-parms option)))
             (hole (findhole holeid (tw-hole-list world)))
             (size (length (obj-cells hole)))
             (time (obj-timeout hole))
             action-list
             solution-length)
        (do ((i 1 (1+ i)))((all-actions-generated option result-world))
          (setf result-world 
                (expand-fill option temp-world (agent-path-planner mind))))
        (setf temp-world (copy-world result-world))
        (setf action-list 
              (mapcar #'(lambda (x) (mapcar #'act-type (act-subacts x))) 
                      (act-subacts option)))
        (format nil "~%Hole:~s Action-list: ~s" score action-list)
        (setf solution-length (apply #'+ (mapcar #'length action-list)))
        (setf plan (append plan action-list))
        (setf total-time-taken 
              (+ (* solution-length (agent-act-time mind)) total-time-taken))
        (cond ((impossible-within-timelimits action-list
                                             total-time-taken time 
                                             (- *game-length* 
                                                (tw-elapsed-time world))
                                             (/ (agent-act-time mind) 2))
               (return-from generate-plan
                 (values total-score total-time-taken plan
                         (subseq option-sequence 0 
                                 (1+ (position option option-sequence))))))
              (t (setf total-score (+ score total-score))))))
    (values total-score total-time-taken plan nil)))


(defun all-actions-generated (action world)
  (or (null world)
      (and  (not (null (act-subacts action)))
            (not (eq (act-type (first (last (act-subacts action)))) 'rest)))))
       
(defun copy-world (world)
  (if world 
      (tw-copy-world world)
      nil))

;may need to account for think time 
;can kill more! look at timeouts of next holes on the list
(defun impossible-within-timelimits (action-list act-time 
                                                 timeout game-end think-time)
  (let ((impossible nil)
        (needed (+ act-time think-time)))
    (when (or (null action-list)
              (null (car (last action-list))) ;not enough tiles
              (>= needed timeout)
              (>= needed game-end))
      (setf impossible t)
      (format nil "~%impossible: needed ~s timeout ~s game-end ~s"
              needed timeout game-end))
    impossible))

;kill any plan that 1) has the impossible subset. or 2) has a variation

(defun kill-similar-sets (best subset sets)
  (let ((new-sets nil))
  (dolist (set sets (reverse new-sets))
    (let* ((size (length subset))
           (timeout-act (last subset))
           (achievable-acts (subseq subset 0 (1- size)))
           (possible-acts 
            (subseq set 0 (position (car timeout-act) set :test #'same-act)))
           (possible-acts-score (apply #'+ (set-score possible-acts))))
      (if (and (< possible-acts-score best)
               (apply #'< 
                      (mapcar #'(lambda(x)(position x set :test #'same-act)) 
                                  (append achievable-acts timeout-act))))
          (format nil "~%set killed ~s score ~s" (set-score set)
                  (apply #'+ (set-score possible-acts)))
          (setf new-sets (cons set new-sets)))))))

(defun kill-test (subset sets)
  (let ((new-sets nil))
  (dolist (set sets (reverse new-sets))
    (let* ((size (length subset))
           (timeout-act (last subset))
           (achievable-acts (subseq subset 0 (1- size))))
      (if (or (search subset set )
              (and (search achievable-acts set )
                   (search timeout-act 
                           (subseq set 
                                   (+ (search achievable-acts set)
                                      (length achievable-acts))))))
          (format nil "~%set killed ~s" set)
          (setf new-sets (cons set new-sets)))))))

(defun generate-option-sets (options intentions)
  (let ((hole-list (append options intentions)))
    (generate-permutations hole-list)))

(defun generate-permutations (set)
  (let ((size (length set))
        (permutations nil))
    (if (null set) 
        (list nil)
        (do ((l size (1- l)))((= l 0) permutations)
          (let ((element (nth (1- l) set)))
            (setq permutations 
                  (append (mapcar #'(lambda (x) (adjoin element x))
                                (generate-permutations (remove element set)))
                        permutations)))))))

(defun sets-scores (sets)
  (mapcar #'set-score sets))


(defun set-score (x)
  (if (car x)
      (mapcar #'(lambda (x)(binding 'score (act-parms x))) x)
      nil))

(defun copy-and-clear-sequence (seq)
  (let ((new-seq (mapcar #'act-copy seq)))
    (mapcar #'(lambda (x) (setf (act-subacts x) nil)) new-seq)
   new-seq))

(defun copy-and-clear-option (opt)
  (setf (act-subacts (act-copy opt)) nil))

(defun write-actual (args)
  (write "Size:" :stream *history*)
  (write (car args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Time:" :stream *history*)
  (write (cadr args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Solution length:" :stream *history*)
  (write (caddr args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Score:" :stream *history*)
  (write (cadddr args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Actual Value:  " :stream *history*)
  (write (car (cddddr args)) :stream *history*)
  (write-char #\Newline *history*))

(defun write-optimal (args)
  (write "Holes:" :stream *history*)
  (write (car args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Total score:" :stream *history*)
  (write (cadr args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Action time needed:" :stream *history*)
  (write (caddr args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Action plan:" :stream *history*)
  (write (cadddr args) :stream *history*)
  (write-char #\Newline *history*))

(setf *old-mind2* nil)
;if two consecutive calls to think do not change current-init then nothing 
; to plan
(defun xtw-step ()
  (cond ((and *game-length* (>= *elapsed* *game-length*))
	 (xtw-end-game)
	 t)
	((let (mind1 mind2 think-time cycles-to-act)
	   (setf mind1 (agent-copy *agent*))
	   (setf mind2 (agent-copy *agent*))
           (setf *old-mind1* (agent-copy *agent*))
	   (setf think-time (think *world* mind1 *old-mind2*))
	   (keephist "THINK TIME USED:"  'write-plain (* 1.0 think-time))
	   (setf cycles-to-act (- (floor (/ (if *game-length*
						(min (+ *elapsed* think-time)
						     *game-length*)
					      (+ *elapsed* think-time))
					    (agent-act-time *agent*)))
				  (floor (/ *elapsed*
					    (agent-act-time *agent*)))))
	   (multiple-value-setq (*world* mind2)
				(act *world* mind2 cycles-to-act))
	   (merge-minds *agent* mind1 mind2)
           (setf *old-mind2* (agent-copy *old-mind1*))
	   (setf *elapsed* (+ *elapsed* think-time))
	   (setf *time-remaining* (- *game-length* *elapsed*))
	   (when *display-on* 
             (xtw-world-timedisp)
             (xtw-world-scoredisp))
	   ))))

(defun xtw-world-start ()
  ;(setf *keephistory* nil)		;These are all fossils
  ;(setf *historyfile* nil)
  (setf *old-mind1* nil)
  (setf *old-mind2* nil)
  (setf *exprfile* *exper-logfile*)
  (setf *game-length* *world-time-limit*)
  (setf *current-seed* *world-rand-seed*)
  (setf *seeds-left* *world-nseeds*)
  ;(if (or (not (boundp '*world*)) (null *world*))
  ;(setf *world* wnnn))		;just a dummy kind of thing, fossil
  (setf (tw-rand-seed *world*) *world-rand-seed*)
  (setf (tw-rows *world*) *world-board-size*)
  (setf (tw-cols *world*) *world-board-size*)
  (xtw-set-world-knobs)
  (setf *elapsed* 0)
  (setf *time-remaining* (- *game-length* *elapsed*))
  (tw-init *world*)
  (when *display-on*
    (xtw-world-display *world*)
    (xtw-world-new-dialog))
  (keephist  "HOLES INITIALLY AROUND:"  'write-holes (tw-hole-list *world*))
  nil
  )

;(defun next-random-tile (world expanded)
;  ;unexpanded limbo expanded marked twgrid twgridwhich
;  (let (this
;        (tile-list (mapcar #'(lambda (x)(values (list (obj-row x)(obj-col x))))
;                           (tw-tile-list *world*))))
;    (loop
;      (setf tile-list (set-difference tile-list expanded :test #'equal))
;      (when (null tile-list)
;        (return-from next-random-tile (values nil expanded)))
;      (setf this 
;            (elt tile-list (random (length tile-list))))
;      (setf expanded (cons this expanded))
;      (format nil "~%tile-list ~s tile ~s expanded ~s" tile-list this expanded)
;      (return-from next-random-tile 
;       (values (aref (tw-grid-which world) (car this)(cadr this)) expanded)))))

(defun agent-copy (agent)
  (let ( (new-agent (copy-agent agent)))
    (setf (agent-intentions new-agent) (acts-copy (agent-intentions agent)))
    (setf (agent-options new-agent) (opts-copy (agent-options agent)))
    new-agent))



