;;;
;;; exper-save.lisp
;;;
;;; functions for saving the current experiment parameters in an exper-
;;; iment file, which can then be "run" or catted together with other
;;; experiment files.
;;;

(in-package 'xtile)

(defun exper-save ()
  (let ((filename (defsystem::append-directories
		    *experiment-dir-name*
		    *exper-save-file-name*)))
    (with-open-file 
     (outfile filename
	      :direction :output
	      :if-exists :append
	      :if-does-not-exist :create
	      )
     (format outfile
	     "
;;; The following is machine-generated experiment file code generated by
;;; the exper-save function in exper/exper-save.  Don't tamper with it
;;; unless you know what you're doing.  This file can safely be concat-
;;; enated together with other experiment files to produce a series of
;;; experiments.

")
     (pprint '(in-package 'xtile) outfile)
     (setf *exper-save-time* (exper-current-time))
     (pprint '(if (not (boundp '*experiment-list*)) 
		  (setf *experiment-list* nil))
	     outfile)
     (pprint `(setf *experiment-list*
		    (cons '(progn
			     (setf *series-name* ,*series-name*)

			     (setf *exper-name* ,*exper-name*)
			     (setf *exper-save-file-name* ,*exper-save-file-name*)
			     (setf *exper-keeplog* ,*exper-keeplog*)
			     (setf *exper-logfile* ,*exper-logfile*)
			     (setf *exper-keephistory* ,*exper-keephistory*)
			     (setf *exper-historyfile* ,*exper-historyfile*)
			     (setf *exper-save-time* ',*exper-save-time*)

			     (setf *agent-name* ,*agent-name*)
			     (setf *agent-speed* ,*agent-speed*)
			     (setf *agent-evalfunc* ',*agent-evalfunc*)
			     (setf *agent-path-planner* ',*agent-path-planner*)
			     (setf *agent-threshold* ,*agent-threshold*)

			     (setf *world-name* ,*world-name*)
			     (setf *world-speed* ,*world-speed*)
			     (setf *world-hole-score-min* 
				   ,*world-hole-score-min*)
			     (setf *world-hole-score-max*
				   ,*world-hole-score-max*)
			     (setf *world-hole-num-min* 
				   ,*world-hole-num-min*)
			     (setf *world-hole-num-max*
				   ,*world-hole-num-max*)
			     (setf *world-hole-size-min* 
				   ,*world-hole-size-min*)
			     (setf *world-hole-size-max*
				   ,*world-hole-size-max*)
			     (setf *world-time-limit*
				   ,*world-time-limit*)
			     (setf *world-rand-seed* ,*world-rand-seed*)
			     (setf *world-nseeds* ,*world-nseeds*)
			     (setf *world-wait-between-seeds*
				   ,*world-wait-between-seeds*)
			     (setf *world-wait-after-all-seeds*
				   ,*world-wait-after-all-seeds*)
			     (setf *world-board-size* ,*world-board-size*)
			     )
			  *experiment-list*
			  )
		    )
	     outfile)
     )
    (format t "Saved file ~A.~%" filename)
    )
  )
