;;;
;;; common.lisp
;;;
;;; Miscellaneous functions that are common to both 
;;; the world module and the agent module, and may 
;;; be used by both.
;;;

;;; parse-range takes a string of the form "25-75" and returns 25
;;; and 75 as separate values.  If the input string is not of the form
;;; of two integers separated by a dash, parse-range will return nil.
;;; Except things like "25 (low) - 75 (high)" are okay, too.

(in-package 'xtile)

(defun parse-range (range-string)
  (let ((dashpos (position #\- range-string)))
    (if dashpos
	(let ((v1 (read-from-string (subseq range-string 0 dashpos) nil))
	      (v2 (read-from-string (subseq range-string (1+ dashpos)) nil)))
	  (if (and (integerp v1) (integerp v2))
	      (values v1 v2))))))
