/*  twpush.c - plan a path for the agent pushing a tile.  MNR 8/4/89.

    Assumes single-cell agent and tiles, and that holes are obstacles.

    Interface:
	pushplan(xmax,ymax,grid,occupied,tile_x,tile_y,orientation)
        --> returns a null-terminated string of udlr's, or 'x' if no path.

    where
        - grid is an array of xmax*ymax characters.  D's are destinations.
	- occupied[ch] == 1 iff occupied by obstacle
	- orientation is direction of agent from tile - 0 means agent
	     is above tile; 1 means two o'clock...7 means 10 o'clock.
	- the agent will not step on a D.

    Parameters to bfs: 
        Search space is xmax*ymax*8
	4 transitions: udlr
	4 ways to enter a given x,y: udlr.

*/

/* #include "/usr/cs/include/libc.h"*/
#include <curses.h>
#include <signal.h>
#include "/srv/fs0/allegrocl/lib/misc/lisp.h"

int xmax,ymax,xy;
char *grid,*occupied,*shown,occupied2[256];

char *pushplan(xmax1,ymax1,grid1,occupied1,source_x,source_y,orientation)
   int xmax1,ymax1,source_x,source_y;
   char *grid1,*occupied1;

{   /* this code is facilitate returning strings to Lisp */
    int stbuf_index;
     /* */
    int x,y,source,path_source,path_length,*path,
        push_is_dest(),push_gen_trans(),push_inv_trans();
    short int source_cost,path_cost;
    char *malloc(),*moves;

   stbuf_index = 0;

    xmax=xmax1;
    ymax=ymax1;
    xy=xmax*ymax;
    grid=grid1;
    occupied=occupied1;
    for(x=0;x<256;++x) occupied2[x]=occupied[x];
    occupied2['D']=1;			    /* agent can't step on D */

    source=orientation*xy+source_x*ymax+source_y;
    source_cost=0;

    bfs(xmax*ymax*8,4,1,&source,&source_cost,
        push_is_dest,push_gen_trans,push_inv_trans,
        &path_source,&path_length,&path,&path_cost);
    if (path_length==-1) {
	moves=malloc(2);
	*moves='x';
	*(moves+1)=0;
    } else {
	moves=malloc(path_length+1);
	for(x=0;x<path_length;++x) {
	    switch(path[x]) {
		case 0: *(moves+x)='u'; break;
		case 1: *(moves+x)='d'; break;
		case 2: *(moves+x)='l'; break;
		case 3: *(moves+x)='r'; break;
	    }
	}
	*(moves+path_length)=0;
    }
    strcpy((char *) Vecdata(SymbolValue(lisp_value(stbuf_index))),moves);
    return (char *) SymbolValue(lisp_value(stbuf_index));

    /* return moves; */
}

push_is_dest(pos)
    int pos;
{
    return grid[pos%xy]=='D';
}


push_gen_trans(state,new_states,new_costs)
    int state,*new_states;
    short int *new_costs;
{
    int i;

    for (i=0;i<4;++i)
        push_trans_fn(state,i,new_states+i,new_costs+i);
}


push_inv_trans(state_p,transition,new_state)
    int *state_p,transition,new_state;
{
    short int garbage;
    int orientation;

    orientation=new_state/xy;
    if (transition==0 && orientation==4)		/* inv(push u) */
	    (*state_p)=new_state+xmax;
    else if (transition==1 && orientation==0)		/* inv(push d) */
	    (*state_p)=new_state-xmax;
    else if (transition==2 && orientation==2)		/* inv(push l) */
	    (*state_p)=new_state+1;
    else if (transition==3 && orientation==6)		/* inv(push r) */
	    (*state_p)=new_state-1;
    else push_trans_fn(new_state,transition^1,state_p,&garbage);
}

int cnt=0;

push_trans_fn(state,transition,new_state_p,cost_p)
    int state,transition,*new_state_p;
    short int *cost_p;
{
/*if ((state)==-1) printf("trans: (badbad)%d ",transition);
else printf("trans: (%d,%d,%d)%d ",(state%xy)/ymax,(state%xy)%ymax,state/xy,
transition);*/
    if (transition==0) {
/*	case 0:*/			/* u */
	    switch(state/xy) {   /* orientation */
		case 0:		/* agent is up */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 1:		/* up right */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 2:		/* right */
		    (*new_state_p)=state-xy;
		    if (occupied2[*(grid+(*new_state_p)%xy-xmax+1)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 3:		/* down right */
		    (*new_state_p)=state-xy;
		    if (occupied2[*(grid+(*new_state_p)%xy+1)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 4:		/* down */
		    (*new_state_p)=state-xmax;
		    if (occupied[*(grid+(*new_state_p)%xy)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 5:		/* down left */
		    (*new_state_p)=state+xy;
		    if (occupied2[*(grid+(*new_state_p)%xy-1)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 6:		/* left */
		    (*new_state_p)=state+xy;
		    if (occupied2[*(grid+(*new_state_p)%xy-1-xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 7:		/* up left */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
	    }
    } 
    if (transition==1) {
/*	case 1:*/			/* d */
	    switch(state/xy) {   /* orientation */
		case 0:		/* agent is up */
		    (*new_state_p)=state+xmax;
		    if (occupied[*(grid+(*new_state_p)%xy)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 1:		/* up right */
		    (*new_state_p)=state+xy;
		    if (occupied2[*(grid+(*new_state_p)%xy+1)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 2:		/* right */
		    (*new_state_p)=state+xy;
		    if (occupied2[*(grid+(*new_state_p)%xy+1+xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 3:		/* down right */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 4:		/* down */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 5:		/* down left */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 6:		/* left */
		    (*new_state_p)=state-xy;
		    if (occupied2[*(grid+(*new_state_p)%xy-1+xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 7:		/* up left */
		    (*new_state_p)=state-xy;
		    if (occupied2[*(grid+(*new_state_p)%xy-1)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
	    }
    }
    if (transition==2) {
/*	case 2:*/			/* l */
	    switch(state/xy) {   /* orientation */
		case 0:		/* agent is up */
		    (*new_state_p)=state+7*xy;
		    if (occupied2[*(grid+(*new_state_p)%xy-1-xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 1:		/* up right */
		    (*new_state_p)=state-xy;
		    if (occupied2[*(grid+(*new_state_p)%xy-xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 2:		/* right */
		    (*new_state_p)=state-1;
		    if (occupied[*(grid+(*new_state_p)%xy)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 3:		/* down right */
		    (*new_state_p)=state+xy;
		    if (occupied2[*(grid+(*new_state_p)%xy+xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 4:		/* down */
		    (*new_state_p)=state+xy;
		    if (occupied2[*(grid+(*new_state_p)%xy+xmax-1)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 5:		/* down left */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 6:		/* left */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 7:		/* up left */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
	    }
    }
    if (transition==3) {
/*	case 3:	*/		/* r */
	    switch(state/xy) {   /* orientation */
		case 0:		/* agent is up */
		    (*new_state_p)=state+xy;
		    if (occupied2[*(grid+(*new_state_p)%xy+1-xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 1:		/* up right */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 2:		/* right */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 3:		/* down right */
		    (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 4:		/* down */
		    (*new_state_p)=state-xy;
		    if (occupied2[*(grid+(*new_state_p)%xy+1+xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 5:		/* down left */
		    (*new_state_p)=state-xy;
		    if (occupied2[*(grid+(*new_state_p)%xy+xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 6:		/* left */
		    (*new_state_p)=state+1;
		    if (occupied[*(grid+(*new_state_p)%xy)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
		case 7:		/* up left */
		    (*new_state_p)=state-7*xy;
		    if (occupied2[*(grid+(*new_state_p)%xy-xmax)])
		        (*new_state_p)= -1;
		    (*cost_p)=1; break;
	    }
    }
/*if ((*new_state_p)==-1) printf("= none.\n");
else printf("= (%d,%d,%d).\n",((*new_state_p)%xy)/ymax,
((*new_state_p)%xy)%ymax,(*new_state_p)/xy);
++cnt; if (cnt>30) { cnt=0; getch();} */
}
