
;  AGENT-STRUCTURES
;  Structure definitions for the resource-bounded agent in Tileworld

(in-package 'xtile)

(defstruct agent
  ;parameters that are invariant through an experiment
  name			    ; name of this agent, for printing
  think-strategy            ;top-level strategy for deliberating or planning
  act-time                  ;length of time for an atomic action (in ms)
  wait-time                 ;length of time to wait if nothing's happening
  eval-strat               ;mode of deliberation
  path-planner              ;path planningh algorithm
  threshhold                ;filtering threshhold
  ;"mind" (vary during each experiment)
  options                   ;list of option-sets
  intentions                ;list of acts
  removed-intentions        ;for the 'act' mind: intentions removed
                            ; because they've been done by 'act' or
                            ; seen to disappear by 'perceive'
)

(defstruct option-set
  purpose                   ;intention id or 'SELF'
  alt-acts                  ;list of acts
)

(defstruct act
  id
  type
  status1		    ; option, intention
  status2		    ; to-be-deliberated/to-be-planned/to-be-executed/
			    ; to-be-deleted 
  parms                     ;list of parm name and binding pairs
  subacts                   ;list of acts
  enabling-conds
  postconds
  time
  atomic                    ;flag to indicate whether a base-level act
  failed		    ;flag to tell failed actions from completed ones
)

(defstruct parm
  name
  binding
)
