/*
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "conf.h"
#include "rplayd.h"
#include <sys/file.h>
#ifdef ultrix
#include <fcntl.h>
#else
#include <sys/fcntl.h>
#endif
#include <sys/param.h>
#include <sys/time.h>
#include <sys/signal.h>

#ifdef NEED_USLEEP
#ifdef __STDC__
int	usleep(unsigned long usec)
#else
int	usleep(usec)
unsigned long	usec;
#endif
{
	struct timeval	tv;

	tv.tv_sec = usec/1000000;
	tv.tv_usec = usec%1000000;
	select(0, 0, 0, 0, &tv);

	return 0;
}
#endif /* NEED_USLEEP */

/*
 * make a socket non-blocking
 */
#ifdef __STDC__
void	socket_nonblock(int sock_fd)
#else
void	socket_nonblock(sock_fd)
int	sock_fd;
#endif
{
	int	flags;

	flags = fcntl(sock_fd, F_GETFL, 0);
	if (flags < 0)
	{
		report("F_GETFL fcntl: %s\n", sys_errlist[errno]);
		done(1);
	}
#ifdef linux
	flags |= O_NONBLOCK;
#else
	flags |= FNDELAY;
#endif
	if (fcntl(sock_fd, F_SETFL, flags) < 0)
	{
		report("F_SETFL fcntl: %s\n", sys_errlist[errno]);
		done(1);
	}
}

/*
 * make a socket blocking
 */
#ifdef __STDC__
void	socket_block(int sock_fd)
#else
void	socket_block(sock_fd)
int	sock_fd;
#endif
{
	int	flags;

	flags = fcntl(sock_fd, F_GETFL, 0);
	if (flags < 0)
	{
		report("F_GETFL fcntl: %s\n", sys_errlist[errno]);
		done(1);
	}
#ifdef linux
	flags &= ~O_NONBLOCK;
#else
	flags |= FNDELAY;
#endif
	if (fcntl(sock_fd, F_SETFL, flags) < 0)
	{
		report("F_SETFL fcntl: %s\n", sys_errlist[errno]);
		done(1);
	}
}
