/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "conf.h"
#include <stdio.h>
#include <stdlib.h>
#include "rplayd.h"
#include "buffer.h"

static BUFFER	*buffers = NULL;
static int	nbuffers;	/* number of buffers on the free list */

#ifdef __STDC__
BUFFER	*buffer_create(void)
#else
BUFFER	*buffer_create()
#endif
{
	BUFFER	*b;

	if (buffers == NULL)
	{
		b = (BUFFER *)malloc(sizeof(BUFFER));
		if (b == NULL)
		{
			report("buffer_create: out of memory\n");
			done(1);
		}
	}
	else
	{
		nbuffers--;
		b = buffers;
		buffers = buffers->next;
	}
	
	b->nbytes = 0;
	b->buf[0] = '\0';
	b->status = BUFFER_FREE;
	b->next = NULL;

	return b;
}

#ifdef __STDC__
void	buffer_destroy(BUFFER *b)
#else
void	buffer_destroy(b)
BUFFER	*b;
#endif
{
	if (b->status != BUFFER_FREE)
	{
		return;
	}

	if (nbuffers == BUFFER_MAX_FREE)
	{
		free((char *)b);
	}
	else
	{
		nbuffers++;
		b->next = buffers;
		buffers = b;
	}
}
