/* synthesiser parameter graphical plot and manipulation

   (primarily movement, rather than insert/ delete).


   Paul Callaghan 3jan94. 


        synthesis stuff from my adaption of RSYNTH courtesy of JP Iles  & 
        Nick Ing_Smith (get from ftp.svr-eng.cam.ac.uk, or comp.speech).
        basic X shell from "3dplot" by k.toh, original version available from
        ftp.x.org (in contributions/).
*/


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/keysym.h>
#include <X11/bitmaps/grid4>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <math.h>

#include "Xdefs.h"

#include "proto.h"
#include "pardata.h"


#define max(x,y) ((x>y) ? x : y)
#define min(x,y) ((x>y) ? y : x)

unsigned long     background_pixel;               /* colour of background */
unsigned long     foreground_pixel;               /* colour of foreground */
unsigned long     border_pixel;                   /* colour of border */

/* window size defined. */
#define X_ORG            5
#define Y_ORG            5
#define X_DIM            800
#define Y_DIM            800

/* window width and height */
int Width, Height;

/* Misc X defaults */
#define DEFAULT_BORDER_WIDTH  3
#define DEFAULT_FONT          "8x13"


typedef enum { REVERSE, NORMAL } ButtonState;

/* symbols for non-param buttons */
#define PLAYIT                 (NPAR)
#define SAVEasNEXT         (NPAR+1)
#define SMOOTHIT        (NPAR+2)
#define QUITPROG        (NPAR+3)

#define DOUBLESCALE        (NPAR+4)
#define HALVESCALE        (NPAR+5)
#define CLIPUPPER        (NPAR+6)
#define CLIPLOWER        (NPAR+7)

#define EXPANDRANGE        (NPAR+8)
#define COLLAPSERANGE        (NPAR+9)
#define LEFTRANGE        (NPAR+10)
#define RIGHTRANGE        (NPAR+11)

#define NBUTTONS        (NPAR + 12)
int buttonHeight;                        /* set from font height + spacing */
int fontHeight;                                /* calculated in InitWindow() */

/* top-level program X variables. */
Display     *display;                   /* display */
int         screen;                     /* screen */
Window      parent_window;              /* parent window */
Window      graph_window;               /* the graph appears in here */
Window      buttons[NBUTTONS];          /* button windows */
char       *button_names[NBUTTONS];        /* names for the buttons */
XSizeHints  size_hints;                 /* window info for manager */
XFontStruct *font_info;                 /* font information */

GC          gc;                         /* context for graph window */
GC          bgc;                        /* graphics context for buttons */


/* rectangles for the graph windows. */
XRectangle outer_graph;                        /* the outside of the graph area */
XRectangle inner_graph;                        /* the plot area inside the axes */
int lowerRange, widthRange, upperRange; /* the region of frames being shown */


/* the index of parameter being displayed/edited */
int editingParameter = - 1;             


/* Initialize and merge the various options, used by InitWindow */

void Merge_Options()
{
   char    *option;

   /* process the various options */
   if (reverse < 0) {
      if ((option = XGetDefault(display,progname,"ReverseVideo")) != NULL)
         if (strcmp(option,"on")) reverse = 1;
   }
   if (!font_name) {
      /* option = XGetDefault(display,progname,"BodyFont"); */
      font_name = DEFAULT_FONT;
   }
}

/* init the main window, and subwindows = buttons and graph screen */

void InitWindow(argc,argv)
int  argc;
char **argv;
{
   XSetWindowAttributes wattributes;
   XGCValues  gcvalues;
   char       *sprintf(), default_geometry[100];
   char       *display_env;
   int        i, x, y, width, height;
   int        fontWidth, buttonsPerRow, buttonWidth, row, col, b;
   double     bwd;

   display_env = getenv("DISPLAY");
   if (display_env == NULL) {
      display_env = display_name;
   }

   /* Open display first, and get screen info */
   if (!(display = XOpenDisplay(display_env))) {
      fprintf(stderr,"%s:Could not open display %s\n",
              progname,display_env);
      exit(1);
   }
   screen = DefaultScreen(display);
   sprintf(default_geometry,"=%dx%d+%d+%d",X_DIM,Y_DIM,X_ORG,Y_ORG);

   /* Merge the options first */
   Merge_Options();

   /* pick up the black and white colour ids (assume mono screen) */
   if (reverse) {
      background_pixel = BlackPixel(display,screen);
      foreground_pixel = WhitePixel(display,screen);
   } else {
      background_pixel = WhitePixel(display,screen);
      foreground_pixel = BlackPixel(display,screen);
   }
   border_pixel     = foreground_pixel;        

   /* Initialize the window */
   if (!XGeometry(display,screen,geometry,default_geometry,border_width,
                 0,0,0,0,&x,&y,&width,&height)) {
      x      = X_ORG;
      y      = Y_ORG;
      width  = X_DIM;
      height = Y_DIM;
   }
   parent_window 
        = XCreateSimpleWindow(display, RootWindow(display,screen), x, y, 
                width, height, border_width, border_pixel, background_pixel);

   /* Find a font and load it. Load but not install ONLY to allow calculation
      of font height. */
   if (!(font_info = XLoadQueryFont(display,font_name))){
      fprintf(stderr,"%s:Could not open font %s\n",progname,font_name);
      exit(1);
   }

   /* store button height = font height + 2 for spacing */
   fontHeight = font_info->max_bounds.ascent+ font_info->max_bounds.descent;
   buttonHeight = fontHeight + 2;

   /* calculate layout of buttons. */
#define BUTTON_INDENT 5

   fontWidth = font_info->max_bounds.width;

   buttonsPerRow = (width - 2 * BUTTON_INDENT) / (fontWidth * PARNM_WD + 2);
                                                                /* +2 = spc'g */
   buttonWidth = (width - 2 * BUTTON_INDENT) / buttonsPerRow;

   /* create param buttons and record names. */  
   row = col = BUTTON_INDENT;

   for (b = 0; b < NPAR; ++b) {
      buttons[b] = XCreateSimpleWindow(display, parent_window, col, row, 
                buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
      button_names[b] = param_info[b].name;
      col += buttonWidth; 
      if (col >= width - buttonWidth) {
         col = BUTTON_INDENT;
         row += buttonHeight + 2 + 1;
                                /* +2 for the borders, +1 for spacing. */
      }
   }

                                        /* START OF BUTTON INITS */
   col = BUTTON_INDENT;
   row += buttonHeight + 2 + 1;                /* go to start of next row. */

   buttonWidth = (width - 10) / 4;
   buttons[PLAYIT]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[PLAYIT] = "Play the .pars";
   col += buttonWidth;

   buttons[SAVEasNEXT]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[SAVEasNEXT] = "Save in new file";
   col += buttonWidth;

   buttons[SMOOTHIT]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[SMOOTHIT] = "Run Spline on the data (nb 1000)";
   col += buttonWidth;

   buttons[QUITPROG]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[QUITPROG] = "Quit (NO SAVE)";

   col = BUTTON_INDENT;
   row += buttonHeight + 2 + 1;                /* go to start of next row. */

   buttons[DOUBLESCALE]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[DOUBLESCALE] = "Double scale from ctr";
   col += buttonWidth;

   buttons[HALVESCALE]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[HALVESCALE] = "Collapse scale onto ctr";
   col += buttonWidth;

   buttons[CLIPUPPER]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[CLIPUPPER] = "Clip to upper region";
   col += buttonWidth;

   buttons[CLIPLOWER]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[CLIPLOWER] = "Clip to lower region";

   col = BUTTON_INDENT;
   row += buttonHeight + 2 + 1;                /* go to start of next row. */

   buttons[EXPANDRANGE]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[EXPANDRANGE] = "Expand range from ctr";
   col += buttonWidth;

   buttons[COLLAPSERANGE]= XCreateSimpleWindow(display, parent_window, col, row,
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[COLLAPSERANGE] = "Collapse range onto ctr";
   col += buttonWidth;

   buttons[LEFTRANGE]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[LEFTRANGE] = "Move range left";
   col += buttonWidth;

   buttons[RIGHTRANGE]= XCreateSimpleWindow(display, parent_window, col, row, 
                  buttonWidth, buttonHeight, 1, border_pixel, background_pixel);
   button_names[RIGHTRANGE] = "Move range right";

                                        /* END OF BUTTON INITS */
   row += buttonHeight + 2 + 1;                /* incr. again to get past buttons */

   /* create the graph window and record the outer plot area. */
   outer_graph.x = 0;
   outer_graph.y = 0;
   outer_graph.width = width - 2 * BUTTON_INDENT;
   outer_graph.height = height - 2 * BUTTON_INDENT - row;
   graph_window 
     = XCreateSimpleWindow(display, parent_window, BUTTON_INDENT, row,
       outer_graph.width, outer_graph.height, 0, border_pixel,background_pixel);

   /* Initialize size hint property for window manager */
   size_hints.flags      = PPosition | PSize | PMinSize;
   size_hints.x          = x;
   size_hints.y          = y;
   size_hints.width      = width;
   size_hints.height     = height;
   size_hints.min_width  = X_DIM;
   size_hints.min_height = Y_DIM;

   /* set properties for window manager, with NO icon? (null) */
   XSetStandardProperties(display, parent_window, "klatt param editor", 
                               "kParEd", (Pixmap)NULL, argv, argc, &size_hints);



   /* Select event types wanted : RESTRICTED! */
   XSelectInput(display,graph_window, ExposureMask | ButtonPressMask | 
                          ButtonReleaseMask | ButtonMotionMask | KeyPressMask );

   for (i=0; i<NBUTTONS; i++) 
      XSelectInput(display,buttons[i], 
                            ExposureMask | ButtonPressMask | ButtonReleaseMask);

   /* Create GC for text and drawing */
   gc = XCreateGC(display, graph_window, 0, &gcvalues);

   /* create 2 graphics contexts for buttons */
   bgc  = XCreateGC(display, parent_window, 0, NULL);
   XSetForeground(display, bgc, background_pixel);

   /* Install the font which was loaded earlier into all GCs in use. */
   XSetFont(display, gc,   font_info->fid);
   XSetFont(display, bgc,  font_info->fid);

   /* specify foreground colour */
   XSetForeground(display, gc, foreground_pixel);
   XSetForeground(display, bgc, foreground_pixel);

   /* Display the window */
   XMapSubwindows(display, parent_window);
   XMapWindow(display, parent_window);
}


/* paints button 'i' in normal or reverse colours depending on 'mode' */

void paint_button(i, mode)
int    i;
ButtonState mode;
{
   char *sprintf(), *strcpy();

   Window button = buttons[i];

   if (mode == REVERSE) {
      XSetWindowBackground(display,button,foreground_pixel); 
      XSetBackground(display,bgc,foreground_pixel); 
      XSetForeground(display,bgc,background_pixel); 
   } else {
      XSetWindowBackground(display,button,background_pixel); 
      XSetBackground(display,bgc,background_pixel); 
      XSetForeground(display,bgc,foreground_pixel); 
   }
   /* clearing repaints the background */
   XClearWindow(display,buttons[i]);

   /* draw text */
   XDrawString(display, button, bgc, 2, font_info->max_bounds.ascent,
                button_names[i], strlen(button_names[i]));
}



/* redraw just the button area */

void RedrawButtons()
{
   int i;

   /* draw in the button names */
   for (i = 0; i < NBUTTONS; ++i) {
      paint_button(i, NORMAL);
   }
}

/* redraw the graph area */

void RedrawGraph()
{
   int i, leftSpace, baseSpace;
   char number[5 + 1];
   XPoint points[MAXFRAMES];
   int maxHeader, centre;

   XClearWindow(display, graph_window);

   XDrawString(display, graph_window, gc, outer_graph.x + outer_graph.width/2 - font_info->max_bounds.width*strlen(param_info[editingParameter].description)/2, outer_graph.y + fontHeight, param_info[editingParameter].description, strlen(param_info[editingParameter].description));
   XDrawString(display, graph_window, gc, outer_graph.x + outer_graph.width/2 - font_info->max_bounds.width*strlen(param_info[editingParameter].warning)/2, outer_graph.y + 2*fontHeight + 1, param_info[editingParameter].warning, strlen(param_info[editingParameter].warning));



/* calculate the inner rectangle */
   leftSpace = 5 * font_info->max_bounds.width + 2;        /* 5 nums + sp + axis */
   inner_graph.x = leftSpace;
   inner_graph.width = outer_graph.width - leftSpace;

   baseSpace = 3 * (fontHeight + 1) + fontHeight + 2;        /* (inf+sp)+axl+sp+ax */
   inner_graph.y = 2 * (fontHeight + 1);
   inner_graph.height = outer_graph.height - baseSpace - inner_graph.y;

/* draw the graph */
   for (i = 0; i < widthRange; ++i) {
      points[i].x = inner_graph.x + (i * inner_graph.width / widthRange); 
      points[i].y = inner_graph.y + inner_graph.height - (((frames[i+lowerRange].params[editingParameter] - param_info[editingParameter].lowerBound) * inner_graph.height) / (param_info[editingParameter].upperBound - param_info[editingParameter].lowerBound));
   }

   XSetLineAttributes(display,gc,1,LineSolid,CapButt,JoinBevel);
   XSetForeground(display,gc,foreground_pixel);
   XDrawLines(display, graph_window, gc, points, widthRange, CoordModeOrigin);

/* vertical axis, with ticks */
   {int t, ty;
    XDrawLine(display, graph_window, gc, inner_graph.x-2, inner_graph.y, inner_graph.x-2, inner_graph.y + inner_graph.height);
 
    for (t = 0; t < 9; ++t) {
       ty = inner_graph.y + (t * inner_graph.height) / 8;
       XDrawLine(display, graph_window, gc, inner_graph.x-6, ty, inner_graph.x-2, ty);
       sprintf(number, "%5ld", param_info[editingParameter].lowerBound + ((8-t) * (param_info[editingParameter].upperBound - param_info[editingParameter].lowerBound)) / 8);
       XDrawString(display, graph_window, gc, 0, ty + fontHeight / 2, number, strlen(number)); 
    }
   }


/* horizontal axis, no ticks */
   XDrawLine(display, graph_window, gc, inner_graph.x, inner_graph.y + inner_graph.height + 2, inner_graph.x + inner_graph.width, inner_graph.y + inner_graph.height + 2);
   sprintf(number, "%-5d", lowerRange);
   XDrawString(display, graph_window, gc, inner_graph.x, inner_graph.y + inner_graph.height + fontHeight + 1, number, strlen(number)); 
   sprintf(number, "%5d", upperRange-1);
   XDrawString(display, graph_window, gc, inner_graph.x + inner_graph.width - 5 * font_info->max_bounds.width, inner_graph.y + inner_graph.height + fontHeight + 1, number, strlen(number)); 

/* word, phoneme, element labels */
   {int frame;
    char *currentElement = NULL;
    char *currentPhoneme = NULL;
    char *currentWord = NULL;

    for (frame = lowerRange; frame < upperRange; ++frame) {
       if (frames[frame].element != currentElement) {
          currentElement = frames[frame].element;
          XDrawString(display, graph_window, gc, inner_graph.x + ((frame - lowerRange) * inner_graph.width) / widthRange, inner_graph.y + inner_graph.height + 2 * fontHeight, currentElement, strlen(currentElement));
       }
       if (frames[frame].phoneme != currentPhoneme) {
          currentPhoneme = frames[frame].phoneme;
          if (currentPhoneme) XDrawString(display, graph_window, gc, inner_graph.x + ((frame-lowerRange) * inner_graph.width) / widthRange, inner_graph.y + inner_graph.height + 3 * fontHeight, currentPhoneme, strlen(currentPhoneme));
       }
       if (frames[frame].word != currentWord) {
          currentWord = frames[frame].word;
          if (currentWord) XDrawString(display, graph_window, gc, inner_graph.x + ((frame-lowerRange) * inner_graph.width) / widthRange, inner_graph.y + inner_graph.height + 4 * fontHeight, currentWord, strlen(currentWord));
       }
    }
   }
}

/* redraw all */

void Redraw()
{
   RedrawButtons();
   RedrawGraph();
}



/* the event handling procedure. */

XEvent event;

void InsertFramesGraphic()
{
   int sx, sy;
   int barHeight = 100;
   int barTop = inner_graph.y + inner_graph.height/2 - barHeight/2;
   int barX = event.xbutton.x;

   int insertAt = lowerRange + (barX - inner_graph.x) * widthRange / inner_graph.width; 
   int extent;

   sx = barX;

   do {
      XSetForeground(display,gc,foreground_pixel); 
      XDrawRectangle(display, graph_window, gc, 2*barX-sx, barTop, 2*(sx-barX), barHeight);
      XDrawLine(display, graph_window, gc, barX, barTop-barHeight/2, barX, barTop+3*barHeight/2);

      do {
         XNextEvent(display, &event);
         switch(event.type) {
         case ButtonRelease :
         case MotionNotify :
            break;
         default :
            printf("\nGot event %d", event.type);
            break;
         }
      } while (event.type != ButtonRelease && abs(event.xbutton.x - sx) < 1);

      XSetForeground(display,gc,background_pixel); 
      XDrawRectangle(display, graph_window, gc, 2*barX-sx, barTop, 2*(sx-barX), barHeight);

      sx = max(event.xbutton.x, barX);
      sx = min(sx, 2*barX - inner_graph.x);
      sx = min(sx, inner_graph.x + inner_graph.width-1);
   } while (event.type != ButtonRelease);

   extent = lowerRange + (sx - inner_graph.x) * widthRange / inner_graph.width - insertAt;

   InsertFrames(insertAt, extent);

   upperRange = min (upperRange + 2*extent, nframes);
   widthRange = upperRange - lowerRange;

   RedrawGraph();
}

/* draw rect from csr pt and delete frames thus marked */

void DeleteFramesGraphic()
{
   int sx, sy;
   int barHeight = 100;
   int barTop = inner_graph.y + inner_graph.height/2 - barHeight/2;
   int barX = event.xbutton.x;

   int lowest = lowerRange + (barX - inner_graph.x) * widthRange / inner_graph.width; 
   int highest;

   sx = barX;

   do {
      XSetForeground(display,gc,foreground_pixel); 
      XDrawRectangle(display, graph_window, gc, barX, barTop, sx-barX, barHeight);

      do {
         XNextEvent(display, &event);
         switch(event.type) {
         case ButtonRelease :
         case MotionNotify :
            break;
         default :
            printf("\nGot event %d", event.type);
            break;
         }
      } while (event.type != ButtonRelease && abs(event.xbutton.x - sx) < 1);

      XSetForeground(display,gc,background_pixel); 
      XDrawRectangle(display, graph_window, gc, barX, barTop, sx-barX, barHeight);

      sx = max(event.xbutton.x, barX);
      sx = min(sx, inner_graph.x + inner_graph.width-1);
   } while (event.type != ButtonRelease);
   
   highest = lowerRange + (sx - inner_graph.x) * widthRange / inner_graph.width;

   DeleteFrames(lowest, highest);

   upperRange = min(upperRange, nframes); 	/* !! */
   widthRange = upperRange - lowerRange;	/* !! */

   RedrawGraph();
}


void EditPoints()
{
   int redrawCount = 0;
   int bx,by; long newval, lastval, deltaval;        /* NB dv->flo?*/
   int est, newest, lowest, lastest = -1;

   event.type = MotionNotify;        /* to simplify following code */
   do {
      if (event.type == MotionNotify) {
         bx = event.xbutton.x;
         by = event.xbutton.y;
         if (bx < inner_graph.x) { bx = inner_graph.x; }
         if (bx > inner_graph.x + inner_graph.width) 
                         { bx = inner_graph.x + inner_graph.width; }
         if (by < inner_graph.y) { by = inner_graph.y; }
         if (by > inner_graph.y + inner_graph.height) 
                         { by = inner_graph.y + inner_graph.height;}
                                /* clip to inner rectangle */

         newest = lowerRange + ((bx - inner_graph.x) * widthRange) / inner_graph.width;
         frames[newest].params[editingParameter] = param_info[editingParameter].lowerBound + ((inner_graph.y + inner_graph.height - by) * (param_info[editingParameter].upperBound - param_info[editingParameter].lowerBound)) / inner_graph.height;

         if (lastest != -1) {
            lastval = frames[lastest].params[editingParameter];
            newval = frames[newest].params[editingParameter];

            if (abs(newest - lastest) > 1) {
               /* interpolate if not adjacent or same */
               deltaval = (newval - lastval) / (newest - lastest);
               lowest = min(newest,lastest);
               for (est = lowest; est <= max(newest,lastest); ++est) {
                  frames[est].params[editingParameter] 
                   = (est-lowest) * deltaval
                   + frames[lowest].params[editingParameter];
               }
               redrawCount = 2;        /* force redraw */
            }
         }
         lastest = newest; 
         if (redrawCount == 2) {
            redrawCount = 0;
                        RedrawGraph();
         } else {
            ++redrawCount;
         }                        /* redraw graph every two iterations 
                                           nb: interp forces redraw */
      } 
      XNextEvent(display, &event);
   } while (event.type != ButtonRelease);
   RedrawGraph();
}

void HandleEvents() 
{
   KeySym   keysym;
   XComposeStatus compose;
   char     buffer[1];
   int      bufsize = 1;
   int      i;       

   unsigned int button;

   /* event loop */
   while(1) {
      XNextEvent(display, &event);
#if PDEBUG
      printf("Event : %s\n",event_name[event.type]);
#endif
      switch (event.type) {

      case ConfigureNotify:
         break;                /* ignore size changes. */

      case Expose:
         /* get rid of all other expose events */
         while (XCheckTypedEvent(display,Expose,&event));
         RedrawButtons();
         break;                /* ignore all other expose events */

      case ButtonPress:
         if (event.xbutton.window == graph_window) {
            /* want to move points */
            if (editingParameter != -1) {
               if (event.xbutton.button == 1) {
                  EditPoints();
               } else if (event.xbutton.button == 2) {
                  InsertFramesGraphic();
               } else {
                  DeleteFramesGraphic();
               }
            }
         } else {
            /* have pressed a button */
            i = 0;
            while (i < NBUTTONS && event.xbutton.window != buttons[i]) {
               ++i;
            }
  
            if (i < NBUTTONS) {
               if (editingParameter != -1 && i < NPAR) 
                  paint_button(editingParameter, NORMAL);

               paint_button(i, REVERSE);
               button = event.xbutton.button;
 
               /* get the matching button release on the same button */
               while (1) {
                  while (XCheckTypedEvent(display,ButtonPress,&event));
                  /* wait for release; if on correct button, exit */
                  XMaskEvent(display, ButtonReleaseMask, &event);
                  if (event.xbutton.button == button) {
                     break;
                  }
               }
               if (i < NPAR) {
                  editingParameter = i;			/* new param */
                  RedrawGraph();
               } else {
                  /* now see which button pressed and process it. */
                  switch (i) {
                  case QUITPROG : 
                     XUnloadFont(display, font_info->fid);
                     XFreeGC(display, gc);
                     XFreeGC(display, bgc);
                     XCloseDisplay(display);
                     return;
                     break;
                  case SAVEasNEXT : 
                     if (event.xbutton.button == 3) { 
                        save_file(0);
                     } else { 
                        save_file(1);
                     }
                     break;
                  case SMOOTHIT : 
                     smooth_data(editingParameter, event.xbutton.button);
                     smooth_data(editingParameter, event.xbutton.button);
                     smooth_data(editingParameter, event.xbutton.button);
                     RedrawGraph();                 /* so noticable effects */
                     break;
                  case PLAYIT : 
                     play_wave(1, 0);
                     break;

                  case DOUBLESCALE :
                     if (editingParameter != -1) {
                        long mid = (param_info[editingParameter].upperBound + param_info[editingParameter].lowerBound) / 2;
                        param_info[editingParameter].upperBound = 2 * param_info[editingParameter].upperBound - mid;
                        param_info[editingParameter].lowerBound = 2 * param_info[editingParameter].lowerBound - mid;
                        RedrawGraph();
                     }
                     break;
                  case HALVESCALE :
                     if (editingParameter != -1) {
                        long mid = (param_info[editingParameter].upperBound + param_info[editingParameter].lowerBound) / 2;
                        param_info[editingParameter].upperBound = (param_info[editingParameter].upperBound + mid) / 2;
                        param_info[editingParameter].lowerBound = (param_info[editingParameter].lowerBound + mid) / 2;
                        RedrawGraph();
                      }
                      break;
                  case CLIPUPPER :
                     if (editingParameter != -1) {
                        long mid = (param_info[editingParameter].upperBound + param_info[editingParameter].lowerBound) / 2;
                        int f;
                        param_info[editingParameter].lowerBound = mid;
                        for (f = 0; f < nframes; ++f) {
                           if (frames[f].params[editingParameter] < mid) frames[f].params[editingParameter] = mid;
                        }
                        RedrawGraph();
                     }
                     break;
                  case CLIPLOWER :
                     if (editingParameter != -1) {
                        long mid = (param_info[editingParameter].upperBound + param_info[editingParameter].lowerBound) / 2;
                        int f;
                        param_info[editingParameter].upperBound = mid;
                        for (f = 0; f < nframes; ++f) {
                           if (frames[f].params[editingParameter] > mid) frames[f].params[editingParameter] = mid;
                        }
                        RedrawGraph();
                     }
                     break;
                  case EXPANDRANGE :
                     if (editingParameter != -1 && widthRange > 10) {
                        int mid = (lowerRange + upperRange) / 2;
                        lowerRange += (mid-lowerRange) / 2;
                        upperRange -= (upperRange-mid) / 2;
                        widthRange = upperRange - lowerRange;
                        RedrawGraph();
                     }
                     break;
                  case COLLAPSERANGE :
                     if (editingParameter != -1) {
                        int mid = (lowerRange + upperRange) / 2;
                        lowerRange -= (mid-lowerRange);
                        upperRange += (upperRange-mid);
                        widthRange = upperRange - lowerRange;
                        if (widthRange > nframes) {                /* too big */
                           lowerRange = 0;
                           upperRange = widthRange = nframes;
                        } else if (lowerRange < 0) {        /* L escape */
                           lowerRange = 0;
                           upperRange = widthRange;
                        } else if (upperRange > nframes) {        /* R escape */
                              upperRange = nframes;
                        lowerRange = upperRange - lowerRange;
                        }
                        RedrawGraph();
                     }
                     break;
                  case LEFTRANGE :
                     if (editingParameter != -1) {
                        int shift = 2 * widthRange / 3;
                        if ((lowerRange -= shift) >= 0) {
                           upperRange -= shift;
                        } else {
                           lowerRange = 0;
                           upperRange = widthRange;
                        }
                        RedrawGraph();
                     }
                     break;
                  case RIGHTRANGE :
                     if (editingParameter != -1) {
                        int shift = 2 * widthRange / 3;
                        if ((upperRange += shift) <= nframes) {
                           lowerRange += shift;
                        } else {
                           upperRange = nframes;
                           lowerRange = upperRange - widthRange;
                        }
                        RedrawGraph();
                     }
                     break;

                  default :
                     printf("ERROR : unrecognised button! = %d", i);
                  }
#if PDEBUG
                  printf("\nFrame l_%d, u_%d, w_%d", lowerRange, upperRange, widthRange);
#endif
                  paint_button(i, NORMAL);
               }
            }
         }
         break;                /* for button press */

      case KeyPress:
         XLookupString(&event.xkey,buffer,bufsize,&keysym,&compose);
         if ((keysym == XK_q) || (keysym == XK_Q)) {
            XUnloadFont(display, font_info->fid);
            XFreeGC(display, gc);
            XFreeGC(display, bgc);
            XCloseDisplay(display);
            return;                        /* only respond to quit */
         } else if (keysym == XK_4) {
            play_wave(0, 4);
         } else if (keysym == XK_5) {
            play_wave(0, 5);
         } else if (keysym == XK_6) {
            play_wave(0, 6);
         } else if (keysym == XK_p || keysym == XK_P) {
            play_wave(1, 0);
         } else {
            printf("I am ignoring keys such as %c\n", (char)keysym);
         }
         break;

      default:
         break;
      } /* end switch */
   } /* end while */
}



/* main */

void main (argc, argv)
int argc;
char **argv;
{
   FILE *infp;
   char *infile = (char *)malloc(256);

   strcpy(infile, "");

   argc = getargs(argc,argv,
                  "d", "",   &display_name,
                  "r", NULL, &reverse,
                  "f", "",   &font_name,
                  "i", "",   &infile,
                  NULL);

   if (strcmp(infile, "") == 0)
    {
     printf("Enter name of input parameter file: ");
     scanf("%s", infile);
    }
  
   InitWindow(argc, argv);
   load_file(infile);
   lowerRange = 0;
   upperRange = widthRange = nframes;	/* set initial range */
   HandleEvents();
}
