#include "proto.h"
#include "phonemes.h"
#include "features.h"
#include "gen.h"

void
gen_vowel(phone,segdur,prev_feat,next_feat,next_phone)
int phone;
int segdur;
unsigned long prev_feat;
unsigned long next_feat;
int next_phone;
{unsigned long features  = Features[phone];
 int j, interp = 0;
 float prcnt, f0_temp, f1_temp, f2_temp, f3_temp, bw1_temp, bw2_temp, bw3_temp;
 float av_temp;
 float n_av = 0.0, n_f1 = 0.0, n_f2 = 0.0, n_f3 = 0.0, n_bw1 = 0.0, n_bw2 = 0.0,
       n_bw3 = 0.0;
 int time_const, time_count;


 if (prev_feat != 0)
  if ((prev_feat & VOWEL) || (prev_feat & SONOR))
   {
    if (prev_feat & FRICA)
     prcnt = .30;
    else
     prcnt = .95;

    f1[0] -= (f1[0] - LastTarget.f1) * prcnt;
    f2[0] -= (f2[0] - LastTarget.f2) * prcnt;
    f3[0] -= (f3[0] - LastTarget.f3) * prcnt;
    bw1[0] -= (bw1[0] - LastTarget.bw1) * prcnt;
    bw2[0] -= (bw2[0] - LastTarget.bw2) * prcnt;
    bw3[0] -= (bw3[0] - LastTarget.bw3) * prcnt;
   }
 if (next_feat != -1)
  if (next_feat & NASAL)
   {int off;
    translate_phone(next_phone, &off);
    n_av = (float) Nasals[off][8];
    n_f1 = (float) Nasals[off][0];
    n_f2 = (float) Nasals[off][1];
    n_f3 = (float) Nasals[off][2];
    n_bw1 = (float) Nasals[off][3];
    n_bw2 = (float) Nasals[off][4];
    n_bw3 = (float) Nasals[off][5];
   }

 f0_temp = f0[0];
 f1_temp = f1[0];
 f2_temp = f2[0];
 f3_temp = f3[0];
 bw1_temp = bw1[0];
 bw2_temp = bw2[0];
 bw3_temp = bw3[0];
 av_temp = av[0];

 time_const = segdur;
 time_count = 0;
 for (j = 0; j < segdur; j += 10)
  {
   Frames[total_frame_count].f0 = (int) f0_temp;
   Frames[total_frame_count].f1 = (int) f1_temp;
   Frames[total_frame_count].f2 = (int) f2_temp;
   Frames[total_frame_count].f3 = (int) f3_temp;
   Frames[total_frame_count].bw1 = (int) bw1_temp;
   Frames[total_frame_count].bw2 = (int) bw2_temp;
   Frames[total_frame_count].bw3 = (int) bw3_temp;
   Frames[total_frame_count].fnz = (int) fnz;
   Frames[total_frame_count].fnp = (int) fnp;
   Frames[total_frame_count].av = (int) av_temp;
   Frames[total_frame_count].tlt = 0;
   Frames[total_frame_count].asp = (int) asp;
   Frames[total_frame_count].af = (int) af;
   Frames[total_frame_count].a1 = (int) a1;
   Frames[total_frame_count].a2 = (int) a2;
   Frames[total_frame_count].a3 = (int) a3;
   Frames[total_frame_count].a4 = (int) a4;
   Frames[total_frame_count].a5 = (int) a5;
   Frames[total_frame_count].a6 = (int) a6;
   Frames[total_frame_count].ab = (int) ab;

   if (j < (segdur / 3))
    f0[0] += 40;
   else
    {
     if (f0_change != -1000)
      f0[0] -= 25;
     else
      f0[0] -= 10;
    }

   f0_temp = f0[0];

   if (next_feat != -1)
    if ((next_feat & NASAL) && (j >= segdur - 35 && j < segdur - 25))
     {
      f1[0] = f1_temp;
      f2[0] = f2_temp;
      f3[0] = f3_temp;
      bw1[0] = bw1_temp;
      bw2[0] = bw2_temp;
      bw3[0] = bw3_temp;
      av[0] = av_temp;

      f1[1] = n_f1;
      f2[1] = n_f2;
      f3[1] = n_f3;
      bw1[1] = n_bw1;
      bw2[1] = n_bw2;
      bw3[1] = n_bw3;
      av[1] = n_av;

      time_const = 10;
      time_count = 0;
      interp = 1;
     }

   if ((features & DIPTH) || interp)
    {
     /* f0_temp = gen_curve(f0[0],f0[1],time_const/4,time_count); */
     f1_temp = gen_curve(f1[0], f1[1], time_const / 4, time_count);
     f2_temp = gen_curve(f2[0], f2[1], time_const / 4, time_count);
     f3_temp = gen_curve(f3[0], f3[1], time_const / 4, time_count);
     bw1_temp = gen_curve(bw1[0], bw1[1], time_const / 4, time_count);
     bw2_temp = gen_curve(bw2[0], bw2[1], time_const / 4, time_count);
     bw3_temp = gen_curve(bw3[0], bw3[1], time_const / 4, time_count);
     av_temp = gen_curve(av[0], av[1], time_const / 4, time_count);
    }
   time_count += 10;
   total_frame_count++;
  }
 /* retain block copy till we make LastTarget a pointer */
 LastTarget = Frames[total_frame_count - 1];
}
