typedef enum {
LEXICAL_TYPE,
VOWEL_TYPE,
SONORANT_TYPE,
NASAL_TYPE,
FRICATIVE_TYPE,
PLOSIVE_TYPE,
AFFRICATE_TYPE,
PSUEDO_VOWEL_TYPE } Phoneme_class;

typedef enum  {
lEOF,
lSYLLABLE,
lWORD_BREAK,
lEND_LIST,
#define VOWELS_START pAA
pAA,
pAE,
pAH,
pAO,
pAW,
pAX,
pAXR,
pAY,
pEH,
pER,
pEXR,
pEY,
pIH,
pIX,
pIXR,
pIY,
pOW,
pOXR,
pOY,
pUH,
pUW,
pUXR,
pYU,
#define VOWELS_END pYU

#define SONORANTS_START pEL
pEL,
pHH,
pHX,
pLL,
pLX,
pRR,
pRX,
pWW,
pWH,
pYY,
#define SONORANTS_END pYY

#define NASALS_START pEM
pEM,
pEN,
pMM,
pNN,
pNG,
#define NASALS_END pNG

#define FRICATIVES_START pDH
pDH,
pFF,
pSS,
pSH,
pTH,
pVV,
pZZ,
pZH,
#define FRICATIVES_END pZH

#define PLOSIVES_START pBB
pBB,
pDD,
pDX,
pGG,
pGP,
pKK,
pKP,
pPP,
pTT,
pTQ,
#define PLOSIVES_END pTQ

#define AFFRICATES_START pCH
pCH,
pJJ,
#define AFFRICATES_END pJJ

#define PSUEDO_VOWELS_START pAXP
pAXP,
#define PSUEDO_VOWELS_END pAXP
} Phoneme_t;

#define ALL_END PSUEDO_VOWELS_END
#define NUM_VOWELS        (VOWELS_END-VOWELS_START+1)
#define NUM_SONORANTS     (SONORANTS_END-SONORANTS_START+1)
#define NUM_NASALS        (NASALS_END-NASALS_START+1)
#define NUM_FRICATIVES    (FRICATIVES_END-FRICATIVES_START+1)
#define NUM_PLOSIVES      (PLOSIVES_END-PLOSIVES_START+1)
#define NUM_AFFRICATES    (AFFRICATES_END-AFFRICATES_START+1)
#define NUM_PSEUDO_VOWELS (PSUEDO_VOWELS_END-PSUEDO_VOWELS_START+1)


#define VOWEL 1
#define SONOR 2
#define NASAL 4
#define FRICA 8
#define PLOSI 16
#define AFFRI 32
#define PSUED 64
#define ALVEO 128
#define ASPSE 256
#define DENTA 512
#define DIPTH 1024
#define F2BAC 2048
#define FRONT 4096
#define GLOTT 8192
#define HIGH  16384
#define LABIA 32768
#define LATER 65536
#define LAX   131072
#define LIQGL 262144
#define LOW   524288
#define PALAT 1048576
#define PALVE 2097152
#define RETRO 4194304
#define RGLID 8388608
#define ROUND 16777216
#define SCHWA 33554432
#define STOP  67108864
#define SYLLA (0x10000000)
#define VELAR (0x20000000)
#define VOICE (0x40000000)
#define WGLID (0x80000000)
/*no yglide */


#define VOWEL_AV 48.0
