/********************************/  
/*                              */ 
/*         PARGRAF.C            */ 
/*                              */ 
/*  HALO routines to display    */ 
/*  parameters from KLATT.C     */ 
/*                              */ 
/********************************/ 

#define MAX_FRAMES 200
#define NPAR 40
#define GREEN 2
#define LT_BLUE 3
#define AMBER 6
#define GREY 7
#define BRT_YELLOW 10
#define LT_CYAN 11
#define BRT_WHITE 15
#define GREY 7
#define BLACK 0
#define HZ_DIVISIONS 5
#define FRAME_DIVISIONS 20
extern int par_array[NPAR][MAX_FRAMES];

extern int nframes, nmsec_per_frame;

int colors[5] =
{GREY, LT_BLUE, AMBER, BRT_YELLOW, BRT_WHITE};

int offset;

char *device = "haloibme.dev";

char *textstring, *labelstring;

int frame_inc = 10, pitch_inc = 10;

int min, max, range;


int minima[NPAR] =
{0, 0, 
 0, 30, 
 0, 40, 
 0, 60, 
 0, -1, 
 0, -1, 
 -1, -1, 
 180, -1, 
 180, -1, 
 0, -1, 
 -1, 0, 
 0, -1, 
 0, -1, 
 0, -1, 
 0, -1, 
 0, -1, 
 0, -1, 
 0, -1, 
 -1, 0, 
 -1, -1};


int maxima[NPAR] =
{5000, 80, 
 1300, 1000, 
 3000, 1000, 
 4999, 1000, 
 4999, -1, 
 4999, -1, 
 -1, -1, 
 800, -1, 
 500, -1, 
 80, -1, 
 -1, 24, 
 80, -1, 
 80, -1, 
 80, -1, 
 80, -1, 
 80, -1, 
 80, -1, 
 80, -1, 
 -1, 80, 
 -1, -1};



dsp(ppar_name, par_num) 
char *ppar_name;

int par_num;

{
 
  int i, color;
 
  char *pname;
 
  int x, y;
 
  int box_x1 = 80;
 
  int box_x2 = 530;
 
  int box_y1 = 80;
 
  int box_y2 = 280;
 
  
  if (par_num == 2 || par_num == 4 || par_num == 6)
  {
   
    min = minima[2];
   
    max = maxima[10];
   
  }
 
  else
  {
   
    min = minima[par_num];
   
    max = maxima[par_num];
   
  }
 
  range = max - min;
 
  init_screen(ppar_name, par_num);
 
  if (par_num == 2 || par_num == 4 || par_num == 6)
  plot_formants();
 
  else
  {
   
    color = BRT_WHITE;
   
    pname = ppar_name;
   
    plot_one(par_num, color, pname);
   
  }
 
  x = box_x1;
 
  y = box_y2 + 60;
 
  movtcurabs(&x, &y);
 
  strcpy(textstring, "Hit any key");
 
  btext(textstring);
 
  getch();
 
  closegraphics();
 
}



init_screen(ppar_name, par_num) 
char *ppar_name;

int par_num;

{
 
  int mode = 4, color, background;
 
  int x, y, x1, y1, dx, dy;
 
  int rightmax = 580, topmax = 15;
 
  int box_x1 = 80;
 
  int box_x2 = 530;
 
  int box_y1 = 80;
 
  int box_y2 = 280;
 
  int pix_per_frame, pix_per_hz;
 
  int i;
 
  int height, width, path;
 
  
  setdev(device);
 
  initgraphics(&mode);
 
  color = GREEN;
 
  setcolor(&color);
 
  movabs(&box_x1, &box_y2);
 
  pix_per_frame = 10 * (box_x2 - box_x1) / (nframes - 1);
 
  pix_per_hz = 10 * (box_y2 - box_y1) / range;
 
  box(&box_x1, &box_y1, &box_x2, &box_y2);
 
  height = 0;
 width = 0;
 
  color = BRT_WHITE;
 
  background = BLACK;
 
  height = 1;
 width = 1;
 path = 0;
 mode = 0;
 
  init_frames();
 
  init_hz(par_num);
 
}



init_frames() 
{
 
  int mode = 4, color, background;
 
  int x, y, x1, y1, dx, dy;
 
  int rightmax = 580, topmax = 15;
 
  int box_x1 = 80;
 
  int box_x2 = 530;
 
  int box_y1 = 80;
 
  int box_y2 = 280;
 
  int i;
 
  int height, width, path;
 
  int pix_per_frame = 10 * (box_x2 - box_x1) / (nframes - 1);
 
  int pix_per_hz = 10 * (box_y2 - box_y1) / range;
 
  int frame_inc = nframes / FRAME_DIVISIONS;
 
  
  if (frame_inc < 1)
  frame_inc = 1;
 
  x = box_x2 / 2;
 y = box_y2 + 45;
 
  movtcurabs(&x, &y);
 
  strcpy(labelstring, "MSEC");
 
  color = BRT_WHITE;
 
  settextclr(&color);
 
  height = 1;
 width = 1;
 path = 0;
 mode = 0;
 
  settext(&height, &width, &path, &mode);
 
  btext(labelstring);
 
  height = 0;
 width = 0;
 color = BLACK;
 
  inittcur(&height, &width, &color);
 
  
  color = GREEN;
 
  settextclr(&color);
 
  height = 1;
 width = 1;
 path = 3;
 mode = 0;
 
  settext(&height, &width, &path, &mode);
 
  for (i = 0; i <= (nframes - 1); i += frame_inc)
  {
   
    x = (10 * box_x1 + i * pix_per_frame) / 10;
   y = box_y2 + 8;
   
    movabs(&x, &y);
   
    dx = 0;
   dy = -8;
   
    lnrel(&dx, &dy);
   
    x = (10 * box_x1 + i * pix_per_frame - 40) / 10;
   y = box_y2 + 18;
   
    movtcurabs(&x, &y);
   
    sprintf(textstring, "%d", i * nmsec_per_frame);
   
    btext(textstring);
   
  }
 
}



init_hz(par_num) 
int par_num;

{
 
  int mode = 4, color, background;
 
  int x, y, x1, y1, dx, dy;
 
  int rightmax = 580, topmax = 15;
 
  int box_x1 = 80;
 
  int box_x2 = 530;
 
  int box_y1 = 80;
 
  int box_y2 = 280;
 
  int i;
 
  int height, width, path;
 
  int pix_per_frame = 10 * (box_x2 - box_x1) / (nframes - 1);
 
  int pix_per_hz = 10 * (box_y2 - box_y1) / range;
 
  int scale, label;
 
  
  color = GREEN;
 
  settextclr(&color);
 
  height = 1;
 width = 1;
 path = 0;
 mode = 0;
 
  settext(&height, &width, &path, &mode);
 
  color = GREEN;
 
  settextclr(&color);
 
  x = box_x1;
 y = box_y2;
 
  movabs(&x, &y);
 
  dx = -8;
 dy = 0;
 
  lnrel(&dx, &dy);
 
  x = box_x1 - 40;
 
  y += 4;
 
  movtcurabs(&x, &y);
 
  sprintf(textstring, "%d", min);
 
  btext(textstring);
 
  x = box_x1;
 y = box_y1;
 
  movabs(&x, &y);
 
  dx = -8;
 dy = 0;
 
  lnrel(&dx, &dy);
 
  x = box_x1 - 40;
 
  y += 4;
 
  movtcurabs(&x, &y);
 
  sprintf(textstring, "%d", max);
 
  btext(textstring);
 
  scale = (max - min + 1) / HZ_DIVISIONS;
 
  for (i = 1; i < HZ_DIVISIONS; ++i)
  {
   
    x = box_x1;
   
    y = box_y2 - i * (box_y2 - box_y1) / HZ_DIVISIONS;
   
    movabs(&x, &y);
   
    dx = -8;
   dy = 0;
   
    lnrel(&dx, &dy);
   
    x = box_x1 - 40;
   
    y += 4;
   
    label = i * scale;
   
    sprintf(labelstring, "%d", label);
   
    movtcurabs(&x, &y);
   
    btext(labelstring);
   
  }
 
  x = box_x1 / 4;
 y = box_y1 + (box_y2 - box_y1) / 2;
 
  movtcurabs(&x, &y);
 
  get_labelstring(par_num);
 
  color = BRT_WHITE;
 
  settextclr(&color);
 
  height = 1;
 width = 1;
 path = 1;
 mode = 0;
 
  settext(&height, &width, &path, &mode);
 
  btext(labelstring);
 
}



plot_one(par_num, color, pname) 
int par_num, color;

char *pname;

{
 
  int x, y, x1, y1, dx, dy;
 
  int box_x1 = 80;
 
  int box_x2 = 530;
 
  int box_y1 = 80;
 
  int box_y2 = 280;
 
  int pix_per_frame = 10 * (box_x2 - box_x1) / (nframes - 1);
 
  int i;
 
  int percent_total;
 
  
  setcolor(&color);
 
  for (i = 0; i < (nframes - 1); ++i)
  {
   
    percent_total = 100 * ((float) par_array[par_num][i] / (float) max);
   
    x = (10 * box_x1 + i * pix_per_frame) / 10;
   
    y = box_y2 - percent_total * 2;
   
    percent_total = 100 * ((float) par_array[par_num][i + 1] / (float) max);
   
    x1 = (10 * box_x1 + (i + 1) * pix_per_frame) / 10;
   
    y1 = box_y2 - percent_total * 2;
   
    movabs(&x, &y);
   
    lnabs(&x1, &y1);
   
  }
 
  show_key(pname, color);
 
}



show_key(pname, color) 
char *pname;

int color;

{
 
  
  int x, y, x1, y1, dx, dy;
 
  int box_x1 = 80;
 
  int box_x2 = 530;
 
  int box_y1 = 80;
 
  int box_y2 = 280;
 
  int i;
 
  int height = 1;
 int width = 1;
 int path = 0;
 int mode = 0;
 
  
  settext(&height, &width, &path, &mode);
 
  x = box_x2 + 10;
 y = box_y1 + 20;
 
  y += offset;
 
  movtcurabs(&x, &y);
 
  settextclr(&color);
 
  movtcurabs(&x, &y);
 
  btext(pname);
 
}


get_labelstring(par_num) 
int par_num;

{
 
  switch (par_num)
  {
    
   case 0:
    
     strcpy(labelstring, "HZ*10");
    
     break;
    
   case 2:
    
   case 3:
    
   case 4:
    
   case 5:
    
   case 6:
    
   case 7:
    
   case 14:
    
   case 16:
    
     strcpy(labelstring, "HZ");
    
     break;
    
   default:
    
     strcpy(labelstring, "DB");
    
     break;
    
  }
 
}


plot_formants() 
{
 
  int i, color;
 
  char *pname, *fnum;
 
  
  offset = 50;
 
  for (i = 2; i <= 10; i += 2)
  {
   
    color = colors[i / 2 - 1];
   
    strcpy(pname, "F");
   
    sprintf(fnum, "%d", i / 2);
   
    strcat(pname, fnum);
   
    plot_one(i, color, pname);
   
    offset -= 10;
   
  }
 
}

