#include "proto.h"
#include "phonemes.h"
#include "features.h"
#include "gen.h"

void
gen_fricative(phone,segdur,prev_feat,next_feat,next_phone)
int phone;
int segdur;
unsigned long prev_feat;
unsigned long next_feat;
int next_phone;
{unsigned long features  = Features[phone];
 int j;
 float f0_temp, f1_temp, f2_temp, f3_temp, bw1_temp, bw2_temp, bw3_temp;
 float av_temp;
 int time_const, time_count, interp = 0, off;

 if (next_feat != 0)
  {
   if ((next_feat & VOWEL) && (features & VOICE))
    {
     translate_phone(next_phone, &off);
     av[1] = (float) VOWEL_AV;
     f1[1] = (float) Vowels[off][0][F1];
     f2[1] = (float) Vowels[off][0][F2];
     f3[1] = (float) Vowels[off][0][F3];
     bw1[1] = (float) Vowels[off][0][BW1];
     bw2[1] = (float) Vowels[off][0][BW2];
     bw3[1] = (float) Vowels[off][0][BW3];
     interp = 1;
    }
  }

 f0_temp = f0[0];
 f1_temp = f1[0];
 f2_temp = f2[0];
 f3_temp = f3[0];
 bw1_temp = bw1[0];
 bw2_temp = bw2[0];
 bw3_temp = bw3[0];
 av_temp = av[0];

 if ((prev_feat & VOWEL) && (features & VOICE) && (next_feat & VOWEL))
  av[0] = 60;

 time_const = segdur - 70;
 time_count = 0;

 for (j = 0; j < segdur; j += 10)
  {
   Frames[total_frame_count].f0 = (int) f0_temp;
   Frames[total_frame_count].f1 = (int) f1_temp;
   Frames[total_frame_count].f2 = (int) f2_temp;
   Frames[total_frame_count].f3 = (int) f3_temp;
   Frames[total_frame_count].bw1 = (int) bw1_temp;
   Frames[total_frame_count].bw2 = (int) bw2_temp;
   Frames[total_frame_count].bw3 = (int) bw3_temp;
   Frames[total_frame_count].fnz = (int) fnz;
   Frames[total_frame_count].fnp = (int) fnp;
   Frames[total_frame_count].av = (int) av_temp;
   Frames[total_frame_count].tlt = 0;
   Frames[total_frame_count].asp = (int) asp;
   Frames[total_frame_count].af = (int) af;
   Frames[total_frame_count].a1 = (int) a1;
   Frames[total_frame_count].a2 = (int) a2;
   Frames[total_frame_count].a3 = (int) a3;
   Frames[total_frame_count].a4 = (int) a4;
   Frames[total_frame_count].a5 = (int) a5;
   Frames[total_frame_count].a6 = (int) a6;
   Frames[total_frame_count].ab = (int) ab;
   if (interp && j > 70)
    {
     f0_temp = gen_curve(f0_temp, f0[1], time_const / 4, time_count);
     f1_temp = gen_curve(f1_temp, f1[1], time_const / 4, time_count);
     f2_temp = gen_curve(f2_temp, f2[1], time_const / 4, time_count);
     f3_temp = gen_curve(f3_temp, f3[1], time_const / 4, time_count);
     bw1_temp = gen_curve(bw1_temp, bw1[1], time_const / 4, time_count);
     bw2_temp = gen_curve(bw2_temp, bw2[1], time_const / 4, time_count);
     bw3_temp = gen_curve(bw3_temp, bw3[1], time_const / 4, time_count);
     av_temp = gen_curve(av_temp, av[1], time_const / 4, time_count);
    }
   total_frame_count++;
   time_count += 10;
  }
 /* retain block copy till we make LastTarget a pointer */
 LastTarget = Frames[total_frame_count - 1];
}
