#include "proto.h"
#include "phonemes.h"
#include "features.h"

int InhDur[ALL_END + 1] =
{0, 0, 0, 0,              /* Lex tokens */
 240, 230, 140, 240, 260, /* AA - AW */
 120, 260, 250, 150, 180, /* AX - ER */
 270, 190, 135, 110, 230, /* EXR - IXR */
 155, 220, 240, 280, 160, /* IY - UH */
 210, 230, 230, 260, 80,  /* UW - HH */
 70, 100, 90, 80, 80,     /* HX - RX */
 100, 70, 80, 170, 170,   /* WW - EN */
 100, 110, 95, 80, 100,   /* MM - FF */
 105, 105, 90, 70, 100,   /* SS - ZZ */
 90, 50, 40, 40, 40,      /* ZH - GP */
 70, 70, 70, 45, 40,      /* KK - TT */
 75, 70, 70, 70,          /* TQ - AXP */
};

int MinDur[ALL_END + 1] =
{0, 0, 0, 0,                     /* Lex tokens */
 100, 80, 60, 100, 100,          /* AA - AW */
 60, 120, 150, 70, 80,           /* AX - ER */
 130, 100, 40, 60, 80,           /* EXR - IXR */
 55, 80, 130, 150, 60,           /* IY - UH */
 70, 110, 150, 110, 20,          /* UW - HH */
 25, 40, 70, 30, 70,             /* HX - RX */
 60, 60, 40, 110, 100,           /* WW - EN */
 60, 50, 60, 50, 80,             /* MM - FF */
 60, 80, 60, 40, 60,             /* SS - ZZ */
 60, 60, 50, 20, 60,             /* ZH - GP */
 40, 40, 40, 50, 40,             /* KK - TT */
 50, 50, 50, 70,                 /* TQ - AXP */
};


/*

  Is the memory saving of special arrays really worth the complexity
  and confusion ?
  Perhaps we should simply have arrays of new genpar_t through out
  this file.

  Maybe even one array index by phoneme number, with 2nd
  (smaller) array to hold "END" value for the vowels.

*/

/*f1 f2 f3 bw1 bw2 bw3 - didn't need to include a2-a6 because always 60*/
/* Two sets of parameters - hence 2nd index
   1st [0] START
   2nd [1] END
   This allows encoding of dipthongs
*/
int Vowels[NUM_VOWELS][2][6] =
{
 {
  {700, 1220, 2600, 130, 70, 160},
  {700, 1220, 2600, 130, 70, 160}},  /* AA */
 {
  {620, 1660, 2430, 70, 130, 300},
  {650, 1490, 2470, 70, 100, 320}},  /* AE */
 {
  {620, 1220, 2550, 80, 50, 140},
  {620, 1220, 2550, 80, 50, 140}},   /* AH */
 {
  {600,  990, 2570, 90, 100, 80},
  {630, 1040, 2600, 90, 100, 80}},   /* AO */
 {
  {640, 1230, 2550, 80, 70, 140},
  {420,  940, 2350, 80, 70, 80}},    /* AW */
 {
  {550, 1260, 2470, 80, 50, 140},
  {550, 1260, 2470, 80, 50, 140}},   /* AX */
 {
  {680, 1170, 2380, 60, 60, 110},
  {520, 1400, 1650, 60, 60, 110}},   /* AXR */
 {
  {660, 1200, 2550, 100,  70, 200},
  {400, 1880, 2500,  70, 100, 200}},  /* AY */
 {
  {530, 1680, 2500, 60, 90, 200},
  {620, 1530, 2530, 60, 90, 200}},   /* EH */
 {
  {470, 1270, 1540, 100, 60, 110},
  {420, 1310, 1540, 100, 60, 110}},  /* ER */
 {
  {460, 1650, 2400, 60, 80, 140},
  {450, 1500, 1700, 60, 80, 140}},   /* EXR */
 {
  {480, 1720, 2520, 70, 100, 200},
  {330, 2200, 2600, 55, 100, 200}},  /* EY */
 {
  {400, 1800, 2670, 50, 100, 140},
  {470, 1600, 2600, 50, 100, 140}},  /* IH */
 {
  {420, 1680, 2520, 50, 100, 140},
  {420, 1680, 2520, 50, 100, 140}},  /* IX */
 {
  {320, 1900, 2900, 70, 80, 120},
  {420, 1550, 1750, 70, 80, 120}},   /* IXR */
 {
  {310, 2200, 2960, 50, 200, 400},
  {290, 2070, 2980, 60, 200, 400}},  /* IY */
 {
  {540, 1100, 2300, 80, 70, 70},
  {450, 900, 2300, 80, 70, 70}},     /* OW */
 {
  {550, 820, 2200, 60, 60, 60},
  {490, 1300, 1500, 60, 60, 60}},    /* OXR */
 {
  {550, 960, 2400, 80, 50, 130},
  {360, 1820, 2450, 60, 50, 160}},   /* OY */
 {
  {450, 1100, 2350, 80, 100, 80},
  {500, 1180, 2390, 80, 100, 80}},   /* UH */
 {
  {350, 1250, 2200, 65, 110, 140},
  {320, 900, 2200, 65, 110, 140}},   /* UW */
 {
  {360, 800, 2000, 60, 60, 80},
  {390, 1150, 1500, 60, 60, 80}},    /* UXR */
 {
  {290, 1900, 2600, 70, 160, 220},
  {330, 1200, 2100, 70, 160, 220}    /* YU */
 }
};

/*f1 f2 f3 bw1 bw2 bw3 av asp */
int Sonorants[NUM_SONORANTS][8] =
{
/* f1    f2    f3  bw1  bw2  bw3  av asp */
 {450,  800, 2850,  65,  60,  80, 47,  0}, /* EL */
 {450, 1450, 2450, 300, 160, 300,  0, 45}, /* HH */
 {450, 1450, 2450, 200, 120, 200, 55, 53}, /* HX */
 {330, 1050, 2800,  50, 100, 280, 51,  0}, /* LL */
 {450,  800, 2850,  65,  60,  80, 51,  0}, /* LX */
 {330, 1060, 1380,  70, 100, 120, 51,  0}, /* RR */
 {460, 1260, 1560,  60,  60,  70, 53,  0}, /* RX */
 {285,  610, 2150,  50,  80,  60, 53,  0}, /* WW */
 {330,  600, 2100, 150,  60,  60,  0, 51}, /* WH */
 {240, 2070, 3020,  40, 250, 500, 53,  0}, /* YY */
};

/*f1 f2 f3 bw1 bw2 bw3 fnp fnz av*/
int Nasals[NUM_NASALS][9] =
{
/* f1   f2     f3  bw1  bw2  bw3  fnp  fnz  av */
 {200,  900, 2100, 120,  60,  70, 450, 270, 55}, /* EM */
 {200, 1600, 2700, 120,  70, 110, 450, 270, 55}, /* EN */
 {480, 1270, 2130,  40, 200, 200, 450, 270, 55}, /* MM */
 {480, 1340, 2470,  40, 300, 300, 450, 270, 55}, /* NN */
 {480, 1600, 2050, 160, 150, 100, 450, 270, 51}  /* NG */
};

/*f1 f2 f3 b1 b2 b3 av asp af a2 a3 a4 a5 a6 ab */
int Fricatives[NUM_FRICATIVES][15] =
{
/* f1    f2    f3   b1   b2   b3  av asp  af a2  a3  a4  a5  a6  ab */
 {300, 1150, 2700,  60,  95, 185, 47,  0, 50, 0,  0,  0,  0, 30, 54}, /* DH */
 {400, 1130, 2100, 225, 120, 175,  0, 31, 60, 0,  0,  0,  0,  0, 64}, /* FF */
 {400, 1400, 2700, 200,  95, 220,  0, 10, 40, 0,  0,  0, 50, 82,  0}, /* SS */
 {400, 1650, 2400, 200, 110, 280,  0, 31, 45, 0, 60, 75, 70, 70,  0}, /* SH */
 {320, 1290, 2540, 200,  90, 200,  0, 41, 60, 0,  0,  0,  0, 30, 54}, /* TH */
 {300, 1130, 2100,  55,  95, 125, 60,  0, 60, 0,  0,  0,  0,  0, 64}, /* VV */
 {240, 1390, 2530,  70,  60, 180, 60,  0, 50, 0,  0,  0,  0, 52,  0}, /* ZZ */
 {300, 1840, 2750, 200, 100, 300, 60,  0, 50, 0, 57, 48, 48, 46,  0}  /* ZH */
};


/*f1 f2 f3 b1 b2 b3 av asp af a2 a3 a4 a5 a6 ab */
int Plosives[NUM_PLOSIVES][15] =
{
/* f1    f2    f3   b1   b2   b3  av asp af  a2  a3  a4  a5  a6  ab */
 {200,  900, 2100,  65,  90, 125, 70, 0,  0,  0,  0,  0, 50, 72,  0}, /* BB */
 {200, 1600, 2600,  60, 100, 170, 65, 0, 50,  0, 47, 60, 62, 60,  0}, /* DD */
 {200, 1600, 2700, 120, 140, 250, 44, 0,  0, 60, 60, 60, 60, 60,  0}, /* DX */
 {270, 1400, 1900,  70, 145, 190, 60, 0, 50, 60, 45, 40,  0,  0,  0}, /* GG */
 {200, 1950, 2800, 120, 140, 250, 60, 0,  0, 30, 70, 60, 62, 62,  0}, /* GP */
 {350, 1600, 1900, 280, 220, 250,  0, 0,  0, 70, 30, 30, 60, 10,  0}, /* KK */
 {300, 1950, 2800, 150, 140, 250,  0, 0,  0, 30, 70, 60, 62, 62,  0}, /* KP */
 {300,  900, 2100, 300, 190, 185,  0, 0,  0,  0,  0,  0,  0,  0, 72}, /* PP */
 {300, 1400, 2700, 300, 180, 220,  0, 0,  0,  0, 30, 45, 57, 63,  0}, /* TT */
 {200, 1400, 2700, 120, 140, 250,  0, 0,  0,  0,  0,  0, 50, 82,  0}, /* TQ */
};

/* f1 f2 f3 b1 b2 b3 av asp af a2 a3 a4 a5 a6 ab */
int Affricates[NUM_AFFRICATES][15] =
{
/* f1    f2    f3    b1  b2   b3 av asp af a2  a3  a4  a5  a6 ab */
 {300, 1700, 2400, 200, 110, 270, 0, 0,  0, 0, 60, 75, 70, 70, 0},  /* CH */
 {200, 1700, 2400,  50, 110, 270, 0, 0,  0, 0, 60, 75, 70, 70, 0}   /* JJ */
};

/* f1 f2 f3 b1 b2 b3 av asp af a2 a3 a4 a5 a6 ab */
int Psuedo_vowels[NUM_PSEUDO_VOWELS][16] =
{
/* f1    f2    f3    b1 b2   b3  av asp af a2  a3  a4  a5  a6 ab */
 {430, 1500, 2500, 120, 60, 120, 57, 0, 0, 60, 60, 60, 60, 60, 0} /* AXP */
};

const unsigned long Features[ALL_END + 1] =
{
 0,
 0,
 0,
 0,
 /* Vowels */
 VOWEL | VOICE | SYLLA | SONOR | LOW,                                          /* AA */
 VOWEL | VOICE | SYLLA | SONOR | LOW | LAX | FRONT | DIPTH,                    /* AE */
 VOWEL | VOICE | SYLLA | SONOR,                                                /* AH */
 VOWEL | VOICE | SYLLA | SONOR | LOW | ROUND | LAX | DIPTH,                    /* AO */
 VOWEL | VOICE | SYLLA | SONOR | LOW | WGLID | DIPTH,                          /* AW */
 VOWEL | VOICE | SYLLA | SONOR | SCHWA | LAX,                                  /* AX */
 VOWEL | VOICE | SYLLA | SONOR | LOW | RGLID | DIPTH,                          /* AXR */
 VOWEL | VOICE | SYLLA | SONOR | LOW | /*YGLID*/ DIPTH,                        /* AY */
 VOWEL | VOICE | SYLLA | SONOR | FRONT | DIPTH,                                /* EH */
 VOWEL | VOICE | SYLLA | SONOR | RETRO,                                        /* ER */
 VOWEL | VOICE | SYLLA | SONOR | RGLID | FRONT | DIPTH,                        /* EXR */
 VOWEL | VOICE | SYLLA | SONOR | /*YGLID*/ FRONT | DIPTH,                      /* EY */
 VOWEL | VOICE | SYLLA | SONOR | LAX | HIGH | FRONT | DIPTH,                   /* IH */
 VOWEL | VOICE | SYLLA | SONOR | SCHWA | LAX | HIGH | FRONT,                   /* IX */
 VOWEL | VOICE | SYLLA | SONOR | RGLID | HIGH | FRONT | DIPTH,                 /* IXR */
 VOWEL | VOICE | SYLLA | SONOR | /*YGLID*/ HIGH | FRONT | F2BAC | DIPTH,       /* IY */
 VOWEL | VOICE | SYLLA | SONOR | WGLID | ROUND | DIPTH,                        /* OW */
 VOWEL | VOICE | SYLLA | SONOR | ROUND | RGLID | DIPTH,                        /* OXR */
 VOWEL | VOICE | SYLLA | SONOR | /*YGLID*/ ROUND | DIPTH,                      /* OY */
 VOWEL | VOICE | SYLLA | SONOR | LAX | DIPTH,                                  /* UH */
 VOWEL | VOICE | SYLLA | SONOR | WGLID | ROUND | HIGH | DIPTH,                 /* UW */
 VOWEL | VOICE | SYLLA | SONOR | RGLID | HIGH,                                 /* UXR */
 VOWEL | VOICE | SYLLA | SONOR | WGLID | ROUND | HIGH | FRONT | F2BAC | DIPTH, /* YU */
 /* Sonorants */
 VOICE | SYLLA | SONOR | LATER,                                                /* EL */
 SONOR | ASPSE,                                                                /* HH */
 VOICE | SONOR | ASPSE,                                                        /* HX */
 VOICE | SONOR | LIQGL | LATER,                                                /* LL */
 VOICE | SONOR | LIQGL | LATER,                                                /* LX */
 VOICE | SONOR | LIQGL | RETRO,                                                /* RR */
 VOICE | SONOR | LIQGL | RETRO,                                                /* RX */
 VOICE | SONOR | ROUND | LIQGL | HIGH | LABIA,                                 /* WW */
 VOICE | SONOR | ROUND | LIQGL | HIGH | LABIA | ASPSE,                         /* WH */
 VOICE | SONOR | PALAT | LIQGL | HIGH | F2BAC,                                 /* YY */
 /* Nasals */
 VOICE | SYLLA | STOP | SONOR | NASAL | LABIA,                                 /* EM */
 VOICE | SYLLA | STOP | SONOR | NASAL | ALVEO,                                 /* EN */
 VOICE | STOP | SONOR | NASAL | LABIA,                                         /* MM */
 VOICE | STOP | SONOR | NASAL | ALVEO,                                         /* NN */
 VOICE | STOP | SONOR | NASAL,                                                 /* NG */
 /* Fricatives */
 VOICE | STOP | FRICA | ALVEO,                                                 /* DH */
 LABIA | FRICA,                                                                /* FF */
 FRICA | ALVEO,                                                                /* SS */
 PALAT | FRICA,                                                                /* SH */
 FRICA | DENTA,                                                                /* TH */
 VOICE | LABIA | FRICA,                                                        /* VV */
 VOICE | FRICA,                                                                /* ZZ */
 VOICE | FRICA,                                                                /* ZH */
 /* Plosives */
 VOICE | STOP | LABIA | PLOSI,                                                 /* BB */
 VOICE | STOP | PLOSI | ALVEO,                                                 /* DD */
 VOICE | STOP | ALVEO,                                                         /* DX */
 VOICE | STOP | VELAR | PLOSI,                                                 /* GG */
 VOICE | STOP | PLOSI,                                                         /* GP */
 STOP | VELAR | PLOSI,                                                         /* KK */
 STOP | PLOSI | PALVE,                                                         /* KP */
 STOP | PLOSI | LABIA,                                                         /* PP */
 STOP | PLOSI | ALVEO,                                                         /* TT */
 STOP | PLOSI | ALVEO,                                                         /* TQ */
 /* Affricates */
 STOP | PLOSI | PALAT | AFFRI,                                                 /* CH */
 VOICE | STOP | PLOSI | PALAT | AFFRI,                                         /* JJ */
 /* Pseudo vowels */
 LAX,                                                                          /* AXP */
};

const char *Phoneme_name[ALL_END+1] =
{
"*eof", /*  0 */
"/",    /*  1 */
" ",    /*  2 */
".",    /*  3 */
"aa",   /*  4 */
"ae",   /*  5 */
"ah",   /*  6 */
"ao",   /*  7 */
"aw",   /*  8 */
"ax",   /*  9 */
"axr",  /* 10 */
"ay",   /* 11 */
"eh",   /* 12 */
"er",   /* 13 */
"exr",  /* 14 */
"ey",   /* 15 */
"ih",   /* 16 */
"ix",   /* 17 */
"ixr",  /* 18 */
"iy",   /* 19 */
"ow",   /* 20 */
"oxr",  /* 21 */
"oy",   /* 22 */
"uh",   /* 23 */
"uw",   /* 24 */
"uxr",  /* 25 */
"yu",   /* 26 */
"el",   /* 27 */
"hh",   /* 28 */
"hx",   /* 29 */
"ll",   /* 30 */
"lx",   /* 31 */
"rr",   /* 32 */
"rx",   /* 33 */
"ww",   /* 34 */
"wh",   /* 35 */
"yy",   /* 36 */
"em",   /* 37 */
"en",   /* 38 */
"mm",   /* 39 */
"nn",   /* 40 */
"ng",   /* 41 */
"dh",   /* 42 */
"ff",   /* 43 */
"ss",   /* 44 */
"sh",   /* 45 */
"th",   /* 46 */
"vv",   /* 47 */
"zz",   /* 48 */
"zh",   /* 49 */
"bb",   /* 50 */
"dd",   /* 51 */
"dx",   /* 52 */
"gg",   /* 53 */
"gp",   /* 54 */
"kk",   /* 55 */
"kp",   /* 56 */
"pp",   /* 57 */
"tt",   /* 58 */
"tq",   /* 59 */
"ch",   /* 60 */
"jj",   /* 61 */
"axp",  /* 62 */
} ;

