;;; -*- Package: Toolbed; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolbed)

(DEFMETHOD TRACE-RA ((RA TOOLSET::RECOGNITION-AGENT)) 
                             "Sets up a recognition agent for tracing."
   (WITH-SLOTS (ACTIONS ALT-ACTIONS PARSED-TRACING-CONTROLLER UNIQUE-NAME
			 TRACE-FLAG)
		RA
          (LET (TEMP)
               (SETF TEMP ACTIONS)
       
       ;; only compile tracing versions when necessary

               (IF (toolset::slot-empty-p ra 'alt-actions)
                   (IF (toolset::slot-empty-p ra 'parsed-tracing-controller)
		       (PROGN
			 (WARN "RA ~S cannot be traced - it has no
			 		tracing controller.~%" UNIQUE-NAME)
			 (RETURN-FROM TRACE-RA))
		       (SETF ALT-ACTIONS (TOOLSET::COMPILE-CONTROLLER 
					   PARSED-TRACING-CONTROLLER))))
	       (SETF ACTIONS ALT-ACTIONS)
	       (SETF ALT-ACTIONS TEMP)
	       (SETF TRACE-FLAG T))))


(DEFMETHOD UNTRACE-RA ((RA TOOLSET::RECOGNITION-AGENT)) 
                                        "Untrace the recognition-agent"
   (WITH-SLOTS (ACTIONS ALT-ACTIONS TRACE-FLAG)
		RA
          (LET (TEMP)
               (SETF TEMP ACTIONS)
               (SETF ACTIONS ALT-ACTIONS)
               (SETF ALT-ACTIONS TEMP)
               (SETF TRACE-FLAG NIL))))
