;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFUN STUFF-RA-SLOTS (RA-INSTANCE BODY MANDATORIES FORBIDDEN)
   (DOLIST
    (SPECIFIER BODY)
    (FORMAT *TRACE-OUTPUT* "   ~S~%" (CAR SPECIFIER))
    (CASE (CAR SPECIFIER)
          (DISPLAY-NAME= (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-NAME)
                               (CADR SPECIFIER)))
          (TOP-NODE= (IF (MEMBER 'TOP-NODE FORBIDDEN)
                         (ERROR 
             "ERROR: TOP-NODE is not a permitted specification for ~S."
                                (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'TOP-NODE)
                       (CADR SPECIFIER))
                 (SETF MANDATORIES (REMOVE 'TOP-NODE MANDATORIES)))
          (FEATURES= (IF (MEMBER 'FEATURES FORBIDDEN)
                         (ERROR 
             "ERROR: FEATURES is not a permitted specification for ~S."
                                (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-FEATURES)
                       (MAKE-ARRAY (LIST (LENGTH (CDR SPECIFIER)))
                              :INITIAL-CONTENTS
                              (CDR SPECIFIER)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'NUMBER-OF-FEATURES)
                       (LENGTH (CDR SPECIFIER)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'FEATURE-CACHE)
                       (MAKE-ARRAY (LIST (LENGTH (CDR SPECIFIER)))
                              :INITIAL-ELEMENT
                              'UNFETCHED))
                 (SETF MANDATORIES (REMOVE 'FEATURES MANDATORIES)))
          (PATTERNS= (IF (MEMBER 'PATTERNS FORBIDDEN)
                         (ERROR 
             "ERROR: PATTERNS is not a permitted specification for ~S."
                                (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'PATTERNS)
                       (MAPCAR #'CAR (CDR SPECIFIER)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'SUCCESS-THRESHOLDS)
                       (EXTRACT-THRESHOLDS (CDR SPECIFIER)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-CONFIDENCES)
                       (EXTRACT-CONFIDENCES (CDR SPECIFIER)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-MATCH-ACTIONS)
                       (EXTRACT-MATCH-ACTIONS (CDR SPECIFIER)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'NUMBER-OF-PATTERNS)
                       (LENGTH (CDR SPECIFIER)))
                 (SETF MANDATORIES (REMOVE 'PATTERNS MANDATORIES)))
          (PATTERN= (IF (MEMBER 'PATTERN FORBIDDEN)
                        (ERROR 
              "ERROR: PATTERN is not a permitted specification for ~S."
                               (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-TESTS)
                       (MAKE-ARRAY (LIST (LENGTH (CDR SPECIFIER)))
                              :INITIAL-CONTENTS
                              (CDR SPECIFIER)))
                 (SETF MANDATORIES (REMOVE 'PATTERN MANDATORIES)))
          (TRANSFORMS= (IF (MEMBER 'TRANSFORMS FORBIDDEN)
                           (ERROR 
           "ERROR: TRANSFORMS is not a permitted specification for ~S."
                                  (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)
                                  ))
                 (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-TRANSFORMS)
                       (MAKE-ARRAY (LIST (LENGTH (CDR SPECIFIER)))
                              :INITIAL-CONTENTS
                              (CDR SPECIFIER)))
                 (SETF MANDATORIES (REMOVE 'TRANSFORMS MANDATORIES)))
          (SUCCESS-THRESHOLD= (IF (MEMBER 'SUCCESS-THRESHOLD FORBIDDEN)
                                  (ERROR 
    "ERROR: SUCCESS-THRESHOLD is not a permitted specification for ~S."
                                         (SLOT-VALUE RA-INSTANCE
                                                'UNIQUE-NAME)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'SUCCESS-THRESHOLD)
                       (CADR SPECIFIER)))
          (NO-MATCH-CONFIDENCE= (IF (MEMBER 'NO-MATCH-CONFIDENCE 
                                           FORBIDDEN)
                                    (ERROR 
  "ERROR: NO-MATCH-CONFIDENCE is not a permitted specification for ~S."
                                           (SLOT-VALUE RA-INSTANCE
                                                  'UNIQUE-NAME)))
                 (SETF (SLOT-VALUE RA-INSTANCE '
                              DISPLAY-NO-MATCH-CONFIDENCE)
                       (CADR SPECIFIER)))
          (NO-MATCH-ACTION= (IF (MEMBER 'NO-MATCH-ACTION FORBIDDEN)
                                (ERROR 
      "ERROR: NO-MATCH-ACTION is not a permitted specification for ~S."
                                       (SLOT-VALUE RA-INSTANCE
                                              'UNIQUE-NAME)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-NO-MATCH-ACTION
                              )
                       (CDR SPECIFIER)))
          (MATCH-CONFIDENCE= (IF (MEMBER 'MATCH-CONFIDENCE FORBIDDEN)
                                 (ERROR 
     "ERROR: MATCH-CONFIDENCE is not a permitted specification for ~S."
                                        (SLOT-VALUE RA-INSTANCE
                                               'UNIQUE-NAME)))
                 (SETF (SLOT-VALUE RA-INSTANCE '
                              DISPLAY-MATCH-CONFIDENCE)
                       (CADR SPECIFIER))
                 (SETF MANDATORIES (REMOVE 'MATCH-CONFIDENCE 
                                          MANDATORIES)))
          (MATCH-ACTION= (IF (MEMBER 'MATCH-ACTION FORBIDDEN)
                             (ERROR 
         "ERROR: MATCH-ACTION is not a permitted specification for ~S."
                                    (SLOT-VALUE RA-INSTANCE
                                           'UNIQUE-NAME)))
                 (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-MATCH-ACTION)
                       (CDR SPECIFIER)))
          (ARGUMENTS= (SETF (SLOT-VALUE RA-INSTANCE 'ARGUMENTS)
                            (CDR SPECIFIER)))
          (CONTROL-ADDITIONS=
           (SETF (SLOT-VALUE RA-INSTANCE 'CONTROL-ADDITIONS)
                 (CDR SPECIFIER))
           (IF (MEMBER 'JUDGE (MAPCAR #'CAR (CDR SPECIFIER)))
               (IF (MEMBER 'JUDGE-LAMBDA FORBIDDEN)
                   (PROGN (FORMAT *TRACE-OUTPUT* "~%~%WARNING: ~S redefines the JUDGE control form.~% It is being redefined as a FREE-FORM-RECOGNITION-AGENT.~% The source code should be changed appropriately!~%~%"
                                 (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME))
                          (RETURN-FROM STUFF-RA-SLOTS 'FREE-FORM))
                   (SETF MANDATORIES (REMOVE 'JUDGE-LAMBDA MANDATORIES)
                         ))))
          (TRACING-CONTROL-ADDITIONS= 
	   (SETF (SLOT-VALUE RA-INSTANCE 'TRACING-CONTROL-ADDITIONS)
		 (CDR SPECIFIER)))
          (AUTHOR= (SETF (SLOT-VALUE RA-INSTANCE 'AUTHOR)
                         (CADR SPECIFIER))
                 (SETF MANDATORIES (REMOVE 'AUTHOR MANDATORIES)))
          (CREATION-DATE= (SETF (SLOT-VALUE RA-INSTANCE 'CREATION-DATE)
                                (CADR SPECIFIER))
                 (SETF MANDATORIES (REMOVE 'CREATION-DATE MANDATORIES))
                 )
          (LAST-MODIFICATION-DATE= (SETF (SLOT-VALUE RA-INSTANCE
                                                'LAST-MODIFICATION-DATE
                                                )
                                         (CADR SPECIFIER))
                 (SETF MANDATORIES (REMOVE 'LAST-MODIFICATION-DATE 
                                          MANDATORIES)))
          (SPECIFIC-FUNCTION= (SETF (SLOT-VALUE RA-INSTANCE
                                           'SPECIFIC-FUNCTION)
                                    (CADR SPECIFIER)))
          (OUTPUT-CONFIDENCE-VOCABULARY= (SETF (SLOT-VALUE RA-INSTANCE
                                                      '
                                           OUTPUT-CONFIDENCE-VOCABULARY
                                                      )
                                               (RETURN-GENERIC-INSTANCE
                                                (CADR SPECIFIER))))
          (OUTPUT-DESTINATION= (SETF (SLOT-VALUE RA-INSTANCE '
                                DISPLAY-OUTPUT-DESTINATION)
                         (MAKE-ARRAY (LIST (LENGTH (CDR SPECIFIER)))
                                :INITIAL-CONTENTS
                                (CDR SPECIFIER))))
          (ASSOCIATED-CONCEPTS= (SETF (SLOT-VALUE RA-INSTANCE
                                             'ASSOCIATED-CONCEPTS)
                                      (CDR SPECIFIER))
                 (ADD-DRAGON-TO-CONCEPTS (SLOT-VALUE RA-INSTANCE
                                                'UNIQUE-NAME)
                        (CDR SPECIFIER)))
          (HIERARCHY= (IF (MEMBER 'HIERARCHY FORBIDDEN)
                          (ERROR 
            "ERROR: HIERARCHY is not a permitted specification for ~S."
                                 (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME))
                          )
                 (SETF (SLOT-VALUE RA-INSTANCE 'HIERARCHY)
                       (CDR SPECIFIER)))
          (COMPONENT-OF= (SETF (SLOT-VALUE RA-INSTANCE 'COMPONENT-OF)
                               (CDR SPECIFIER)))
          (COMPONENTS= (IF (MEMBER 'COMPONENTS FORBIDDEN)
                           (ERROR 
           "ERROR: COMPONENTS is not a permitted specification for ~S."
                                  (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)
                                  ))
                 (SETF (SLOT-VALUE RA-INSTANCE 'COMPONENTS)
                       (CDR SPECIFIER)))
          (AFTERWARDS= (SETF (SLOT-VALUE RA-INSTANCE 'AFTERWARDS)
                             (CADR SPECIFIER)))
          (TOOL-USER-SLOTS= (SETF (SLOT-VALUE RA-INSTANCE '
                                         TOOL-USER-SLOTS)
                                  (CDR SPECIFIER)))
          (RATIONALE= (SETF (SLOT-VALUE RA-INSTANCE 'RATIONALE)
                            (CADR SPECIFIER)))
          (EXPERT= (SETF (SLOT-VALUE RA-INSTANCE 'EXPERT)
                         (CADR SPECIFIER)))
          (CITATIONS= (SETF (SLOT-VALUE RA-INSTANCE 'CITATIONS)
                            (CADR SPECIFIER)))
          (DISCLAIMER= (SETF (SLOT-VALUE RA-INSTANCE 'DISCLAIMER)
                             (CADR SPECIFIER)))
          (OTHER-KNOWLEDGE-SOURCES= (SETF (SLOT-VALUE RA-INSTANCE
                                                 '
                                                OTHER-KNOWLEDGE-SOURCES
                                                 )
                                          (CADR SPECIFIER)))
	  (answer-cache-limit= 
	   (IF (MEMBER 'answer-cache-limit FORBIDDEN)
	       (ERROR 
         "ERROR: ANSWER-CACHE-LIMIT= is not a permitted specification for ~S."
	   	(SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME))
	       (setf (slot-value ra-instance 'answer-cache-limit)
		     (cadr specifier))))
	  (saved-case-limit=
	   (IF (MEMBER 'saved-case-limit FORBIDDEN)
	       (ERROR 
         "ERROR: SAVED-CASE-LIMIT= is not a permitted specification for ~S."
	   	(SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME))
	       (setf (slot-value ra-instance 'saved-case-limit)
		     (cadr specifier))))
          (MEMORY-RETENTION-LIMIT= (SETF (SLOT-VALUE RA-INSTANCE
                                                'MEMORY-RETENTION-LIMIT
                                                )
                                         (CADR SPECIFIER)))
          (MEMORY-RETENTION-WARNING-LIMIT= (SETF (SLOT-VALUE
                                                  RA-INSTANCE
                                                  '
                                         MEMORY-RETENTION-WARNING-LIMIT
                                                  )
                                                 (CADR SPECIFIER)))
          (OTHERWISE (ERROR "ERROR: In ~S, this is not a recognized specification for a recognition agent: ~S"
                            (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)
                            SPECIFIER))))
   (IF MANDATORIES (ERROR "ERROR in compiling ~S. Required specifications for ~S have not been made."
                          (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)
                          MANDATORIES))
   (FORMAT *TRACE-OUTPUT* 
          "Specification stuffed into appropriate slots. ~%"))


(DEFUN EXTRACT-CONFIDENCES (PATTERN-CONFIDENCE-SPEC-LIST) "Pull apart the patterns= spec, extract the confidences, stuff vector."
   (LET ((CONFIDENCE-VECTOR (MAKE-ARRAY (LENGTH 
                                           PATTERN-CONFIDENCE-SPEC-LIST
                                               )
                                   :FILL-POINTER 0))
         (CONF NIL))
        (DOLIST (PATTERN-CONF PATTERN-CONFIDENCE-SPEC-LIST)
               (SETF CONF 
       
       ;; if there is a "=>" after the first element, then let
       
       ;; CONF be the first thing after that, else if "=>" is
       
       ;; third, let it be the thing
       
       ;; after that, else let it be nil

                     (CASE (POSITION '=> PATTERN-CONF)
                           (2 (FOURTH PATTERN-CONF))
                           (1 (THIRD PATTERN-CONF))
                           (NIL NIL)))
       
       ;; put CONF on the confidence-vector

               (VECTOR-PUSH CONF CONFIDENCE-VECTOR))
        (RETURN-FROM EXTRACT-CONFIDENCES CONFIDENCE-VECTOR)))


(DEFUN EXTRACT-THRESHOLDS (PATTERN-CONFIDENCE-SPEC-LIST) 
           "Pull apart patterns, stuff success-thresholds into vector."
   (LET ((THRESHOLD-VECTOR (MAKE-ARRAY (LENGTH 
                                           PATTERN-CONFIDENCE-SPEC-LIST
                                              )
                                  :FILL-POINTER 0))
         (THRESH NIL))
        (DOLIST (PATTERN-CONF PATTERN-CONFIDENCE-SPEC-LIST)
               (SETF THRESH 
       
       ;; pattern-conf is of the form ((pattern) thresh =>
       
       ;; conf),
       
       ;; where thresh,  =>, and conf are optional (if conf is
       
       ;; there,
       
       ;; => must be also). If thresh is present, pull it out
       
       ;; and stuff
       
       ;; it into the array, making sure its between 1 and the
       
       ;; length
       
       ;; of pattern, else stuff in the length of pattern

                     (COND
                        ((AND (NUMBERP (SECOND PATTERN-CONF))
                              (<= 1 (SECOND PATTERN-CONF))
                              (<= (SECOND PATTERN-CONF)
                               (LENGTH (FIRST PATTERN-CONF))))
                         (SECOND PATTERN-CONF))
                        (T (LENGTH (FIRST PATTERN-CONF)))))
               (VECTOR-PUSH THRESH THRESHOLD-VECTOR))
        (RETURN-FROM EXTRACT-THRESHOLDS THRESHOLD-VECTOR)))


(DEFUN EXTRACT-MATCH-ACTIONS (PATTERN-CONFIDENCE-SPEC-LIST) 
                 "Pull the match actions out of pattern specification."
   (LET ((ACTIONS-VECTOR (MAKE-ARRAY (LENGTH 
                                           PATTERN-CONFIDENCE-SPEC-LIST
                                            )
                                :FILL-POINTER 0))
         (ACTION NIL))
        (DOLIST (PATTERN-CONF PATTERN-CONFIDENCE-SPEC-LIST)
               (SETF ACTION 
       
       ;; let ACTION be the second thing after the "=>" if
       
       ;; there is one (if there is no "=>", or no second thing
       
       ;; after it, let ACTION be nil

                     (CASE (POSITION '=> PATTERN-CONF)
                           (2 (IF (>= (LENGTH PATTERN-CONF)
                                      5)
                                  (NTHCDR 4 PATTERN-CONF)
                                  NIL))
                           (1 (IF (>= (LENGTH PATTERN-CONF)
                                      4)
                                  (NTHCDR 3 PATTERN-CONF)
                                  NIL))
                           (nil NIL)))
       
       ;; put CONF on the confidence-vector

               (VECTOR-PUSH ACTION ACTIONS-VECTOR))
        (RETURN-FROM EXTRACT-MATCH-ACTIONS ACTIONS-VECTOR)))
