;;; -*- Mode:Common-Lisp; Package:POS; Syntax:COMMON-LISP; Default-character-style:(FIX BOLD NORMAL); Base:10 -*-
;;; Copyright 1988 David Throop at the University of Texas at Austin

(in-package 'pos)

;;; This file presents Device-Dependent code for user interface functions.   These include 
;;; menues, prompts for filenames and Command Level prompts. 

;;; Although these functions are, generally, device dependent, the functions in the first
;;; section of this EXPLORER file are identical to their Symbolics versions.

;;; Add an option for changing the PostScript parameters to the CONTROL-VARIABLES menu.

(defparameter *ps-control-menu-entry*
	     '("PS controls"
	       :eval (set-ps-control-variables)
	       :character-style (nil :bold nil)
	       :documentation "Send Output to PostScript File"))

(defparameter *ps-control-variables*
  '((*default-directory*
      "Postscript Output" :documentation
      "Behavior names will be merged against this to give default files for screen image"
      :pathname)
    (*image-disposal*  "Send Images to" :menu-alist
		       (("Nowhere" :value :none :documentation
			 "Image is not generated, but program is run thru paces")
			("Screen" :value :screen)
			("PostScript File" :value :PS)("Both" :value :both)))
    (*postscript-style* "PostScript Style" :menu-alist
			(("Standard" :value :Standard
			  :documentation "Normal output for immediate hardcopy")
			 ("Bounded" :value :bounded
			  :documentation "For Inclusion in LaTeX using PSFIG")
			 ("Text-Format-Insert" :value :Text-Format-Insert :documentation
			  "Special style for inclusion is TEXT-FORMAT documents")
			 ("MS" :value :ms-word :documentation
			  "For inclusion in MS-WORD documents")))
    (*Text-Format-text-width* "Formatted Text Width" :number
			      :documentation "Width of the figure of Text-Format output")
    (xscreen "Screen Width" :number :documentation
	     "Screen Width in Pixels")
    (yscreen "Screen Height" :number :documentation
	     "Screen Height in Pixels")))
  
(defun set-ps-control-variables ()
  "Set varibles for PostScript Output.  Refuse to take a default
directory if FS:PARSE-PATHNAME complains."
  (Tv:choose-variable-values
    *ps-control-variables*
    :extra-width 66
    :label "Put QSIM plots in a PostScript File"))


;;; POSTSCRIPT-WIZARD-OPTIONS allows changing dimensions for special
;;; output needs, eg legal-sized paper or for students with bad
;;; astigmatisms.

(defun postscript-wizard-options ()
  (tv:choose-variable-values
    '((*x-translation* :number :documentation
	     "Distance from lower left corner, in inches, along bottom of page to X = 0")
      (*y-translation* :number :documentation
	     "Distance from lower left corner, in inches, along side of page to Y = 0")
      (*rotation*
	:number :documentation
	"Rotation of x,y coordinates.  0 means y is the side and x is the bottom of paper.")
      (*x-scale*				; These are normally rebound dynamically, anyway,
	:number :documentation			;   so changing them makes no difference.
	"Compression of X axis, used to fit output on page [negative values print backwards]")
      (*y-scale* :number :documentation
	     "Compression of Y axis, used to fit output on page"))
    :Label "  Alter these to get differently shaped output  "))

;;; The postscript image must be written to a file before it is printed.  The next two
;;; forms query about the name of the file to be created to do this.  The third form asks
;;; the user whether to dispatch the completed PS file to the printer.

;;; Concatinate the NAME of the initial QDE onto *default-directory*.  Get the name
;;; from the initial state.  

(defparameter *picture* :picture)

;;; The next two functions are SLIGHTLY different than their Symbolics versions

(defun get-postscript-file ()			
  (let ((nm (fs:merge-pathnames
	      (format nil "~(~a~).ps"
		      *picture*)
	      *default-directory*)))
    (terpri *standard-output*)
    (terpri *standard-output*)
    (global:prompt-and-read		
      `(:pathname :defaults ,nm)
      "PostScript output to what file [~a]? " nm)))

(defun maybe-hardcopy-image (filename &key (tv nil)
			     &aux (qstring (format nil "  Hardcopy File ~a?   "
						   filename)))
  (when (and (eq *postscript-style* :standard)
	     (if tv
		 (tv:mouse-y-or-n-p qstring)
		 (zl:fquery () qstring)))
    (global:print-file filename :printer (global:get-default-printer))))