 ;;; -*- Mode:Common-Lisp; Package:Qsim; Base:10 -*-


(in-package 'QSIM)

(defparameter *layout* nil "The current layout array.")

(defparameter lmargin 20.)		       	; left margin
(defparameter rmargin 40.)
(defparameter tmargin 100.)
(defparameter bmargin 50.)

(defparameter xsep 30. "X pixels separation between graphs")
(defparameter ysep 25. "Y pixels separation between graphs")

(defparameter *border-width* 2 "Thickness of graph border lines.")

;;; Compute-layout sets the actual size for qplot boxes.
(defparameter *xsize* 0. "Width in pixels of one parameter-plot box.")
(defparameter *ysize* 0. "Height in pixels of one parameter-plot box.")

(defparameter xbsize 100.	"X Pixels allocated for behavior tree plot.")
(defparameter ybsize tmargin	"Y Pixels allocated for behavior tree plot.")
(defparameter ybloc  10.	"Y Location of root of behavior state tree plot.")

(defparameter ndots 5 "Number of dots between two points")

; The horizontal axis has several regions:
;   - left margin
;   - reference states
;   - gap between reference states and behaviors.
;   - the time-points of the first operating region.
;   - inter-operating-region gap.
;   - next operating region (and subsequent ones, with gaps)
;   - right margin (contains landmarks and ticks on vertical axis)
; It is laid out in shares, where one time-interval is one share.

(defparameter lshare	0.5	"Left margin share")			
(defparameter refshare	0.0	"Share for reference points")				
(defparameter rbgap	1.0	"Gap between reference points and behavior")			
(defparameter behshare	0.0	"Share for behavior timepoints")				
(defparameter ortgap	0.1	"Gap for operating region transition")			
(defparameter rgap	0.5	"Gap between plot and labels at right")				
(defparameter vtickshare 0.2	"Space for ticks on vertical axis")			
(defparameter vlabelshare 0.8	"Space for labels")			
(defparameter vquantshare 0.0	"Space for q2 ranges (set in allocate-h-axis)")			
(defparameter rshare	1.5	"Right margin share")			

(defparameter vtickpoint 0.0)
(defparameter vlabelpoint 0.0)

(defparameter Hshare 0.0 "The value of one share (floating point).")				
(defparameter tick-length 4)

; The vertical axis; laid out separately for each plot.

(defparameter labelspace 15	"Space for label of entire plot.")			
(defparameter *plot-offset* 0	"Extra downward offset of top of plot.")  ;D.B. 12/13/89  
(defparameter tshare 1.0	"Top margin share")			
(defparameter qsshare 0.0	"Quantity space share")				
(defparameter bshare 3.0	"Bottom margin share (incl. h-axis)")			
(defparameter *VshareSize* 0.0	"Size of vertical share")			
(defparameter htickprop 2.0	"Where to put ticks on v-axis")			
(defparameter htickpoint 0.0)
(defparameter hlabelprop 1.0	"Where to put labels")			
(defparameter hlabelpoint 0.0)

(defparameter *pretty-numbers* t "Numbers in graphs rounded reasonably")               


;;; Behavior tree plotting parameters (some)
;;; These are used in plot-state-tree.

(defparameter tree-xstep-max 20. "Maximum x-step in beh. tree plot")
(defparameter tree-ystep-max 20. "Maximum y-step in beh. tree plot")

; The basic functions for generating the display.
;  - The initial state points to all the subsequent states.
;  - QSIM-DISPLAY binds globals and invokes the display through the interface.
;  - DEVICE-INTERFACE is a macro (defined in qplot-primitives.lisp) that handles
;    interface to various output devices, including screen and PostScript file.
;  - DISPLAYS allocates the screen, and iterates through the behaviors.
;  - DISPLAY-BEHAVIOR plots each parameter on a screen
;  - PLOT-PARAMETER plots an individual parameter where it is told.

(defparameter *Qsim-Display-Version* 'new)
(defparameter *Behavior* nil)

;;; Plotting parameters

(defparameter *Perturb-Arrow-Thickness* 1)
(defparameter *Columns-For-Layout* 4)
(defparameter *Include-Time-In-Layout* t)
(defparameter *Time-Label-Offset* 5)
(defparameter *Literal-Parameter-Names* nil)

; Mallory 25 Nov 91: Use *Plot-Small-State-Tree* instead:
; (defparameter *Plot-Tree-With-Time-Plot* ...)
;  "If and when to plot the behavior tree with the behavior time plot:
;   T or :after to plot the tree after the time plot, :before to plot it before,
;   nil not to plot the tree.")

(defparameter *Plot-Small-State-Tree* 20
  "Whether to plot a small state tree in the upper right corner of a time, phase,
   or other plot:  May be T, NIL, or an integer (meaning plot the tree only if it
   contains no more than <integer> behaviors).")

(defparameter *Plot-State-Indices* nil
  "Where to plot state indices in behavior tree.  May be nil (no indices),
   :at-node (indices replace node symbols), :above-node, or :right-of-node.")

(defparameter *Plot-Beh-Numbers* #+Symbolics nil #-Symbolics t
  "Plot the behavior number of each behavior in the state tree plot.
   T or :left = on the left, :right = on the right, nil = don't plot.")

(defparameter *plot-intervals* nil
  "If T, a vertical line behind the qdir symbol is plotted when plotting a parameter,
 to show a qmags' extend. Useful when aggregating states, in which interval
 upper and lower bound may not be adjacent")

(defparameter *Functions-For-Label*
	      '(qprint-structure qprint-justification qprint-list-behavior qprint-final-state)
  "Each of these functions prints text for a label and
   returns the number of lines of text printed (an integer).")


(defparameter *mark-states* t
  "When set to t, qsim-display will mark states with MARK-STATE in its status with
the symbol identified inthe MARK-STATE entry in the status slot.")
