;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)


; The tub with constant inflow and constant drain area.

(define-QDE tub+drain
  (text "Bathtub with inflow and drain.")
  (quantity-spaces
	       (amount    (0 FULL))
	       (level     (0 TOP inf))
	       (pressure  (0 inf))
	       (rootp     (0 inf))
	       (drain     (0 OPEN inf))
	       (outflow   (0 inf))
	       (inflow    (0 if* inf))
	       (netflow   (minf 0 inf)))
  (independent inflow drain)
  (dependent   amount level pressure rootp outflow netflow)
  (history     amount)
  (constraints
	       ((M+ amount level)              (0 0) (full top))
	       ((M+ level pressure)            (0 0) (inf inf))
	       ((M+ pressure rootp)            (0 0) (inf inf))
	       ((MULT rootp drain outflow))
	       ((ADD netflow outflow inflow))
	       ((d//dt amount netflow)))
  (transitions ((amount (full inc)) tub-overflows))
  (print-names (amount   "amt(water,tub)"              A)
	       (level    "level(water,tub)"            L)
	       (pressure "pressure(water,bottom(tub))" P)
	       (rootp    "k * sqrt(pressure)"          RP)
	       (drain    "drain area"                  D)
	       (outflow  "flow(water,tub->out)"        OF)
	       (inflow   "flow(water,in->tub)"         IF)
	       (netflow  "net flow(water,out->tub)"    NF))
  (layout (amount level nil)
	  (pressure rootp drain)
	  (inflow outflow netflow)
	  (nil floor))
  )

; Fill the bathtub.

(defun fill-closed-bathtub ()
  (let ((initial-state
	  (make-initial-state tub+drain
			      '((inflow (if* std))
				(drain  (0 std))
				(amount (0 nil)))
			      "Filling tub from empty, drain closed")))
    (qsim initial-state)
    (qsim-display initial-state nil)            ; no reference points yet.
    ))

(defun fill-open-bathtub ()
  (let ((initial-state
	  (make-initial-state tub+drain
			      '((inflow (if* std))
				(drain  (OPEN std))
				(amount (0 nil)))
			      "Filling tub from empty, drain open")))
    (qsim initial-state)
    (qsim-display initial-state nil)            ; no reference points yet.
    ))

; When the tub overflows, the extra flows onto the floor.

(define-QDE overflowing-tub
  (text "Overflowing bathtub.")
  (quantity-spaces
	       (amount    (0 FULL))
	       (level     (0 TOP inf))
	       (pressure  (0 inf))
	       (rootp     (0 inf))
	       (drain     (0 OPEN inf))
	       (outflow   (0 inf))
	       (inflow    (0 if* inf))
	       (netflow   (minf 0 inf))
	       (floor     (0 inf)))
  (independent inflow drain amount)
  (dependent   level pressure rootp outflow netflow)
  (history     floor)
  (constraints
	       ((M+ amount level)              (0 0) (full top))
	       ((M+ level pressure)            (0 0) (inf inf))
	       ((M+ pressure rootp)            (0 0) (inf inf))
	       ((MULT rootp drain outflow))
	       ((ADD netflow outflow inflow))
	       ((d//dt floor netflow)))
  (transitions ((netflow (0 dec)) stops-overflowing))
  (print-names (amount   "amt(water,tub)"              A)
	       (floor    "amt(water,floor)"            F)
	       (level    "level(water,tub)"            L)
	       (pressure "pressure(water,bottom(tub))" P)
	       (rootp    "k * sqrt(pressure)"          RP)
	       (drain    "drain area"                  D)
	       (outflow  "flow(water,tub->out)"        OF)
	       (inflow   "flow(water,in->tub)"         IF)
	       (netflow  "net flow(water,out->tub)"    NF))
  (layout (amount level nil)
	  (pressure rootp drain)
	  (inflow outflow netflow)
	  (nil floor))
  )

; transition:  Tub+Drain  -->  Overflowing-Tub

(defun tub-overflows (tub-state)
  (let* ((old-values (state-values tub-state))
	 (new-values (list '(floor (0 nil))
			   (list 'amount
				 (list (qmag (lookup 'amount old-values)) 'std))
			   (assoc 'inflow old-values)
			   (assoc 'drain old-values))))
    (make-transition-result tub-state overflowing-tub new-values)))

; transition:  Overflowing-Tub  -->  Tub+Drain

(defun stops-overflowing (tub-state)
  (let* ((old-values (state-values tub-state))
	 (new-values (list (assoc 'amount old-values)
			   (assoc 'inflow old-values)
			   (assoc 'drain old-values))))
    (make-transition-result tub-state tub+drain new-values)))