;;; -*- Mode:Common-Lisp; Package: QSIM; Syntax:COMMON-LISP; Base:10 -*-
;;; Written 1989 by Daniel Dvorak.

(in-package 'QSIM)

(defparameter *qde-circuits* nil)

;;;=============================================================================
;;;
;;;                 T O T A L    E N V I S I O N M E N T S
;;;
;;;          ***  CAUTION:  THIS IS AN EXPERIMENTAL FUNCTION. ***
;;;-----------------------------------------------------------------------------


;;;  Find all circuits up to length N in constraint network.
;;;  

(defun find-all-circuits (qde path-limit)
  (declare (special path-limit))

  ;; Initialization.
  (setq *qde-circuits* nil)
  (dolist (con (qde-constraints qde))
    (setf (constraint-done con) nil))
  (dolist (var (qde-variables qde))
    (setf (variable-done-p var) nil))

  (dolist (var (qde-variables qde))
    (bfs var var (list var) nil 1))
  )

(defun bfs (from-var goal-var var-path con-path path-length)
  (declare (special path-limit))
  (if (>= path-length path-limit)
      (return-from bfs)

      (dolist (con (variable-constraints from-var))
	(when (and (constraint-active-p con)
		   (not (constraint-done con))
		   (not (member con con-path)))
	  (dolist (var (constraint-variables con))
	    (cond ((eq var from-var) nil)
		  ((eq var goal-var)
		   (format t "~%--- Making circuit of length ~d: ~a"
			   path-length (reverse var-path))
		   ;	 (push (make-circuit :variables   var-path
		   ;			     :constraints (cons con  con-path))
		   ;	       *qde-circuits*)
		   )
		  ((member var var-path) nil)
		  (t (bfs var goal-var (cons var var-path) (cons con con-path) (1+ path-length)))))))))
  
;;; Find all cycles in the given constraint network.
(defun find-all-circuits (qde)

  ;; Initialization.
  (setq *qde-circuits* nil)
  (dolist (con (qde-constraints qde))
    (setf (constraint-done con) nil))
  (dolist (var (qde-variables qde))
    (setf (variable-done-p var) nil))

  ;; Find all circuits involving variable var.
  (dolist (var1 (qde-variables qde))

    ;; If var1 has only 1 constraint, then it cannot have any circuits.
    (unless (= 1 (length (variable-constraints var1)))

      ;; For each active constraint on this variable ...
      (dolist (con (variable-constraints var1))
	(when (constraint-active-p con)

	  ;(format t "~%--------------------------Starting from (~a . ~a)" var1 con)
	  ;; Don't allow a circuit that returns to var1 via this constraint.
	  (setf (constraint-done con) t)

	  ;; For each variable of the constraint that isn't var1
	  ;; and hasn't previously been check for circuits ...
	  (dolist (var2 (constraint-variables con))
	    (unless (or (eq var1 var2)
			(variable-done-p var2))

	      ;; Do depth-first-search from var2 looking for circuit to var1,
	      ;; building up the path as we go.
	      (dfs var2 var1 (list var1) (list con))))
	  )
	)
      )
    ;; Mark this variable "done" now that we've found its circuits.
    (setf (variable-done-p var1) t)

    ;; Done with circuits for var1, so reinstate its constraints.
    (dolist (con (variable-constraints var1))
      (setf (constraint-done con) nil))
    )
  )


;;; Depth-first-search from var2 to var1

(defun dfs (var2 var1 var-path con-path)
  (declare (special *qde-circuits*))

  ;; For each active constraint on var2 that isn't already "done" ...
  (dolist (con (variable-constraints var2))
    ;(format t "~%------ Trying ~a: " con)
    (when (and (constraint-active-p con)
	       (not (constraint-done con))
	       (not (member con con-path)))
      ;(format t " OK")

      ;; For each variable of the constraint (other than var2) ...
      (dolist (var3 (constraint-variables con))
	;(format t "~%------ Trying ~a: eq= ~a, done-p= ~a, var-path= ~a"
	;	var3 (eq var3 var2) (variable-done-p var3) var-path)
	(unless (or (eq var3 var2)
		    (variable-done-p var3))
	  (if (eq var3 var1)
	      (progn
		;(format t "OK")
		;(format t "~%----------- Making circuit: ~a" (reverse (cons var2 var-path)))
		(push (make-circuit :variables   (reverse (cons var2 var-path))
				    :constraints (reverse (cons con  con-path)))
		      *qde-circuits*))
	      (unless (member var3 var-path)
		;(format t "OK")
		(dfs var3 var1 (cons var2 var-path) (cons con con-path)))))))))


(defother constraint current-tuple)
(defother constraint tuples-ok)

(defun reorder-circuits ()
  (setq *qde-circuits* (sort *qde-circuits* #'< :key #'(lambda (cir) (length (circuit-variables cir))))))

;(defun filter-circuits (circuits)
;
;  ;; For each circuit ...
;  (dolist (circuit circuits)
;    
;    ;; Initialization.
;    (setq *combinations* 0)
;    (dolist (pair circuit)
;      (let ((con (cdr pair)))
;	(setf (constraint-tuples-ok con) nil)
;	(dolist (var (constraint-variables con))
;	  (setf (variable--qval var) NIL))))
;    
;    (format t "~%Doing circuit of length ~a: " (length circuit))
;    ;; Sort circuit in increasing number of tuples.
;    ;;(setq circuit (sort circuit #'< :key #'(lambda (pair) (length (constraint--tuples (cdr pair))))))
;    (format t " ~a" (mapcar #'(lambda (pair) (length (constraint--tuples (cdr pair)))) circuit))
;    (let ((pair1 (first circuit))
;	  (pair2 nil)
;	  (ncircuit nil))
;      (push pair1 ncircuit)
;      (setq (delete pair1 circuit :count 1))
;      (dolist (con (constraint-neighbors (cdr pair1)))
;	(if (setq pair2 (rassoc con circuit
;    
;    ;; Filter out inconsistent tuples on this circuit.
;    (filter-circuit-tuples circuit circuit)
;
;    (format t "~%No. of compatible combinations = ~a" *combinations*)
;    
;    ;; Update tuples from those that survived.
;    (dolist (pair circuit)
;      (let* ((con (cdr pair))
;	     (old-length (length (constraint--tuples con)))
;	     (new-length (length (constraint-tuples-ok con))))
;	(when (< new-length old-length)
;	  (format t "~%~3d --> ~3d tuples for ~a"
;		  old-length new-length con)
;	  (setf (constraint--tuples con) (constraint-tuples-ok con))
;	  )
;	)
;      )
;    )
;  )

;;;  Given a circuit, this recursively finds all compatible tuples.

(defun filter-circuit-tuples (remaining-circuit full-circuit)

  ;; If no remaining constraints on this circuit ...
  (if (null remaining-circuit)

      ;; then we have a compatible set of tuples to remember
      (progn
	(dolist (pair full-circuit)
	  (let ((con (cdr pair)))
	    (pushnew (constraint-current-tuple con) (constraint-tuples-ok con) :test #'equal)))
	(incf *combinations*))

      ;; else we take the next constraint and try to find all of its
      ;; tuples that are compatible with the preceding tuple selections.
      (let* (;(var    (caar remaining-circuit))
	     (con    (cdar remaining-circuit))
	     (assigned-variables nil)
	     val)

	;; Build list of variables that will be assigned by this constraint.
	(dolist (var (constraint-variables con))
	  (if (null (variable--qval var))
	      (push var assigned-variables)))

	;(format t "~%Doing constraint ~a, assigning to ~a" con assigned-variables)
	
	;; For each tuple of this constraint on the circuit ...
	(dolist (tuple (constraint--tuples con))

	  ;; Try to bind variables with this tuple.
	  ;; If a conflict arises, skip this tuple.
	  (when (do ((vars (constraint-variables con) (cdr vars))
		     (tvals tuple (cdr tvals)))
		    ((endp vars) t)
		  (if (setq val (variable--qval (car vars)))
		      (unless (qval-equal val (car tvals))
			;(format t "~%Conflict: ~a:  ~a  ~a" (car vars) val (car tvals))
			(dolist (var assigned-variables)
			  (setf (variable--qval var) nil))
			(return nil))
		      (setf (variable--qval (car vars)) (car tvals))))

	    ;; We've accepted this tuple of this constraint, so now we can
	    ;; proceed to the next constraint.
	    (setf (constraint-current-tuple con) tuple)
	    (filter-circuit-tuples (cdr remaining-circuit) full-circuit)
	    
	    ;; Unassign the variable values that were tentatively assigned.
	    (dolist (var assigned-variables)
	      (setf (variable--qval var) nil))
	    )
	  )
	)
      )
  )

(defstruct (CIRCUIT (:print-function circuit-printer))
  "A circuit in the constraint network."
  (variables nil)
  (constraints nil)
  (values nil)
  (completions nil)
  (var1-indices nil)
  (var2-indices nil)
  )

(defun circuit-printer (cir stream ignore)
  (terpri stream)
  (princ (circuit-variables cir) stream)
  (terpri stream)
  (princ (circuit-constraints cir) stream)
  )

(defun find-circuit-completions (cir)
  (declare (special cir))
  (let ((size (length (circuit-variables cir))))
    ;; Initialize
    (setf (circuit-completions cir) nil)
    (setf (circuit-var1-indices cir) (make-list size)
	  (circuit-var2-indices cir) (make-list size)
	  (circuit-values cir)       (make-list size))
    (do ((vars         (circuit-variables cir)    (cdr vars))
	 (constraints  (circuit-constraints cir)  (cdr constraints))
	 (var1-indices (circuit-var1-indices cir) (cdr var1-indices))
	 (var2-indices (circuit-var2-indices cir) (cdr var2-indices)))
	((endp vars))
      (let ((var1 (first vars))
	    (var2 (second vars))
	    (cvars (constraint-variables (first constraints))))
	(rplaca var1-indices (position var1 cvars))
	(if var2
	    (rplaca var2-indices (position var2 cvars))
	    (rplaca var2-indices (position (first (circuit-variables cir)) cvars)))))

    ;(print "mark 1")
    ;;

    ;; For each pval of var1 ...
    (dolist (first-val (variable--pvals (first (circuit-variables cir))))
      (declare (special first-val))
      (rplaca (circuit-values cir) first-val)
      (find-circuit-completions-2 first-val
				  (circuit-variables cir)
				  (circuit-constraints cir)
				  (cdr (circuit-values cir))
				  (circuit-var1-indices cir)
				  (circuit-var2-indices cir))
      )
    )
  )
;;;-----------------------------------------------------------------------------

(defun find-circuit-completions-2 (val1 variables constraints values var1-indices var2-indices)
  (declare (special first-val cir))
  (let* (;(var1 (first variables))
	 (var2 (second variables))
	 (con  (first constraints))
	 (var1-index (car var1-indices))
	 (var2-index (car var2-indices)))

    (if (null var2)
	;; We've reached the end of the circuit, so if ANY tuple of the last
	;; constraint matches the value assigned to the first variable of the
	;; circuit, then save the circuit values as a completion.
	(dolist (tuple (constraint--tuples con))
	  (when (and (eq (nth var1-index tuple) val1)
		     (eq (nth var2-index tuple) first-val))
	    ;(write-char #\.)
	    (push (copy-list (circuit-values cir)) (circuit-completions cir))
	    (return-from find-circuit-completions-2 (values))))

	;; For each possible value of var2, see if ANY tuple of the constraint
	;; is compatible with val1 and val2.  If so, assign val2 to var2 and
	;; recur to the next variable & constraint on the circuit.
	(dolist (val2 (variable--pvals var2))
	  (block tuple-matching
	    (dolist (tuple (constraint--tuples con))
	      (when (and (eq (nth var1-index tuple) val1)
			 (eq (nth var2-index tuple) val2))
		(rplaca values val2)
		(find-circuit-completions-2 val2 (cdr variables) (cdr constraints) (cdr values) (cdr var1-indices) (cdr var2-indices))
		(return-from tuple-matching nil)))))
	)))
    
;;; Attempt to bind this constraint's variables from the given tuple.
;;; If all bindings consistent, return non-NIL, else NIL.



(defun step1 ()
  (format t "~%OK to abort when form-all-states is called")
  (trace form-all-states)
  (total-envisionment heart-regulation))

(defun step2 ()
  (format t "~%Find-all-circuits: ")
  (find-all-circuits heart-regulation)
  (format t "~a circuits" (length *qde-circuits*))
  (reorder-circuits)
  )

(defun step3 ()
  (format t "~%Ordered circuits: ~a" (mapcar #'(lambda (cir)
						 (length (circuit-variables cir)))
					     *qde-circuits*))
  (format t "~%STARTING TO FIND CIRCUIT COMPLETIONS:")
  (dolist (cir *qde-circuits*)
    (format t "~%-------------- Circuit of length ~d: npvals = ~a"
	    (length (circuit-variables cir))
	    (mapcar #'variable--npvals (circuit-variables cir)))
    (find-circuit-completions cir)
    (format t "~%               ~d completions found."
	    (length (circuit-completions cir)))
;    (terpri)
;    (dolist (var (circuit-variables cir))
;      (format t "~17a" (variable-name var)))
;    (dolist (comp (circuit-completions cir))
;      (terpri)
;      (dolist (qval comp)
;	(format t "~17a" qval)))
      
    )
  )

