;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)


;;;
;;; D,#TD1PsT[Begin using 006 escapes](1 0 (NIL 0) (:SWISS :ITALIC NIL) "HL12I")Circuit Domain Variable Name
(2 0 (NIL 0) (NIL NIL NIL) "CPTFONT");;;

(setq *domain-specific-variable-types*
      (list (list 'effort 'voltage "V")
	    (list 'flow 'current "I")
	    (list 'resistance 'resistance "R")
	    (list 'capacitance 'capacitance "C")
	    (list 'displacement 'charge "Q")
	    (list 'inductance 'inductance "L")
	    (list 'momentum 'flux-linkage "Fl")
	    ))


;;;
;;; 1Model Component Definitions
2;;;

;;; 1Battery
2(define-component battery
  (terminal-variables (t1 (v1 (type voltage) independent)
			  (i1 (type current)))
		      (t2 (v2 (type voltage) independent)
			  (i  (type current) display)))
  (component-variables (v (type voltage) independent display))
  (constraints ((ADD v v2 v1))			        ; (3 0 (NIL 0) (:SWISS :ROMAN :SMALLER) "HL10")Voltage measured across terminals
2	       ((MINUS i i1) (0 0) (inf minf)))    	; 3Battery current has opposite sign of outflow at t1
2  )

;;; 1Capacitor
2(define-component capacitor
  (terminal-variables (t1 (v1 (type voltage))
			  (i  (type current) display))
		      (t2 (v2 (type voltage))
			  (i2 (type current))))
  (component-variables (v (type voltage) display)
		       (c (type capacitance) independent display)
		       (q (type charge) display))
  (constraints ((ADD v v2 v1))			; 3Voltage measured across terminals
2	       ((MULT v c q))			; 3Charge is product of Voltage and Capacitance
2	       ((d//dt q i))			; 3Current is first derivative of Charge
2	       ((MINUS i i2) (minf inf) (0 0) (inf minf))     	; 3Current at termainls has opposite sign
2	       )
  )

;;; 1Resistor
2(define-component resistor
  (terminal-variables (t1 (v1 (type voltage))
			  (i  (type current) display))
		      (t2 (v2 (type voltage))
			  (i2 (type current))))
  (component-variables (v (type voltage)3 2display)
		       (r (type resistance) independent3 2display))
  (constraints ((ADD v v2 v1))			                    ; 3Voltage measured across terminals
2	       ((MULT i r v))			                    ; 3Ohm's Law
2	       ((MINUS i i2) (minf inf) (0 0) (inf minf))	    ; 3Current at terminals has opposite sign
2	       )
  )

;;; 1Inductor
2(define-component (4 0 (NIL 0) (NIL :BOLD NIL) "CPTFONTCB")INDUCTOR-A
2  (terminal-variables (t1 (v1 (type voltage))
			  (i  (type current) display))
		      (t2 (v2 (type voltage))
			  (i2 (type current))))
  (component-variables (v (type voltage)3 2display)
		       (l (type inductance) independent display)
		       (neg-l (type inductance))
		       (fl (type flux-linkage) display))
  (constraints ((ADD v v2 v1))			                ; 3Voltage measured across terminals
2	       ((MINUS i i2) (minf inf) (0 0) (inf minf))	; 3Current at terminals2 3have opposite sign
2	       ((MINUS l neg-l) (minf inf) (0 0) (inf minf))	; 3Negative inductance
2	       ((d//dt fl v))			                ; 3Change in Flux-linkage = Voltage
2	       ((MULT neg-l i fl))		                ; 3Inductor behavior
2	       )
  )

(define-component 4INDUCTOR-B
2  (terminal-variables (t1 (v1 (type voltage))
			  (i  (type current) display))
		      (t2 (v2 (type voltage))
			  (i2 (type current))))
  (component-variables (v (type voltage)3 2display)
		       (l (type inductance) independent display)
		       (neg-l (type inductance))
		       (di (type current) display))
  (constraints ((ADD v v2 v1))			; 3Voltage measured across terminals
2	       ((MINUS i i2) (minf inf) (0 0) (inf minf))	; 3Current at terminals2 3have opposite sign
2	       ((MINUS l neg-l) (minf inf) (0 0) (inf minf))	; 3Negative inductance
2	       ((d//dt i di))			; 3Change in current
2	       ((MULT neg-l di v))		; 3Inductor behavior
2	       )
  )

