;;; -*- Package: QSIM; Syntax: Common-lisp; Mode: Common-Lisp; -*-

(in-package :qsim) ;changed DJC

;;; With global variables bound as
;;;   (*QUERY-USER* NIL)
;;;   (*STATE-LIMIT* 20)
;;;   (*CHECK-FOR-CYCLES* T)
;;;   (*ANALYTIC-FUNCTIONS-ONLY* NIL)
;;;   (*CHECK-FOR-UNREACHABLE-VALUES* T)
;;;   (*NEW-LANDMARKS-ON-TRANSITION* T)
;;;   (*FIRE-TRANSITIONS* :ALL)
;;;   (*NEW-LANDMARKS-ACROSS-M-CONSTRAINTS* NIL)
;;;   (*NEW-LANDMARKS-AT-INITIAL-STATE* T)
;;;   (*ASK-ABOUT-MULTIPLE-COMPLETIONS* NIL)
;;;   (*DELETE-INCONSISTENT-BRANCHES* T)
;;;   (*TRACE-COUNT* NIL)
;;;   (*TRACE-QVALUES* NIL)
;;;   (*TRACE-TUPLES* NIL)
;;;   (*TRACE-CONSTRAINT-FILTER* NIL)
;;;   (*TRACE-MULT-CONSTRAINT* NIL)
;;;   (*TRACE-WALTZ-FILTER* NIL)
;;;   (*TRACE-STATES* NIL)
;;;   (TRACE-AGENDA NIL)
;;;   (TRACE-PROPAGATION NIL)
;;;   (*QSIM-TRACE* NIL)
;;;   (*SHOW-COMPLETION-STEPS* NIL)
;;;   (*TRACE-GLOBAL-FILTERS* NIL)
;;;   (*PRINT-TIMING* NIL)
;;;   (*AUTO-SD3-EVALUATION* NIL)
;;;   (*DERIVE-CURVATURE-CONSTRAINTS* T)
;;;   (*PERFORM-ACC-ANALYSIS* NIL)
;;;   (*PERFORM-ACC-ANALYSIS* NIL)
;;;   (*SEARCH-STATE-LIMIT* 30)
;;;   (*TRACE-ACC* NIL)
;;;   (*TRACE-ACC-FILTER-APPLICATION* NIL)
;;;   (*TRACE-AONODE-CREATION* NIL)
;;;   (*TRACE-AUTO-SD3-EVALUATION* NIL)
;;;   (*TRACE-CHATTER-VARS* NIL)
;;;   (*TRACE-CHILDREN* NIL)
;;;   (*TRACE-SD2-DERIVATION* NIL)
;;;   (*TRACE-SUCCESSFUL-RULES* NIL)
;;;   (*ASK-BEFORE-EACH-TSA-STEP* NIL)
;;;   (*TRACE-TSA-INITIAL-VALUES* NIL)
;;;   (*TRACE-LANDMARK-TRANSLATION* NIL)
;;;   (*SHOW-BEHAVIORS-DURING-TSA* NIL)
;;;   (*CHECK-ABSTRACTED-CONSTRAINTS* T)
;;;   (*ALLOW-PLOTTING* NIL)
;;;   (*QSIM-REPORT* NIL)
;;;   (*TRACE-EQUATION-PROPAGATION* NIL)
;;;   (INHIBIT-FDEFINE-WARNINGS T)
;;;   (*CHECK-QUANTITATIVE-RANGES* NIL)
;;;   (*TRACE-Q2-CHECK* NIL)
;;;   (*TRACE-EQN-INDEXING* NIL)
;;;   (*TRACE-AGENDA* NIL)
;;;   (*TRACE-RANGER* NIL)
;;;   (*TRACE-RANGE-UPDATE* NIL)
;;;   (*TRACE-SINGLE-CHAR* NIL)

(setf *test* '

((DEMOS (GRAVITY (THROW-BALL 1) (DROP-BALL 1) (THROW-W-RESISTANCE 3) (DROP-W-RESISTANCE 3))
  (BATHTUB (FILL-FROM-EMPTY 3) (INCREASE-FLOW 3) (DECREASE-FLOW 1) (UNDERSPECIFIED-STATE 11)
   (TOTALLY-UNSPECIFIED 32))
  (U-TUBE (ONE-SIDE-FULL 3) (Q2-RANGES 3))
  (DOUBLE-HEAT-FLOW (TEMP-UNSPECIFIED 7) (TEMP-BETWEEN-LIMITS 3) (TEMP-KNOWN 1))
  (SPRINGS (SIMPLE-SPRING 3) (SPRING-W-ENERGY-CONSERVATION 1) (SPRING-W-FRICTION 20))
  (BOUNCING-BALL (GRAVITY-SPRING-MODEL 1) (GRAVITY-REFLECTION-MODEL 1))
  (HOME-THERMOSTAT (ON-OFF-CONTROLLER 7) (PROPORTIONAL-CONTROLLER 3))
  (SLIDER-CRANK (ROTATE-CRANK 1)) (TWO-FUSES (HIERARCHICAL-QSPACE 1) (ORDINARY-QSPACE 3))
  (POPULATION-MODEL (FAMINE-THEN-RECOVERY 1))
  (CHEMICAL-REACTION (FIXED-RESOURCES 6) (INFLOW-CUTOFF 13))
  (TOASTER (PUSH-COOK-POP-FLY 7) (TOAST-MAY-BURN 13)) (ROCKET (FIRE-ROCKET 3))
  (Q2-BATHTUB (FILL-TUB 3)))
 (TANKS (BATHTUB (FILL-FROM-EMPTY 3))
  (CASCADED-TANKS (FILL-FROM-EMPTY 11) (INCREASE-INFLOW-RATE 11))
  (CASCADED-TANKS-IGN-TEST (FILL-FROM-EMPTY 2) (INCREASE-INFLOW-RATE 2))
  (CASCADED-TANKS-NNL-TEST (FILL-FROM-EMPTY 9) (INCREASE-INFLOW-RATE 9))
  (TWO-TANKS (FILL-FROM-EMPTY 11) (INCREASE-INFLOW-RATE 11))
  (TWO-TANKS-IGN-TEST (FILL-FROM-EMPTY 1) (INCREASE-INFLOW-RATE 1)))
 (MEDICAL (WATER-BALANCE (HIGH-WATER-INTAKE 1) (LOW-WATER-INTAKE 1) (HIGH-WATER-VOLUME 1))
  (SIADH-WATER-BALANCE (SIADH-NORMAL-INTAKE 1) (SIADH-THERAPY 3) (ABSTRACTION-LEARNING 3))
  (SODIUM-BALANCE (HIGH-SALT-INTAKE 1) (HIGH-INITIAL-SALT-LEVEL 1))
  (STARLING (LOW-PLASMA-PROTEIN 1))
  (HEART-REGULATION (BETA-BLOCKER 5) (BETA-STIMULATION 5) (LOW-BLOOD-VOLUME 3)
   (HIGH-BLOOD-VOLUME 3)))
 (TSA
  (SODIUM-AND-WATER (HIGH-WATER-INTAKE 1) (LOW-WATER-INTAKE 1) (LOW-SODIUM-LEVEL 1)
   (HIGH-SODIUM-LEVEL 1))
  (HOME-HEATER (TEST-FAST-BASE 1) (TEST-SLOW-CONTROLLER 1) (TEST-HIERARCHICAL-HEATER 1)))
 (CHATTER1 (CASCADED-TANKS (FILL-FROM-EMPTY 11) (INCREASE-INFLOW-RATE 11))
  (CASCADED-TANKS-IGN-QDIRS (FILL-FROM-EMPTY 2) (INCREASE-INFLOW-RATE 2))
  (CASCADE-TANKS-CURVATURE (FILL-FROM-EMPTY 2) (INCREASE-INFLOW-RATE 2))
  (CASCADED-TANKS-ACC (FILL-FROM-EMPTY 2) (INCREASE-INFLOW-RATE 2))
  (TWO-TANK (FILL-FROM-EMPTY 11) (TWO-TANK-PDMI 7))
  (TWO-TANK-IGN (FILL-FROM-EMPTY 1) (TWO-TANK-PDMI 3))
  (TWO-TANK-ACC (FILL-FROM-EMPTY 1) (TWO-TANK-PDMI 3)))
 (CHATTER2 (3-CASC-TANKS (FILL-FROM-EMPTY 15)) (3-CASC-TANKS-ACC (FILL-FROM-EMPTY 3))
  (3-CASC-TANKS-ACC-SD3 (FILL-FROM-EMPTY 1)) (4-CASC-TANKS (FILL-FROM-EMPTY 19))
  (4-CASC-TANKS-ACC (FILL-FROM-EMPTY 15)) (4-CASC-TANKS-ACC-SD3 (FILL-FROM-EMPTY 15))
  (5-CASC-TANKS (FILL-FROM-EMPTY 19)) (5-CASC-TANKS-ACC (FILL-FROM-EMPTY 15))
  (5-CASC-TANKS-ACC-SD3 (FILL-FROM-EMPTY 15)) (THREE-TANK (FILL-FROM-EMPTY 15))
  (THREE-TANK-ACC (FILL-FROM-EMPTY 11)) (THREE-TANK-ACC-SD3 (FILL-FROM-EMPTY 11)))
 (CHATTER3 (SPRING (RELEASE-FROM-MAX 5)) (SPRING-ACC (RELEASE-FROM-MAX 5))
  (SPRING-WF (RELEASE-FROM-MAX 10)) (SPRING-WF-ACC (RELEASE-FROM-MAX 4))
  (GLAUCOMA (LOW-FLOW-FACILITY 10)) (GLAUCOMA-ACC (LOW-FLOW-FACILITY 4)))
 (CHATTER4
  (W-TUBE-BC-EMPTY (CROSSFLOW-LEFT>RIGHT 12) (CROSSFLOW-LEFT=RIGHT 12)
   (CROSSFLOW-LEFT<RIGHT 12))
  (W-TUBE-B-LO-C-HI (CROSSFLOW-LEFT>RIGHT 6) (CROSSFLOW-LEFT=RIGHT 6) (CROSSFLOW-LEFT<RIGHT 6))
  (HEART-SYS-PROPERTY (HEART-TTTTT 8) (HEART-TTTTN 8) (HEART-TTTNN 8) (HEART-TTNNN 8)
   (HEART-TTZTT 8) (HEART-TTTNT 8) (HEART-TTNNT 8)))
 (EXTRAS (TWO-FUSES (WITHOUT-SHARED-QSPACES 3) (WITH-SHARED-QSPACES 1))
  (ACC-D-TANKS (Y-TANKS 14) (DY-TANKS 4) (DY-TANKS-ACC 4)) (DROP-ROCK (DROP-ROCK 1))
  (PRESSURE-REGULATOR (HIGH-INPUT-PRESSURE 10))
  (Q2-BALLS (Q2-DROP-BALL 5) (DROP-THING 9) (THROW-UPWARD-R 3) (DROP-THING-R 3))
  (THERMOSTAT-MODES (LOW-OUTSIDE-TEMPERATURE 7))
  (WATER-HEATER (NORMAL-HOT-NOFLOW 1) (NORMAL-HOT-HIFLOW 1) (BAD-H1-HOT-LOFLOW 1)
   (BAD-H1H2-HOT-HIFLOW 23))
  (TWO-STAGE-BATHTUB (FILL-A-PLUGGED-BATHTUB 5) (INCREASE-INFLOW-IN-PLUGGED-BATHTUB 7)))
 (Q-FEATURES
  (NON-INTERSECTION-CONSTRAINT (BRIEF-DESCRIPTION NIL) (SIMPLE-SPRING-W-TRACING 5)
   (SIMPLE-SPRING-W-O-TRACING 3) (DAMPED-SPRING-W-O-INIT-LMK 65) (DAMPED-SPRING-W-INIT-LMK 251)
   )
  (IGNORE-QVALS (BRIEF-DESCRIPTION NIL) (BAD-HEATERS-W-O-IGN-QVAL 23)
   (BAD-HEATERS-W-IGN-QVAL 23))
  (OPERATING-REGION-TRANSITION (BRIEF-DESCRIPTION NIL) (HOME-HEATER 7) (TOASTER 13))
  (IGNORE-QDIRS (BRIEF-DESCRIPTION NIL)) (CURVATURE-CONSTRAINTS (BRIEF-DESCRIPTION NIL))
  (ANALYTIC-FUNCTION (BRIEF-DESCRIPTION NIL)) (UNREACHABLE-LANDMARKS (BRIEF-DESCRIPTIONS NIL))
  (ENERGY-BASED-GLOBAL-FILTER (BRIEF-DESCRIPTION NIL) (GRAVITY-W-TRACING 3)
   (GRAVITY-W-FRICTION-N-TRACING-N-AF 6) (GRAVITY-W-FRICTION-N-TRACING 7)
   (BOUNCING-BALL-W-FRICTION-N-TRACING 46) (BOUNCING-BALL-W-FRICTION 2)
   (SIMPLE-SPRING-W-TRACING 11) (SIMPLE-SPRING 3) (DAMPED-SPRING-W-TRACING 20)
   (DAMPED-SPRING 5)))))
