 ;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-
;Copyright (c) 1986 by Benjamin Kuipers.
(in-package :qsim)

; The Starling equilibrium example, used in Kuipers and Kassirer, Cog.Sci., 1984.
; [Valtin, 1973, p. 26.]
; The Starling equilibrium regulates the balance of fluid between the plasma
; and interstitial compartments.

(Define-QDE Starling
  (text "The Starling equilibrium between plasma and interstitial compartments")
  (quantity-spaces
    (PP     (0 inf)       "amt(protein,P)")
    (PI     (0 inf)       "amt(protein,I)")
    (AFP    (0 inf)       "amt(water,P)")
    (WI     (0 inf)       "amt(water,I)")
    (ECW    (0 inf)       "extra-cellular water")
    (CPP    (0 inf)       "c(protein,P)")
    (CPI    (0 inf)       "c(protein,I)")
    (HPP    (0 inf)       "HP(water,P->I)")
    (HPI    (0 inf)       "HP(water,I->P)")
    (OPI    (0 inf)       "OncP(water,I->P)")
    (OPP    (0 inf)       "OncP(water,P->I)")
    (HPPI   (0 inf)       "net HP(water,P->I)")
    (OPIP   (0 inf)       "net OncP(water,I->P)")
    (FWPI   (minf 0 inf)  "flow(water,P->I)")
    (FWIP   (minf 0 inf)  "flow(water,I->P)")
    (NFPI   (minf 0 inf)  "net flow(water,P->I)")
    (MNFPI  (minf 0 inf)  "-NFPI"))
  (constraints
    ((mult WI CPI PI))
    ((mult AFP CPP PP))
    ((add AFP WI ECW))
    ((M+ AFP HPP)               (0 0) (inf inf))
    ((M+ WI HPI)                (0 0) (inf inf))
    ((M+ CPP OPI)               (0 0) (inf inf))
    ((M+ CPI OPP)               (0 0) (inf inf))
    ((M+ HPPI FWPI)             (0 0) (inf inf))
    ((M+ OPIP FWIP)             (0 0) (inf inf))
    ((add HPI HPPI HPP))
    ((add OPP OPIP OPI))
    ((add FWIP NFPI FWPI))
    ((d/dt AFP MNFPI))
    ((d/dt WI NFPI))
    ((minus NFPI MNFPI)         (0 0) (inf minf) (minf inf))
    ((constant pp))
    ((constant pi))
    ((constant ecw))))

(defvar *starling-layout* '((ecw nil pp pi)
			    (afp wi  cpp cpi)
			    (hpp hpi opi opp)
			    (nil hppi opip nil)
			    (nfpi fwpi fwip nil)))


; Initialize with PP lower than normal and steady.
;  Unreachable values still doesn't work perfectly on initial state.

(defun low-plasma-protein ()
  (let* ((sim (make-sim :unreachable-values '((opip 0) (fwip 0))))
	 (normal (make-new-state :from-qde Starling
				 :assert-values '((PP  ((0 inf) std))
						  (PI  ((0 inf) std))
						  (fwip ((0 inf) std))	; to avoid FWIP=0
						  (ECW ((0 inf) std))
						  (AFP ((0 inf) std))
						  (WI  ((0 inf) std)))
				 :sim sim))
	 (init (make-new-state :from-state normal
			       :perturb '((PP -))
			       :inherit '(PI ECW AFP WI)
			       :text "Low plasma protein")))
    (qsim init)
    (qsim-display init :reference-states `((normal ,normal))
		       :layout *starling-layout*)))

(defvar *small-starling-layout* '((ecw )
				  (afp pp cpp)
				  (wi  pi cpi)
				  (nfpi fwpi fwip)))
