;;; -*- Syntax: Common-lisp; Package: QSIM -*-
;       Copyright (c) 1987, Benjamin Kuipers.

; Try a variety of experiments, with water intake, or sodium level, up or down.

; Abstraction properties:
;   faster:             set of mechanisms
;   slower:             set of mechanisms
;   abstracted-from:    alist of (constraint mechanism)
;   abstracted-to:      set of (constraint corr-vals assumptions)

(defparameter slice-vars '(nfwip afp anp cnp))	; variables to see in each slice
(defparameter *starting-point* nil)		; initial state for tsa


(defun sodium-and-water-w-water-up ()
  (setq *latest-states* nil)
  (setq slice-vars '(nfwip afp anp cnp))
  (assert-time-relations
    '((water-balance (slower sodium-balance)
			   (faster))
      (sodium-balance (faster water-balance)
			    (slower))))
  (let ((normal (get-normal-state water-balance)))
    (setq *starting-point*
	  (make-modified-state normal
			       `((afp   (,(qvalue= (afp normal)) nil))
				 (anp   (,(qvalue= (anp normal)) std))
				 ;(nfnpu (,(qvalue= (nfnpu normal)) std))
				 (nfwip (,(qvalue+ (nfwip normal)) std)))
			       "Increased water intake."
			       ))
    (tsa-simulation *starting-point*)
    (HQD-display *starting-point* slice-vars)
    t))


(defun sodium-and-water-w-water-down ()
  (setq *latest-states* nil)
  (setq slice-vars '(nfwip afp anp cnp))
  (assert-time-relations
    '((water-balance (slower sodium-balance)
			   (faster))
      (sodium-balance (faster water-balance)
			    (slower))))
  (let ((normal (get-normal-state water-balance)))
    (setq *starting-point*
	  (make-modified-state normal
			       `((afp   (,(qvalue= (afp normal)) nil))
				 (anp   (,(qvalue= (anp normal)) std))
				 ;(nfnpu (,(qvalue= (nfnpu normal)) std))
				 (nfwip (,(qvalue- (nfwip normal)) std)))
			       "Decreased water intake."
			       ))
    (tsa-simulation *starting-point*)
    (HQD-display *starting-point* slice-vars)
    t))

(defun assert-time-relations (alist)
  (mapc #'(lambda (entry)
	    (let ((qde (eval (car entry))))	; because we have qde-NAMES here.
	      (mapc #'(lambda (clause)
			(replace-slot-contents qde (car clause) (cdr clause)))
		    (cdr entry))))
	alist))

(defun replace-slot-contents (qde slot contents)
  (let* ((other-slot (qde-other qde))
	 (clause (assoc slot other-slot)))
    (cond ((null clause)
	   (setf (qde-other qde) (cons (cons slot contents) other-slot)))
	  (t (setf (cdr clause) contents)))
    contents))


(defun sodium-and-water-w-sodium-level-up ()
  (setq *latest-states* nil)
  (setq slice-vars '(nfwip afp anp cnp))
  (assert-time-relations
    '((water-balance (slower sodium-balance)
			   (faster))
      (sodium-balance (faster water-balance)
			    (slower))))
  (let* ((normal (get-normal-state water-balance)))
    (setq *starting-point*
	  (make-modified-state normal
			       `((afp   (,(qvalue= (afp normal)) nil))
				 (anp   (,(qvalue+ (anp normal)) std))
				 ;(nfnpu (,(qvalue= (nfnpu normal)) std))
				 (nfwip (,(qvalue= (nfwip normal)) std)))
			       "Decreased sodium level."
			       ))
    (tsa-simulation *starting-point*)
    (HQD-display *starting-point* slice-vars)
    t))

(defun sodium-and-water-w-sodium-level-down ()
  (setq *latest-states* nil)
  (setq slice-vars '(nfwip afp anp cnp))
  (assert-time-relations
    '((water-balance (slower sodium-balance)
		     (faster))
      (sodium-balance (faster water-balance)
		      (slower))))
  (let ((normal (get-normal-state water-balance)))
    (setq *starting-point*
	  (make-modified-state normal
			       `((afp   (,(qvalue= (afp normal)) nil))
				 (anp   (,(qvalue- (anp normal)) std))
				 ;(nfnpu (,(qvalue= (nfnpu normal)) std))
				 (nfwip (,(qvalue= (nfwip normal)) std)))
			       "Decreased sodium level."
			       ))
    (tsa-simulation *starting-point*)
    (HQD-display *starting-point* slice-vars)
    t))
