;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-
(in-package :qsim)

; A crank rotates around an axis, with the end of the crank attached to
; a linear slider, which slides back and forth.

(define-QDE Slider-Crank-A
  (text "Rotary crank drives linear slider (0..180)")
  (quantity-spaces
    (theta         (0 90 180)  "theta: angular position")
    (x             (-1 0 +1)   "cos theta")
    (slider        (A B)       "slider position")	; this works without zero
    (dtheta        (0 DT* inf) "d theta"))
  (constraints
    ((d/dt theta dtheta))
    ((S- theta x (0 1) (180 -1))  (90 0))
    ((M+ x slider)                (-1 A) (+1 B))
    ((constant dtheta)))
  (transitions
    ((theta (180 inc)) -> inc-180)
    ((theta (0 dec))   -> dec-0))
  (layout (dtheta theta nil)
	  (nil    x     nil)
	  (nil    slider nil)
	  (nil))
  )

(define-QDE Slider-Crank-B
  (text "Rotary crank drives linear slider (180..360)")
  (quantity-spaces
    (theta      (180 270 360)  "theta: angular position")
    (x          (-1 0 +1)      "cos theta")
    (slider     (A B)          "slider position")
    (dtheta     (0 DT* inf)    "d theta"))
  (constraints
    ((d/dt theta dtheta))
    ((S+ theta x (180 -1) (360 1))  (270 0))
    ((M+ x slider)                (-1 A) (+1 B))
    ((constant dtheta)))
  (transitions
    ((theta (180 dec))  -> dec-180)
    ((theta (360 inc))  -> inc-360))
  (layout (dtheta theta nil)
	  (nil    x     nil)
	  (nil    slider nil)
	  (nil))
  )

; The transition functions for wrapping between 360 <-> 0 degrees.

(defun dec-0 (ostate)				; from slider-crank-A
  (create-transition-state :from-state   ostate
			   :to-qde       slider-crank-A
			   :assert       '((theta (360 dec)))
			   :inherit-qmag :rest
			   ))


(defun inc-180 (ostate)				; from slider-crank-A
  (create-transition-state :from-state   ostate
			   :to-qde       slider-crank-B
			   :inherit-qmag :all
			   ))


(defun dec-180 (ostate)				; from slider-crank-B
  (create-transition-state :from-state   ostate
			   :to-qde       slider-crank-A
			   :inherit-qmag :all
			   ))


(defun inc-360 (ostate)				; from slider-crank-B
  (create-transition-state :from-state   ostate
			   :to-qde       slider-crank-A
			   :assert       '((theta (0 inc)))
			   :inherit-qmag :rest
			   ))

; Rotate the crank in the positive theta direction.

(defun rotate-crank ()
  (let* ((sim (make-sim :cycle-detection nil))
	 (initial (make-new-state :from-qde slider-crank-a
				  :assert-values '((theta (0 nil))
						   (dtheta (dt* std)))
				  :text "Rotating crank."
				  :sim sim)))
    (qsim initial)
    (qsim-display initial)))