;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-
(in-package :qsim)
; Copyright (c) 1987, Benjamin Kuipers.

;  The sodium balance mechanism, as mediated by aldosterone.
;  for Q.  This mechanism is described in more detail in MIT LCS TM-280,
;  and in the Time-Scale Abstraction paper.

(define-QDE SODIUM-BALANCE
  (text "Sodium balance via aldosterone (naked qspaces)")
  (quantity-spaces
    (anp   (0 inf)       "amt(Na,P)")
    (afp   (0 inf)       "amt(water,P)")
    (cnh   (0 inf)       "c(natriuretic-hormones,P)")
    (ffnpu (0 inf)       "flow(Na,P->U)")
    (caldo (0 inf)       "c(aldosterone,P)")
    (rfnup (0 inf)       "reabs.flow(Na,U->P)")
    (nfnpu (0 inf)       "net flow(Na,P->U)")
    (nfnip (0 inf)       "net flow(Na,in->P)")
    (nfnp  (minf 0 inf)  "net change(Na,P)"))
  (constraints
    ((M+ anp afp)              (0 0) (inf inf))
    ((M+ afp cnh)              (0 0) (inf inf))
    ((M+ cnh ffnpu)            (0 0) (inf inf))
    ((M- afp caldo)            (0 inf) (inf 0) )
    ((M+ caldo rfnup)          (0 0) (inf inf))
    ((add rfnup nfnpu ffnpu))
    ((add nfnpu nfnp nfnip))
    ((d/dt anp nfnp))
    ((constant nfnip))))

(defvar *sodium-layout* '((anp afp)
			  (cnh caldo)
			  (ffnpu rfnup)
			  (nfnip nfnpu nfnp)))


(defun high-salt-intake ()
  (let* ((sim (make-sim :unreachable-values '((nfnpu 0) (anp 0 inf))))
	 (normal (make-new-state :from-qde      Sodium-Balance
				 :assert-values '((anp   ((0 inf) std))
						  (nfnip ((0 inf) std)))
				 :sim sim))
	 (init (make-new-state :from-state normal
			       :inherit '(anp)
			       :perturb '((nfnip +))
			       :text "High salt intake")))
    (qsim init)
    (qsim-display init :reference-states `((Normal ,normal))
		       :layout *sodium-layout*)))


(defun high-initial-salt-level ()
  (let* ((sim (make-sim :unreachable-values '((nfnpu 0) (anp 0 inf))))
	 (normal (make-new-state :from-qde      Sodium-Balance
				 :assert-values '((anp   ((0 inf) std))
						  (nfnip ((0 inf) std)))
				 :sim sim))
	 (init (make-new-state :from-state normal
			       :inherit '(nfnip)
			       :perturb '((anp +))
			       :text "High initial salt volume")))
    (qsim init)
    (qsim-display init :reference-states `((Normal ,normal))
		       :layout *sodium-layout*)))




