
;;; -*- Syntax: Common-Lisp; Package: QSIM -*-

(in-package 'QSIM)

(defun describe-curvature-constraints ()
  (format *qsim-report*
"~2%Curvature Constraints is used to curb the `chattering' phenomenon.  The
phenomenon arises when the direction of change of a parameter is
unconstrained.  For example, if NET = IN - OUT with both IN and OUT
increasing, the next important qualitative change is when NET reaches 0.
However, in the mean time, NET can change from increasing to steady to
decreasing arbitrarily many times, leading to a branch for each possibility.
Curvature Constraints manipulates the constraint model algebraically to
derive constraints on directions of change (curvature constraints).  This
technique makes the assumption that all the M constraints in the model
are `smooth':  that the second derivative of the monotonic function
does not contribute significantly to the behavior.

To turn on Curvature Constraints, set Perform ACC Analysis to Yes in the
QSIM control menus.  This technique eliminates spurious `chattering'.
See Ignore-Qdirs for a way to deal with genuine `chattering'."))