;;; -*- Mode: LISP; Syntax: Common-lisp; Package: QSIM; Base: 10 -*-

;;; Tank examples
;;;
;;; One Tank
;;; 

(define-model TANK1 "One Tank" hydraulic
	      (components (T tank (landmarks (amount (0 inf))) (initable amount))
			  (S1 source (landmarks (flow (minf OUT* 0))) (initable flow))
			  (S2 sink))
	      (connections (p1 (s1 out) (t in))
			   (p2 (t out) (s2 in))))

(defun ONE-TANK-SIM ()
  (declare (special tank1-qde))
  (let ((initial-state (make-initial-state tank1-qde
					   '((s1.flow (OUT* std))
					     (t.amount (0 nil)))
					   "Fill an empty tank")))
    (qsim initial-state)
    (qsim-display initial-state)
    ))

(defun cc-one-tank ()
  (cc-demo TANK1 #'ONE-TANK-SIM))


;;;
;;; Two Tank
;;;

(define-model TANK2 "Two Cascaded Tanks" hydraulic
	      (components (T1 tank (landmarks (amount (0 inf))) (initable amount))
			  (T2 tank (landmarks (amount (0 inf))) (initable amount))
			  (S1 source (landmarks (flow (minf OUT* 0))))
			  (S2 sink))
	      (connections (p1 (s1 out) (t1 in))
			   (p2 (t1 out) (t2 in))
			   (p3 (t2 out) (s2 in))))

(defun TWO-TANK-SIM ()
  (declare (special tank2-qde))
  (let ((initial-state (make-initial-state TANK2-QDE
					   '((s1.flow (OUT* std))
					     (t1.amount (0 nil))
					     (t2.amount (0 nil)))
					   "Fill two empty cascaded tanks")))
    (qsim initial-state)
    (qsim-display initial-state)
    ))


(defun cc-two-tanks ()
  (cc-demo TANK2 #'TWO-TANK-SIM))


;;;
;;; Circuit Examples
;;;

;;;
;;; RC (Resistor-Capacitor) Circuit
;;; 

(define-model RC1 "Resistor-Capacitor-Circuit" electrical
	      (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
			  (R resistor (landmarks (r R*)))
			  (C capacitor (landmarks (c C*)) (initable q)))
	      (connections (w1 (b t1) (r t1))
			   (w2 (r t2) (c t1))
			   (w3 (c t2) (b t2))))

(defun RC-SIM ()
  (declare (special rc1-qde))
  (let ((initial-state (make-initial-state rc1-qde
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (c.c (C* std))
					     (r.r (R* std))
					     (c.q (0 nil))
					     (w3.i2 ((0 inf) nil))
					     )
					   "Charging Capacitor through Resistor")))
    (qsim initial-state)
    (qsim-display initial-state)
    ))


(defun cc-rc ()
  (cc-demo RC1 #'RC-SIM))



;;;
;;; Voltage Divider (Resisters in series)
;;;

(define-model VD1 "Voltage-Divider-Circuit" electrical
	      (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
			  (R1 resistor (landmarks (r R1*)))
			  (R2 resistor (landmarks (r R2*))))
	      (connections (w1 (b t1) (r1 t1))
			   (w2 (r1 t2) (r2 t1))
			   (w3 (r2 t2) (b t2))))

(defun VOLTAGE-DIVIDER-SIM ()
  (declare (special vd1-qde))
  (let ((initial-state (make-initial-state vd1-qde
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (r1.r (R1* std))
					     (r2.r (R2* std))
					     (w3.i2 ((0 inf) nil))
					     )
					   "Voltage-divider (Resistors in series)")))
    (qsim initial-state)
    (qsim-display initial-state)
    ))

(defun cc-vd ()
  (cc-demo VD1 #'VOLTAGE-DIVIDER-SIM))


;;;
;;; RC High-Pass Filter
;;;

(define-model RCHP1 "RC High-Pass Filter" electrical
	      (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
			  (C1 capacitor (landmarks (c C1*)) (initable q))
			  (R1 resistor (landmarks (r R1*))))
	      (connections (w1 (b t1) (c1 t1))
			   (w2 (c1 t2) (r1 t1))
			   (w3 (r1 t2) (b t2))))


(defun RC-HIGH-PASS-FILTER-SIM ()
  (declare (special rchp1-qde))
  (let ((initial-state (make-initial-state rchp1-qde
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (c1.c (C1* std))
					     (r1.r (R1* std))
					     (c1.q (0 nil))
					     (w3.i2 ((0 inf) nil))
						)
					   "RC High-Pass Filter")))
    (qsim initial-state)
    (qsim-display initial-state)
    ))

(defun cc-rchp ()
  (cc-demo RCHP1 #'RC-HIGH-PASS-FILTER-SIM))


;;;
;;; RC-LADDER
;;;

(define-model RC-LADDER "RC Ladder" electrical
	      (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
			  (C1 capacitor (landmarks (c C1*)) (initable q))
			  (R1 resistor (landmarks (r R1*)))
			  (C2 capacitor (landmarks (c C2*)) (initable q))
			  (R2 resistor (landmarks (r R2*))))
	      (connections (w1 (b t1) (r1 t1))
			   (w2 (r1 t2) (c1 t1) (r2 t1))
			   (w3 (r2 t2) (c2 t1))
			   (w4 (c1 t2) (c2 t2) (b t2))))

(defun RC-LADDER-SIM ()
  (declare (special rc-ladder-qde))
  (let ((initial-state (make-initial-state rc-ladder-qde
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (c1.c (C1* std))
					     (r1.r (R1* std))
					     (c2.c (C2* std))
					     (r2.r (R2* std))
					     (c1.q (0 nil))
					     (c2.q (0 nil))
					     (w4.i3 ((0 inf) nil))
					     )
					   "RC Ladder")))
    (qsim initial-state)
    (qsim-display initial-state)
    ))

(defun cc-rc-ladder ()
  (cc-demo RC-LADDER #'RC-LADDER-SIM))

;;;
;;; Wheatstone Bridge
;;;
(define-model WB1 "Wheatstone Bridge" electrical
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (R1 resistor (landmarks (r R1*)))
	      (R2 resistor (landmarks (r R2*)))
	      (R3 resistor (landmarks (r R3*)))
	      (R4 resistor (landmarks (r R4*)))
	      (R5 resistor (landmarks (r R5*)))
	      )
  (connections (w1 (b t1)  (r1 t1) (r2 t1))
	       (w2 (r1 t2) (r3 t1) (r5 t2))
	       (w3 (r2 t2) (r4 t1) (r5 t1))
	       (w4 (r3 t2) (r4 t2) (b t2))))

(defun WHEATSTONE-BRIDGE-SIM ()
  (declare (special wb1-qde))
  (let ((initial-state (make-initial-state wb1-qde
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (r1.r (R1* std))
					     (r2.r (R2* std))
					     (r3.r (R3* std))
					     (r4.r (R4* std))
					     (r5.r (R5* std))
					     (w4.i3 (0 nil))
					     )
					   "Wheatstone Bridge")))
    (qsim initial-state)
    (qsim-display initial-state)
    ))

(defun cc-wb ()
  (cc-demo WB1 #'WHEATSTONE-BRIDGE-SIM))


;;;
;;; LC (Inductor-Capacitor) Circuit
;;; 

(define-model LC-A1 "Inductor-Capacitor-Circuit" electrical
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (I inductor-a (landmarks (l (minf L* 0 inf))))
	      (C capacitor (landmarks (c C*)) (initable q)))
  (connections (w1 (b t1) (i t1))
	       (w2 (i t2) (c t1))
	       (w3 (c t2) (b t2))))


(defun LC-A-SIM ()
  (declare (special lc-a1-qde))
  (let ((initial-state (make-initial-state lc-a1-qde
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (c.c (C* std))
					     (i.l (L* std))
					     (c.q (0 nil))
					     (w3.i2 (0 nil))
					     )
					   "Charging Capacitor through Inductor")))
    (qsim initial-state)
    (qsim-display initial-state)
    ))

(defun cc-lc-a ()
  (cc-demo LC-A1 #'LC-A-SIM))


(define-model LC-B1 "Inductor-Capacitor-Circuit" electrical
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (I inductor-b (landmarks (l (minf L* 0 inf))))
	      (C capacitor (landmarks (c C*)) (initable q)))
  (connections (w1 (b t1) (i t1))
	       (w2 (i t2) (c t1))
	       (w3 (c t2) (b t2))))


(defun LC-B-SIM ()
  (declare (special lc-b1-qde))
  (let ((initial-state (make-initial-state lc-b1-qde
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (c.c (C* std))
					     (i.l (L* std))
					     (c.q (0 nil))
					     (w3.i2 (0 nil))
					     )
					   "Charging Capacitor through Inductor")))
    (qsim initial-state)
    (qsim-display initial-state)
    ))

(defun cc-lc-b ()
  (cc-demo LC-B1 #'LC-B-SIM))



