;;; -*- Syntax: Common-Lisp; Package: QSIM -*-

(in-package 'QSIM)

(defun describe-analytic-function ()
  (format *qsim-report*
"~2%QSIM requires that variables be continuously differentiable functions
of time.  This guarantees that the qualitative state of a variable
changes in orderly transitions from one state to adjacent ones.  Under
many circumstances in analysis, however, one restricts one's attention
to Analytic Functions:  functions whose higher-order derivatives exist
for all orders over the domain of interest.  Fortunately, most of the
familiar mathematical functions --- polynomials, exponentials,
trigonometric functions, etc --- are analytic at all points where they
are defined.

An important fact concerning analytic functions is that, if a function
is analytic over an interval, and is constant over any open sub-interval,
it must be constant over the entire interval.  However, if we allow
non-analytic solutions, we obtain additional intuitively reasonable
solutions.  For example, in the two-cascaded-tanks, this allows the
level of water in the upper tank to reach its final value and remain
constant while the lower tank continues to fill.

To restrict attention to analytic solutions only, set Analytic Functions
Only to Yes in the QSIM control menus.  An example of needing to set
this flag in QSIM is when using Curvature Constraints."))