;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

;;;  $Id: acc-5-cascaded-tanks.lisp,v 1.3 1991/09/16 14:11:05 clancy Exp $
(in-package :qsim)
; Part III of chatter2.

; Five cascaded-tanks. 
;  1. Five-cascaded-tanks with no curvature constraints.
;  2. Five-cascaded-tanks with automatic calculation of curvature constraints.
;  3. Five-cascaded-tanks with automatic calculation of curvature constraints
;     and sd3-constraints.

(define-QDE Five-cascaded-tanks
  (text "Five cascaded tanks")
  (quantity-spaces
    (amounta    ( 0    inf)   "amount(A)")
    (inflowa    ( 0    inf)   "flow(ext->A)")
    (outflowa   ( 0    inf)   "flow(A->b)")
    (netflowa   (minf 0 inf)  "d amount(A)")
    (amountb    ( 0    inf)   "amount(B)")
    (inflowb    ( 0    inf)   "flow(a->B)")
    (outflowb   ( 0    inf)   "flow(B->out)")
    (netflowb   (minf 0 inf)  "d amount(B)")
    (amountc    ( 0    inf)   "amount(C)")
    (inflowc    ( 0    inf)   "flow(b->C)")
    (outflowc   ( 0    inf)   "flow(C->out)")
    (netflowc   (minf 0 inf)  "d amount(C)")
    (amountd    ( 0    inf)   "amount(D)")
    (inflowd    ( 0    inf)   "flow(c->D)")
    (outflowd   ( 0    inf)   "flow(D->out)")
    (netflowd   (minf 0 inf)  "d amount(D)")
    (amounte    ( 0   inf)    "amount(E)")
    (inflowe    ( 0   inf)    "flow(d->E)")
    (outflowe   ( 0   inf)    "flow(E->out)")
    (netflowe   (minf 0 inf)  "d amount(E)")
    )
  (constraints
    ((M+    amounta   outflowa        )     (0 0)    (inf inf))
    ((add   outflowa  netflowa inflowa))
    ((d/dt amounta   netflowa        ))
    ((M+    outflowa  inflowb         )     (0 0)    (inf inf))	; a -> b
    ((M+    amountb   outflowb        )     (0 0)    (inf inf))
    ((add   outflowb  netflowb inflowb))
    ((d/dt amountb   netflowb        ))
    ((M+    outflowb  inflowc         )     (0 0)    (inf inf))	; b -> c
    ((M+    amountc   outflowc        )     (0 0)    (inf inf))
    ((add   outflowc  netflowc inflowc))
    ((d/dt amountc   netflowc        ))
    ((M+    outflowc  inflowd         )     (0 0)    (inf inf))	; c -> d
    ((M+    amountd   outflowd        )     (0 0)    (inf inf))
    ((add   outflowd  netflowd inflowd))
    ((d/dt amountd   netflowd        ))
    ((M+    outflowd  inflowe         )     (0 0)    (inf inf))	; d -> e
    ((M+    amounte   outflowe        )     (0 0)    (inf inf))
    ((add   outflowe  netflowe inflowe))
    ((d/dt amounte   netflowe        ))
    ((constant inflowa))
    )
  (layout
     (amounta  amountb  amountc  amountd amounte)
     (inflowa  inflowb  inflowc  inflowd inflowe)
     (outflowa outflowb outflowc outflowd outflowe)
     (netflowa netflowb netflowc netflowd netflowe)))

; Five-cascaded-tanks:  fill-from-empty and increase-inflow-rate
;   1.  No curvature constraints:  (acc = nil; sd3 = nil)
;   2.  Automatic derivation of curvature constraints:  (acc = t; sd3 = nil)
;   3.  Automatic curvature and sd3 constraints:  (acc = t; sd3 = t)
;       It will derive:
;	 (sd3-constraint ((netflowe (add (sd1 netflowc)(minus (sd1 netflowd))))
;			  (netflowd (add (sd1 netflowb)(minus (sd1 netflowc))))
;			  (netflowc (add (sd1 netflowa)(minus (sd1 netflowb))))
;			  (netflowb (minus (sd1 netflowa)))))

(defun increase-5-cascade-inflow-rate (acc sd3)
  (setf (qde-derived-sd2-expressions five-cascaded-tanks) nil)
  (let* ((sim (make-sim :HOD-constraints acc
			:SD3-constraints sd3
			:state-limit 30
			:analytic-functions-only t))
	 (normal (make-new-state :from-qde Five-cascaded-tanks
				 :assert-values '((inflowa ((0 inf) std))
						  (amounta ((0 inf) std))
						  (amountb ((0 inf) std))
						  (amountc ((0 inf) std))
						  (amountd ((0 inf) std))
						  (amounte ((0 inf) std)))
				 :sim sim))
	 (init (make-new-state :from-state normal
			       :perturb '((inflowa +))
			       :inherit '(amounta amountb amountc amountd amounte))))
    (qsim init)
    (qsim-display init :reference-states `((normal ,normal)))))

(defun fill-5-cascade-from-empty (acc sd3)
  (setf (qde-derived-sd2-expressions five-cascaded-tanks) nil)
  (let* ((sim (make-sim :HOD-constraints acc
			:SD3-constraints sd3
			:state-limit 30
			:analytic-functions-only t))
	 (init (make-new-state :from-qde five-cascaded-tanks
			       :assert-values '((inflowa ((0 inf) std))
						(amounta (0 nil))
						(amountb (0 nil))
						(amountc (0 nil))
						(amountd (0 nil))
						(amounte (0 nil)))
			       :sim sim)))
    (qsim init)
    (qsim-display init)))
